/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.services;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import com.euphoriapatches.euphoria_patcher.services.ShaderNamingService;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import com.euphoriapatches.euphoria_patcher.util.ArchiveUtils;
import com.euphoriapatches.shadow.io.sigpipe.jbsdiff.InvalidHeaderException;
import com.euphoriapatches.shadow.io.sigpipe.jbsdiff.ui.FileUI;
import com.euphoriapatches.shadow.org.apache.commons.compress.archivers.ArchiveException;
import com.euphoriapatches.shadow.org.apache.commons.compress.compressors.CompressorException;
import com.euphoriapatches.shadow.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;

public class ShaderPatchingService {
    private final String patchName;
    private final String patchVersion;
    private final String commonLocation;
    private final Path shaderpacks;
    private final ShaderNamingService namingService;

    public ShaderPatchingService(String patchName, String patchVersion, String commonLocation, Path shaderpacks, ShaderNamingService namingService) {
        this.patchName = patchName;
        this.patchVersion = patchVersion;
        this.commonLocation = commonLocation;
        this.shaderpacks = shaderpacks;
        this.namingService = namingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processAndPatchShaders(ShaderDetector.ShaderInfo info, Path temp) {
        try {
            if (info.baseFile == null) {
                boolean bl = false;
                return bl;
            }
            String baseName = info.baseFile.getFileName().toString().replace(".zip", "");
            baseName = this.namingService.cleanBaseName(baseName);
            String patchedName = baseName + " + " + this.patchName + this.patchVersion;
            Path baseExtracted = temp.resolve(baseName);
            if ((baseExtracted = ArchiveOperations.extract(info.baseFile, baseExtracted, "extracting archive")) == null) {
                boolean bl = false;
                return bl;
            }
            this.normalizeShaderStyleInCommon(baseExtracted);
            Path baseArchived = temp.resolve(baseName + ".tar");
            baseArchived = ArchiveOperations.archive(baseExtracted, baseArchived);
            if (baseArchived != null && !ArchiveOperations.verifyBaseArchive(baseArchived, info.baseFile.getFileName().toString())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.applyPatch(baseArchived, temp, patchedName, info.styleUnbound, info.styleReimagined);
            return bl;
        }
        finally {
            ArchiveOperations.deleteTempDirectory(temp);
        }
    }

    public void normalizeShaderStyleInCommon(Path baseExtracted) {
        try {
            Path commons = baseExtracted.resolve(this.commonLocation);
            String config = FileUtils.readFileToString(commons.toFile(), "UTF-8").replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
            FileUtils.writeStringToFile(commons.toFile(), config, "UTF-8");
        }
        catch (IOException e) {
            this.log(3, "Error normalizing shader style in common file: " + e.getMessage());
        }
    }

    public boolean applyPatch(Path baseArchived, Path temp, String patchedName, boolean styleUnbound, boolean styleReimagined) {
        Path patchedArchive = temp.resolve(patchedName + ".tar");
        Path patchedFile = this.shaderpacks.resolve(patchedName);
        return this.applyProductionPatch(baseArchived, patchedArchive, temp.resolve(patchedName + ".patch"), patchedFile, styleUnbound, styleReimagined);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean applyProductionPatch(Path baseArchived, Path patchedArchive, Path patchFile, Path patchedFile, boolean styleUnbound, boolean styleReimagined) {
        String patchResourceName = this.patchName + this.patchVersion + ".patch";
        this.debugLog("Attempting to load patch resource: " + patchResourceName);
        try {
            InputStream patchStream = this.getClass().getClassLoader().getResourceAsStream(patchResourceName);
            try {
                if (patchStream != null) {
                    this.debugLog("Patch resource found, copying to: " + patchFile);
                    FileUtils.copyInputStreamToFile(Objects.requireNonNull(patchStream), patchFile.toFile());
                    this.debugLog("Applying patch from " + baseArchived + " to " + patchedArchive);
                    FileUI.patch(baseArchived.toFile(), patchedArchive.toFile(), patchFile.toFile());
                    this.debugLog("Extracting patched archive to: " + patchedFile);
                    try {
                        ArchiveUtils.extract(patchedArchive, patchedFile);
                    }
                    catch (ArchiveException | IOException e) {
                        this.log(2, "Error extracting archive: " + e.getMessage());
                        this.debugLog("Error extracting archive: " + e.getMessage());
                        boolean bl = false;
                        if (patchStream == null) return bl;
                        patchStream.close();
                        return bl;
                    }
                    this.debugLog("Applying style settings...");
                    this.applyStyleSettings(patchedFile, styleUnbound, styleReimagined);
                    this.log(1, this.patchName + " was successfully installed. Enjoy! -SpacEagle17");
                    boolean bl = true;
                    return bl;
                }
                this.debugLog("CRITICAL ERROR: Patch resource not found: " + patchResourceName);
                this.log(3, 12, "========================");
                this.log(3, 12, "CRITICAL BUILD ERROR");
                this.log(3, 12, "========================");
                this.log(3, 12, "Patch file not found in mod resources!");
                this.log(3, 12, "Expected: " + patchResourceName);
                this.log(3, 12, "");
                this.log(3, 12, "This indicates the mod was built incorrectly.");
                this.log(3, 12, "The patch file should be in the JAR resources.");
                this.log(3, 12, "");
                this.log(3, 12, "Please report this issue to the mod developer");
                this.log(3, 12, "at: https://github.com/EuphoriaPatches/EuphoriaPatcher/issues");
                this.log(3, 12, "========================");
                return false;
            }
            finally {
                if (patchStream != null) {
                    try {
                        patchStream.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (InvalidHeaderException | CompressorException | IOException e) {
            this.debugLog("Error applying patch file: " + e.getMessage());
            this.log(3, "Error applying patch file: " + e.getMessage());
            this.log(3, EuphoriaLogger.getStackTrace(e));
        }
        return false;
    }

    public void applyStyleSettings(Path patchedFile, boolean styleUnbound, boolean styleReimagined) throws IOException {
        if (!styleUnbound && !styleReimagined) {
            return;
        }
        File commons = new File(patchedFile.toFile(), this.commonLocation);
        String commonContent = FileUtils.readFileToString(commons, "UTF-8");
        String reimaginedConfig = commonContent.replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 1");
        String unboundConfig = commonContent.replaceFirst("SHADER_STYLE [14]", "SHADER_STYLE 4");
        if (!styleReimagined) {
            FileUtils.writeStringToFile(commons, unboundConfig, "UTF-8");
            return;
        }
        if (!styleUnbound) {
            FileUtils.writeStringToFile(commons, reimaginedConfig, "UTF-8");
            return;
        }
        boolean isReimagined = patchedFile.getFileName().toString().contains("Reimagined");
        String otherStyle = isReimagined ? "Unbound" : "Reimagined";
        String currentStyle = isReimagined ? "Reimagined" : "Unbound";
        File otherStyleFile = new File(patchedFile.getParent().toFile(), patchedFile.getFileName().toString().replace(currentStyle, otherStyle));
        if (!otherStyleFile.exists()) {
            this.debugLog("Creating missing " + otherStyle + " style from newly patched " + currentStyle);
            FileUtils.copyDirectory(patchedFile.toFile(), otherStyleFile);
            if (isReimagined) {
                FileUtils.writeStringToFile(new File(otherStyleFile, this.commonLocation), unboundConfig, "UTF-8");
            } else {
                FileUtils.writeStringToFile(new File(otherStyleFile, this.commonLocation), reimaginedConfig, "UTF-8");
            }
        } else {
            this.debugLog("Other style (" + otherStyle + ") already exists, not overwriting");
        }
        if (isReimagined) {
            FileUtils.writeStringToFile(commons, reimaginedConfig, "UTF-8");
        } else {
            FileUtils.writeStringToFile(commons, unboundConfig, "UTF-8");
        }
    }

    private void log(int level, String message) {
        EuphoriaPatcher.log(level, message);
    }

    private void log(int level, int fadeTimer, String message) {
        EuphoriaPatcher.log(level, fadeTimer, message);
    }

    private void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderPatchingService] " + message);
    }
}

