/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.services;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import com.euphoriapatches.euphoria_patcher.util.ShaderPropertyReader;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import com.euphoriapatches.shadow.org.apache.commons.io.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;

public class ShaderNamingService {
    private static final Pattern CLEAN_BASE_NAME_PATTERN = Pattern.compile("(?i)(?:[\\s_-]+(?:\\(copy\\)|copy|\\(\\d+\\)|\\d+))+$");
    private final String brandName;
    private final String patchName;
    private final String version;
    private final String patchVersion;
    private final String commonLocation;
    private final String shaderMyFileLocation;
    private final Path shaderpacks;
    private final ShaderDetector shaderDetector;

    public ShaderNamingService(String brandName, String patchName, String version, String patchVersion, String commonLocation, String shaderMyFileLocation, Path shaderpacks, ShaderDetector shaderDetector) {
        this.brandName = brandName;
        this.patchName = patchName;
        this.version = version;
        this.patchVersion = patchVersion;
        this.commonLocation = commonLocation;
        this.shaderMyFileLocation = shaderMyFileLocation;
        this.shaderpacks = shaderpacks;
        this.shaderDetector = shaderDetector;
    }

    public String cleanBaseName(String baseName) {
        if (baseName == null) {
            return null;
        }
        this.debugLog("Before Cleaning base name: " + baseName);
        String cleaned = CLEAN_BASE_NAME_PATTERN.matcher(baseName).replaceAll("");
        cleaned = cleaned.replaceAll("\\s+", " ").trim();
        this.debugLog("Cleaned base name: " + cleaned);
        return cleaned;
    }

    public Path renameToCorrectShaderName(Path path) {
        try {
            String style;
            String fileName = path.getFileName().toString();
            if (fileName.contains("Unbound")) {
                style = "Unbound";
            } else if (fileName.contains("Reimagined")) {
                style = "Reimagined";
            } else {
                style = ShaderPropertyReader.detectStyleFromCommonFile(path, this.commonLocation);
                this.debugLog("Detected " + style + " style from common.glsl file");
            }
            String correctName = this.brandName + style + this.version;
            if (fileName.endsWith(".zip")) {
                correctName = correctName + ".zip";
            }
            if (fileName.equals(correctName)) {
                return path;
            }
            Path targetPath = path.resolveSibling(correctName);
            if (Files.exists(targetPath, new LinkOption[0])) {
                this.debugLog("A file with the correct name already exists: " + targetPath.getFileName());
                return path;
            }
            Path renamedPath = Files.move(path, targetPath, new CopyOption[0]);
            this.log(0, "Renamed shader from \"" + fileName + "\" to \"" + correctName + "\"");
            return renamedPath;
        }
        catch (IOException e) {
            this.log(2, "Failed to rename shader: " + e.getMessage());
            return path;
        }
    }

    public Path getPatchedShaderPath(Path baseFile) {
        if (baseFile == null) {
            this.log(3, "Cannot create patched shader path - base file is null");
            return null;
        }
        try {
            String fileName = baseFile.getFileName().toString();
            String baseName = fileName.endsWith(".zip") ? fileName.replace(".zip", "") : fileName;
            baseName = this.cleanBaseName(baseName);
            return baseFile.resolveSibling(baseName + " + " + this.patchName + this.patchVersion);
        }
        catch (Exception e) {
            this.log(3, "Error creating patched shader path: " + e.getMessage());
            return null;
        }
    }

    public void createAlternativeShaderNames(Path patchedShaderPath, boolean isAlreadyInstalled, String alternativeShaderNames) {
        String[] alternativeNames;
        this.debugLog("createAlternativeShaderNames called with isAlreadyInstalled: " + isAlreadyInstalled);
        if (alternativeShaderNames.isEmpty()) {
            this.debugLog("No alternative shader names configured.");
            return;
        }
        String baseVersion = this.version.replace("_", "");
        String patchVersionClean = this.patchVersion.replace("_", "");
        String illegalChars = "[\\\\/:*?\"<>|]";
        for (String name : alternativeNames = alternativeShaderNames.split(",")) {
            String trimmedName = name.trim();
            if (trimmedName.isEmpty()) continue;
            String finalName = trimmedName.replace("{baseVersion}", baseVersion).replace("{patchVersion}", patchVersionClean);
            if (finalName.matches(".*" + illegalChars + ".*")) {
                this.log(2, "Skipping alternative shader name with illegal characters: \"" + finalName + "\"");
                continue;
            }
            Path targetPath = this.shaderpacks.resolve(finalName);
            if (isAlreadyInstalled) {
                if (Files.exists(targetPath, new LinkOption[0])) {
                    try {
                        boolean isCorrupted;
                        boolean bl = isCorrupted = !this.shaderDetector.hasEuphoriaFile(targetPath);
                        if (isCorrupted) {
                            this.debugLog("Found corrupted alternative shader \"" + finalName + "\", regenerating...");
                            ArchiveOperations.deleteRecursively(targetPath);
                            this.createShaderCopy(patchedShaderPath, finalName);
                            continue;
                        }
                        this.debugLog("Alternative shader \"" + finalName + "\" exists and is valid, skipping.");
                    }
                    catch (IOException e) {
                        this.log(2, "Error verifying alternative shader \"" + finalName + "\": " + e.getMessage());
                    }
                    continue;
                }
                this.debugLog("Alternative shader \"" + finalName + "\" doesn't exist (user may have deleted it), skipping creation.");
                continue;
            }
            this.createShaderCopy(patchedShaderPath, finalName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createShaderCopy(Path sourceShaderPath, String newName) {
        try {
            Path shaderpacks = sourceShaderPath.getParent();
            Path targetPath = shaderpacks.resolve(newName);
            if (Files.exists(targetPath, new LinkOption[0])) {
                Path myFilePath = targetPath.resolve(this.shaderMyFileLocation);
                if (Files.exists(myFilePath, new LinkOption[0])) {
                    String firstLine;
                    try (BufferedReader reader = Files.newBufferedReader(myFilePath);){
                        firstLine = reader.readLine();
                    }
                    if (firstLine != null && firstLine.startsWith("// Euphoria Patches")) {
                        String fileVersion = firstLine.replace("// Euphoria Patches ", "").trim();
                        String expectedVersion = this.patchVersion.replace("_", "");
                        if (!VersionComparator.isNewerVersion(expectedVersion, fileVersion)) {
                            this.debugLog("Skipping creation of alternative shader name \"" + newName + "\" as it already exists with current version.");
                            return;
                        }
                        this.debugLog("Found outdated alternative shader \"" + newName + "\" (version " + fileVersion + "), updating to " + expectedVersion);
                        ArchiveOperations.deleteRecursively(targetPath);
                    } else {
                        this.debugLog("Found existing shader with name \"" + newName + "\" but couldn't verify version, replacing it.");
                        ArchiveOperations.deleteRecursively(targetPath);
                    }
                } else {
                    this.debugLog("Found existing shader with name \"" + newName + "\" but it doesn't appear to be a valid Euphoria shader, replacing it.");
                    ArchiveOperations.deleteRecursively(targetPath);
                }
            }
            this.log(0, "Creating alternative shader names from: " + sourceShaderPath.getFileName());
            this.debugLog("Creating alternative shader with name: \"" + newName + "\"");
            FileUtils.copyDirectory(sourceShaderPath.toFile(), targetPath.toFile());
            this.log(0, "Successfully created alternative shader: \"" + newName + "\"");
            return;
        }
        catch (IOException e) {
            this.log(2, "Error creating alternative shader \"" + newName + "\": " + e.getMessage());
        }
    }

    private void log(int level, String message) {
        EuphoriaPatcher.log(level, message);
    }

    private void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderNamingService] " + message);
    }
}

