/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.services;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderNamingService;
import com.euphoriapatches.euphoria_patcher.services.ShaderValidator;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import com.euphoriapatches.euphoria_patcher.util.FileOperations;
import com.euphoriapatches.euphoria_patcher.util.JsonUtilReader;
import com.euphoriapatches.euphoria_patcher.util.ShaderData;
import com.euphoriapatches.euphoria_patcher.util.ShaderPropertyReader;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ShaderDetector {
    private static final Map<Path, Boolean> euphoriaShaderCache = new ConcurrentHashMap<Path, Boolean>();
    private static final Map<Path, Optional<String>> versionCache = new ConcurrentHashMap<Path, Optional<String>>();
    private final String brandName;
    private final String patchName;
    private final String version;
    private final String patchVersion;
    private final String commonLocation;
    private final String shaderMyFileLocation;
    private final Path shaderpacks;
    private final ShaderValidator shaderValidator;
    private int totalFilesToScan = 0;
    private final String buildDateStr;
    private final Integer currentBuildDate;
    private static final Pattern numberedDevPattern = Pattern.compile("Comp.*EuphoriaPatches_(\\d+\\.\\d+\\.\\d+)-dev\\d+\\.zip");
    private static final Pattern earlyDevPattern = Pattern.compile("EuphoriaPatches_earlyDev_(\\d{4}-\\d{2}-\\d{2})\\.zip");
    private static boolean hasAnyDevVersion = false;

    public ShaderDetector(String brandName, String patchName, String version, String patchVersion, String commonLocation, String shaderMyFileLocation, Path shaderpacks) {
        this.brandName = brandName;
        this.patchName = patchName;
        this.version = version;
        this.patchVersion = patchVersion;
        this.commonLocation = commonLocation;
        this.shaderMyFileLocation = shaderMyFileLocation;
        this.shaderpacks = shaderpacks;
        this.shaderValidator = new ShaderValidator();
        this.buildDateStr = JsonUtilReader.getString("buildDate");
        this.currentBuildDate = this.parseBuildDate(this.buildDateStr);
    }

    public ShaderInfo detectInstalledShaders(ShaderNamingService namingService) {
        ShaderInfo info = new ShaderInfo();
        try {
            this.checkForExistingPatchedShaders(info);
            if (info.isAlreadyInstalled) {
                boolean successfulDataRead = this.checkForMissingStyle(info);
                if (!info.isAlreadyInstalled) {
                    this.debugLog("Found missing style to patch: " + (info.styleReimagined ? "Unbound" : "Reimagined"));
                    return info;
                }
                if (successfulDataRead) {
                    if (info.styleReimagined && info.styleUnbound) {
                        this.debugLog("Both styles already installed, skipping detection");
                    } else {
                        this.debugLog("User does not have the other style base shader installed, skipping detection");
                    }
                } else {
                    this.debugLog("Could not read data.json, skipping detection");
                }
                return info;
            }
            ArrayList potentialShaderPaths = new ArrayList();
            try (Object stream = Files.newDirectoryStream(this.shaderpacks, path -> this.isBrandNameShader((Path)path, true));){
                stream.forEach(potentialShaderPaths::add);
            }
            stream = Files.newDirectoryStream(this.shaderpacks, path -> this.isBrandNameShader((Path)path, false));
            try {
                stream.forEach(potentialShaderPaths::add);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
            for (Path path2 : potentialShaderPaths) {
                this.processShaderPath(path2, info, namingService);
                if (!info.styleReimagined || !info.styleUnbound) continue;
                break;
            }
            if (info.baseFile == null) {
                this.log(2, 0, "No shaders with expected name pattern found, checking via byte size...");
                this.log(2, 0, "If you have a lot of shaders installed, this may take a while. Please be patient.");
                this.log(2, 0, "Please wait... \n");
                Path shaderByByteSize = this.findShaderByByteSize(namingService);
                if (shaderByByteSize != null) {
                    this.log(0, "Found valid shader by byte size: " + shaderByByteSize.getFileName());
                    String name = shaderByByteSize.getFileName().toString();
                    info.styleReimagined = name.contains("Reimagined") || !name.contains("Unbound");
                    info.styleUnbound = name.contains("Unbound");
                    info.baseFile = shaderByByteSize;
                    this.checkIfAlreadyInstalled(shaderByByteSize, info, namingService);
                }
            }
        }
        catch (IOException e) {
            this.log(3, "Error reading shaderpacks directory: " + e.getMessage());
        }
        return info;
    }

    public void checkForExistingPatchedShaders(ShaderInfo info) {
        try {
            if (this.checkForNewerDevVersion(info)) {
                return;
            }
            DirectoryStream.Filter<Path> patchedFilter = path -> path.getFileName().toString().contains(this.brandName) && path.getFileName().toString().contains(" + " + this.patchName + this.patchVersion) && (Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip"));
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks, patchedFilter);){
                for (Path path2 : stream) {
                    this.checkIfAlreadyInstalled(path2, info, null);
                    if (!info.isAlreadyInstalled) continue;
                    return;
                }
            }
            this.debugLog("No existing patched shaders found by standard naming pattern, checking for Euphoria Patches files...");
            stream = Files.newDirectoryStream(this.shaderpacks, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            try {
                if (info.isAlreadyInstalled) {
                    return;
                }
                for (Path directory : stream) {
                    String firstLine;
                    Path myFilePath = directory.resolve(this.shaderMyFileLocation);
                    this.debugLog("Checking directory: " + directory.getFileName() + " for myFile.glsl");
                    if (!Files.exists(myFilePath, new LinkOption[0])) continue;
                    this.debugLog("Found myFile.glsl in directory: " + directory.getFileName());
                    try (BufferedReader reader = Files.newBufferedReader(myFilePath);){
                        firstLine = reader.readLine();
                    }
                    if (firstLine == null || !firstLine.startsWith("// Euphoria Patches")) continue;
                    String fileVersion = firstLine.replace("// Euphoria Patches ", "").trim();
                    String expectedVersion = this.patchVersion.replace("_", "");
                    this.debugLog("Found potential correct Euphoria Patches version in: " + directory.getFileName());
                    this.debugLog("File version: " + fileVersion + ", Expected: " + expectedVersion);
                    int comparison = VersionComparator.compareVersionStrings(fileVersion, expectedVersion);
                    if (comparison < 0) continue;
                    String dirName = directory.getFileName().toString();
                    if (dirName.equals("Euphoria-Patches") || dirName.matches("dev\\d+") || dirName.contains("earlyDev")) {
                        this.debugLog("Skipping dev Euphoria-Patches versions");
                        continue;
                    }
                    if (comparison == 0) {
                        this.debugLog("Exact version match found");
                    } else {
                        this.debugLog("File version is newer than expected version");
                    }
                    this.debugLog("Version match found - this is a correct Euphoria Patches installation");
                    info.isAlreadyInstalled = true;
                    info.installedDir = directory;
                    if (dirName.contains("Reimagined")) {
                        info.styleReimagined = true;
                    } else if (dirName.contains("Unbound")) {
                        info.styleUnbound = true;
                    } else {
                        String detectedStyle = ShaderPropertyReader.detectStyleFromCommonFile(directory, this.commonLocation);
                        info.styleReimagined = "Reimagined".equals(detectedStyle);
                        info.styleUnbound = "Unbound".equals(detectedStyle);
                    }
                    this.log(0, this.patchName + this.patchVersion + " is already installed as the renamed folder: " + directory.getFileName());
                    return;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            this.log(3, "Error checking for existing patched shaders: " + e.getMessage());
        }
    }

    public boolean isBrandNameShader(Path path, boolean isFile) {
        String name = path.getFileName().toString();
        this.debugLog("is " + name + " a brand name shader?");
        if (isFile ? !name.endsWith(".zip") : !Files.isDirectory(path, new LinkOption[0])) {
            return false;
        }
        if (!name.startsWith(this.brandName)) {
            return false;
        }
        if (name.contains(this.patchName)) {
            return false;
        }
        if (!name.contains(this.version)) {
            return false;
        }
        if (name.contains(" + ")) {
            return false;
        }
        if (name.contains("_dev")) {
            return false;
        }
        if (name.contains("_pre")) {
            return false;
        }
        this.debugLog("Yes! " + name + " matches brand name shader pattern");
        return true;
    }

    public Path findShaderByByteSize(ShaderNamingService namingService) {
        try {
            this.resetFilesScannedCounter();
            ArrayList<Path> zipFiles = new ArrayList<Path>();
            ArrayList<Path> dirs = new ArrayList<Path>();
            int skippedCount = 0;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
                for (Path p : stream) {
                    boolean isZip = Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".zip");
                    boolean isDir = Files.isDirectory(p, new LinkOption[0]);
                    if (!isZip && !isDir) continue;
                    if (this.isPopularShaderName(p)) {
                        ++skippedCount;
                        continue;
                    }
                    if (isZip) {
                        zipFiles.add(p);
                        continue;
                    }
                    dirs.add(p);
                }
            }
            int zipFileCount = zipFiles.size();
            int dirCount = dirs.size();
            this.totalFilesToScan = zipFileCount + dirCount;
            this.debugLog("Total files to scan: " + this.totalFilesToScan + " (" + zipFileCount + " ZIP files, " + dirCount + " directories) - skipped " + skippedCount + " popular shaders");
            ArrayList<Path> allPaths = new ArrayList<Path>(zipFiles);
            allPaths.addAll(dirs);
            Path validShader = this.shaderValidator.validateByByteSizeParallel(allPaths, (scanned, total) -> this.log(2, 0, "Please wait... Scanned " + scanned + " of " + total + " files so far"));
            if (validShader != null) {
                return namingService.renameToCorrectShaderName(validShader);
            }
        }
        catch (IOException e) {
            this.log(3, "Error searching for shaders by byte size: " + e.getMessage());
        }
        return null;
    }

    public void processShaderPath(Path path, ShaderInfo info, ShaderNamingService namingService) {
        String name = path.getFileName().toString();
        boolean styleFromName = false;
        if (name.contains("Reimagined")) {
            info.styleReimagined = true;
            styleFromName = true;
            if (info.baseFile == null) {
                info.baseFile = path;
            }
        } else if (name.contains("Unbound")) {
            info.styleUnbound = true;
            styleFromName = true;
            if (info.baseFile == null) {
                info.baseFile = path;
            }
        }
        if (!styleFromName) {
            String detectedStyle = ShaderPropertyReader.detectStyleFromCommonFile(path, this.commonLocation);
            if ("Reimagined".equals(detectedStyle)) {
                info.styleReimagined = true;
                if (info.baseFile == null) {
                    info.baseFile = path;
                }
            } else if ("Unbound".equals(detectedStyle)) {
                info.styleUnbound = true;
                if (info.baseFile == null) {
                    info.baseFile = path;
                }
            }
            this.log(0, "Shader style not in filename, detected " + detectedStyle + " from common.glsl");
        }
        this.checkIfAlreadyInstalled(path, info, namingService);
    }

    public void checkIfAlreadyInstalled(Path path, ShaderInfo info, ShaderNamingService namingService) {
        Path potentialInstallPath;
        boolean isDirectPatchedDir = path.getFileName().toString().contains(" + " + this.patchName + this.patchVersion);
        if (isDirectPatchedDir) {
            potentialInstallPath = path;
            String name = path.getFileName().toString();
            String baseName = name.substring(0, name.indexOf(" + " + this.patchName + this.patchVersion));
            Path potentialBaseZip = this.shaderpacks.resolve(baseName + ".zip");
            info.styleReimagined = name.contains("Reimagined");
            info.styleUnbound = name.contains("Unbound");
            if (Files.exists(potentialBaseZip, new LinkOption[0])) {
                info.baseFile = potentialBaseZip;
            }
        } else {
            potentialInstallPath = namingService != null ? namingService.getPatchedShaderPath(path) : null;
            if (info.baseFile == null) {
                info.baseFile = path;
            }
        }
        if (info.isAlreadyInstalled || potentialInstallPath == null) {
            return;
        }
        if (Files.exists(potentialInstallPath, new LinkOption[0])) {
            this.verifyEuphoriaInstallation(potentialInstallPath, info);
        }
    }

    public boolean hasEuphoriaFile(Path dir) throws IOException {
        try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
            boolean bl = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).anyMatch(p -> p.getFileName().toString().contains("EuphoriaPatches"));
            return bl;
        }
    }

    public void verifyEuphoriaInstallation(Path potentialInstallPath, ShaderInfo info) {
        if (info.isAlreadyInstalled || potentialInstallPath == null) {
            return;
        }
        try {
            boolean containsEuphoria = this.hasEuphoriaFile(potentialInstallPath);
            if (containsEuphoria) {
                info.isAlreadyInstalled = true;
                info.installedDir = potentialInstallPath;
                this.log(0, this.patchName + this.patchVersion + " is already installed.");
            } else {
                this.log(0, "Found incomplete installation. Cleaning up " + potentialInstallPath.getFileName());
                ArchiveOperations.deleteRecursively(potentialInstallPath);
                info.isAlreadyInstalled = false;
            }
        }
        catch (IOException e) {
            this.log(3, "Error checking installation status. Cleaning up: " + e.getMessage());
            try {
                ArchiveOperations.deleteRecursively(potentialInstallPath);
            }
            catch (IOException ex) {
                this.log(3, "Error deleting directory: " + ex.getMessage());
            }
            info.isAlreadyInstalled = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean noDevVersionsInstalled() {
        if (hasAnyDevVersion) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
            String fileName;
            Path path;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return true;
            } while (!Files.isRegularFile(path = iterator.next(), new LinkOption[0]) || !numberedDevPattern.matcher(fileName = path.getFileName().toString()).matches() && !earlyDevPattern.matcher(fileName).matches());
            hasAnyDevVersion = true;
            this.debugLog("Found dev version: " + fileName);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.debugLog("Error checking for dev versions: " + e.getMessage());
        }
        return true;
    }

    public boolean isNewerDevVersion(Path path, ShaderInfo info) {
        String currentVersion;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        String fileName = path.getFileName().toString();
        if (this.checkNumberedDevVersion(fileName, currentVersion = this.patchVersion.replace("_", ""))) {
            hasAnyDevVersion = true;
            if (info != null) {
                info.isAlreadyInstalled = true;
                info.installedDir = path;
                String devVersion = fileName.replaceAll(".*EuphoriaPatches_(\\d+\\.\\d+\\.\\d+)-dev\\d+\\.zip", "$1");
                this.log(0, "Your dev version: " + devVersion + " vs current public release version: " + currentVersion);
                this.log(0, "Your dev version is more recent than the last public release. Enjoy!");
                this.log(0, "Thanks for the support! <3");
            }
            return true;
        }
        if (this.checkEarlyDevVersion(fileName, this.currentBuildDate)) {
            hasAnyDevVersion = true;
            if (info != null) {
                info.isAlreadyInstalled = true;
                info.installedDir = path;
                String devDateStr = fileName.replaceAll(".*EuphoriaPatches_earlyDev_(\\d{4}-\\d{2}-\\d{2})\\.zip", "$1");
                this.log(0, "Your earlyDev version date: " + devDateStr + " vs current build date: " + this.buildDateStr);
                this.log(0, "Your earlyDev version is more recent than the last public release. Enjoy!");
                this.log(0, "Thanks for the support! <3");
            }
            return true;
        }
        return false;
    }

    public boolean isNewerDevVersion(Path path) {
        return this.isNewerDevVersion(path, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForNewerDevVersion(ShaderInfo info) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
            Path path;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!Files.isRegularFile(path = iterator.next(), new LinkOption[0]) || !this.isNewerDevVersion(path, info));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.debugLog("Error checking for dev versions: " + e.getMessage());
        }
        return false;
    }

    public Integer parseBuildDate(String buildDateStr) {
        if (buildDateStr != null && !buildDateStr.equals("year-month-day")) {
            try {
                Integer date = Integer.parseInt(buildDateStr.replace("-", ""));
                this.debugLog("Current build date: " + buildDateStr + " (" + date + ")");
                return date;
            }
            catch (NumberFormatException e) {
                this.debugLog("Could not parse build date: " + buildDateStr);
            }
        }
        return null;
    }

    private boolean checkNumberedDevVersion(String fileName, String currentVersion) {
        Matcher matcher = numberedDevPattern.matcher(fileName);
        if (matcher.matches()) {
            String devVersion = matcher.group(1);
            this.debugLog("Found numbered dev version file: " + fileName + " with version: " + devVersion);
            int comparison = VersionComparator.compareVersionStrings(devVersion, currentVersion);
            if (comparison > 0) {
                this.debugLog("Dev version " + devVersion + " is newer than current patch version " + currentVersion);
                return true;
            }
            this.debugLog("Dev version " + devVersion + " is older or equal to current patch version " + currentVersion);
        }
        return false;
    }

    private boolean checkEarlyDevVersion(String fileName, Integer currentBuildDate) {
        Matcher matcher = earlyDevPattern.matcher(fileName);
        if (matcher.matches() && currentBuildDate != null) {
            String devDateStr = matcher.group(1);
            this.debugLog("Found earlyDev file: " + fileName + " with date: " + devDateStr);
            try {
                int devDate = Integer.parseInt(devDateStr.replace("-", ""));
                this.debugLog("Comparing dates: earlyDev=" + devDate + " vs current=" + currentBuildDate);
                if (devDate > currentBuildDate) {
                    this.debugLog("EarlyDev date " + devDateStr + " is newer than current build date");
                    return true;
                }
                this.debugLog("EarlyDev date " + devDateStr + " is older or equal to current build date");
            }
            catch (NumberFormatException e) {
                this.debugLog("Could not parse earlyDev date: " + devDateStr);
            }
        }
        return false;
    }

    private void resetFilesScannedCounter() {
        this.totalFilesToScan = 0;
        this.debugLog("Reset files scanned counter");
    }

    private boolean isPopularShaderName(Path path) {
        try {
            String nameLower = path.getFileName().toString().toLowerCase(Locale.ROOT);
            List<String> popularPatterns = Arrays.asList(".*bsl_v\\d+\\..*", ".*sildur's.*", ".*spooklementary.*", ".*pixelcraftshaders_.*", "ep_earlyDev_\\d+.*", "outdated complementary.*_r\\d+.*ep.*", "comp\\d+.*ep_\\d+.*", ".*photon_v\\d+.*", ".*hysteria-shaders.*", "rethinking-voxels_r\\d+.*", "solas shader v\\d+.*", "superdupervanilla.*", "insanity-shader.*", ".*(bliss_v\\d+|bliss-shader).*", ".*\\b(continuum)\\b.*", ".*(chocapic|chocapic13).*", ".*astra.*lex.*", "euphoriapatches_earlydev_.*");
            for (String regex : popularPatterns) {
                if (!nameLower.matches(regex)) continue;
                this.debugLog("Skipping popular shader name during byte-size scan: " + path.getFileName() + " (matches " + regex + ")");
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void log(int level, String message) {
        EuphoriaPatcher.log(level, message);
    }

    private void log(int level, int fadeTimer, String message) {
        EuphoriaPatcher.log(level, fadeTimer, message);
    }

    private void debugLog(String message) {
        EuphoriaLogger.debugLog("[ShaderDetector] " + message);
    }

    public boolean isEuphoriaPatchesShader(Path shaderPath) {
        Boolean cached = euphoriaShaderCache.get(shaderPath);
        if (cached != null) {
            this.debugLog("isEuphoriaPatchesShader cache hit for " + shaderPath.getFileName() + ": " + cached);
            return cached;
        }
        boolean isEuphoriaShader = false;
        try {
            if (Files.isDirectory(shaderPath, new LinkOption[0])) {
                Path myFilePath = shaderPath.resolve(this.shaderMyFileLocation);
                isEuphoriaShader = Files.exists(myFilePath, new LinkOption[0]);
                this.debugLog("Checked directory " + shaderPath.getFileName() + " for myFile: " + isEuphoriaShader);
            } else if (Files.isRegularFile(shaderPath, new LinkOption[0]) && shaderPath.toString().endsWith(".zip")) {
                isEuphoriaShader = ArchiveOperations.fileExistsInZip(shaderPath, this.shaderMyFileLocation);
                this.debugLog("Checked zip " + shaderPath.getFileName() + " for myFile: " + isEuphoriaShader);
            }
        }
        catch (Exception e) {
            this.debugLog("Error checking if shader is Euphoria Patches: " + e.getMessage());
            isEuphoriaShader = false;
        }
        euphoriaShaderCache.put(shaderPath, isEuphoriaShader);
        return isEuphoriaShader;
    }

    public String getEuphoriaPatchesVersionFromShader(Path shaderPath) {
        if (this.isEuphoriaPatchesShader(shaderPath)) {
            return this.readVersionFromPackJson(shaderPath);
        }
        return null;
    }

    public String readVersionFromPackJson(Path shaderPath) {
        Optional<String> cached = versionCache.get(shaderPath);
        if (cached != null) {
            this.debugLog("Version cache hit for " + shaderPath.getFileName() + ": " + cached.orElse("null"));
            return cached.orElse(null);
        }
        String version = null;
        try {
            if (Files.isDirectory(shaderPath, new LinkOption[0])) {
                Path packJsonPath = shaderPath.resolve("shaders/pack.json");
                if (Files.exists(packJsonPath, new LinkOption[0])) {
                    version = this.readVersionFromFile(packJsonPath);
                    this.debugLog("Read version from directory " + shaderPath.getFileName() + ": " + version);
                } else {
                    this.debugLog("pack.json not found at " + packJsonPath);
                }
            } else if (Files.isRegularFile(shaderPath, new LinkOption[0]) && shaderPath.toString().endsWith(".zip")) {
                String packJsonContent = ArchiveOperations.readFileFromZip(shaderPath, "shaders/pack.json");
                if (packJsonContent != null) {
                    version = this.parseVersionFromJson(packJsonContent);
                    this.debugLog("Read version from zip " + shaderPath.getFileName() + ": " + version);
                } else {
                    this.debugLog("pack.json not found in zip " + shaderPath.getFileName());
                }
            }
        }
        catch (Exception e) {
            this.debugLog("Error reading version from pack.json: " + e.getMessage());
        }
        versionCache.put(shaderPath, Optional.ofNullable(version));
        return version;
    }

    private String readVersionFromFile(Path packJsonPath) {
        String jsonContent = FileOperations.readFileAsString(packJsonPath);
        return this.parseVersionFromJson(jsonContent);
    }

    private String parseVersionFromJson(String jsonContent) {
        Pattern versionPattern = Pattern.compile("\"version\"\\s*:\\s*\"([^\"]+)\"");
        Matcher matcher = versionPattern.matcher(jsonContent);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean checkForMissingStyle(ShaderInfo info) {
        String missingStyle;
        if (info.styleReimagined && info.styleUnbound) {
            this.debugLog("Both styles already installed");
            return false;
        }
        if (!ShaderData.dataFileExists()) {
            this.debugLog("No data file exists, cannot check for missing styles");
            return false;
        }
        ShaderData.PersistentShaderData data = ShaderData.load();
        if (data.styleReimagined == null || data.styleUnbound == null) {
            this.debugLog("Could not load data.json, cannot check for missing styles");
            return false;
        }
        if (data.styleReimagined.booleanValue() && data.styleUnbound.booleanValue()) {
            this.debugLog("Both styles marked as installed in data.json");
            info.styleReimagined = true;
            info.styleUnbound = true;
            return true;
        }
        if (data.styleReimagined.booleanValue()) {
            missingStyle = "Unbound";
            this.debugLog("Reimagined is installed, checking for Unbound");
        } else if (data.styleUnbound.booleanValue()) {
            missingStyle = "Reimagined";
            this.debugLog("Unbound is installed, checking for Reimagined");
        } else {
            this.debugLog("No styles marked as installed in data.json");
            return false;
        }
        Path missingStyleShader = this.findBaseShaderByStyle(missingStyle);
        if (missingStyleShader != null) {
            this.debugLog("Found missing style shader: " + missingStyleShader.getFileName());
            info.baseFile = missingStyleShader;
            info.isAlreadyInstalled = false;
            if ("Reimagined".equals(missingStyle)) {
                info.styleReimagined = true;
                info.styleUnbound = data.styleUnbound;
            } else {
                info.styleUnbound = true;
                info.styleReimagined = data.styleReimagined;
            }
        } else {
            this.debugLog("Missing style " + missingStyle + " shader not found");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path findBaseShaderByStyle(String style) {
        String expectedName = this.brandName + style + this.version;
        this.debugLog("Looking for base shader: " + expectedName);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks);){
            Path path;
            String fileName;
            Iterator<Path> iterator = stream.iterator();
            do {
                if (!iterator.hasNext()) return null;
                path = iterator.next();
                fileName = path.getFileName().toString();
                if (!fileName.equals(expectedName + ".zip") || !Files.isRegularFile(path, new LinkOption[0])) continue;
                this.debugLog("Found exact match (zip): " + fileName);
                Path path2 = path;
                return path2;
            } while (!fileName.equals(expectedName) || !Files.isDirectory(path, new LinkOption[0]));
            this.debugLog("Found exact match (directory): " + fileName);
            Path path3 = path;
            return path3;
        }
        catch (IOException e) {
            this.debugLog("Error searching for base shader by style: " + e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path findPatchedShaderDirectory() {
        try {
            DirectoryStream.Filter<Path> filter = path -> (Files.isDirectory(path, new LinkOption[0]) || Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".zip")) && path.getFileName().toString().contains(this.brandName) && path.getFileName().toString().contains(" + " + this.patchName + this.patchVersion);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.shaderpacks, filter);){
                Iterator<Path> iterator = stream.iterator();
                if (!iterator.hasNext()) return null;
                Path path3 = iterator.next();
                this.debugLog("Found patched shader directory: " + path3.getFileName());
                Path path2 = path3;
                return path2;
            }
        }
        catch (IOException e) {
            this.debugLog("Error finding patched shader directory: " + e.getMessage());
        }
        return null;
    }

    public static class ShaderInfo {
        public Path baseFile = null;
        public Path installedDir = null;
        public boolean styleReimagined = false;
        public boolean styleUnbound = false;
        public boolean isAlreadyInstalled = false;
    }
}

