/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.logging;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.config.ConfigHandler;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.integration.SodiumConsole;
import com.euphoriapatches.euphoria_patcher.logging.ErrorShaderGenerator;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import com.euphoriapatches.shadow.org.apache.commons.io.FileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EuphoriaLogger {
    private static Logger logger;
    private static boolean log4jAvailable;
    public static final String ERROR_LOG_FILE_NAME = "_0EUPHORIA_PATCHES_ERROR_LOGS.txt";
    private final Path errorLogFilePath = EuphoriaPatcher.shaderpacks.resolve("_0EUPHORIA_PATCHES_ERROR_LOGS.txt");
    private boolean isSodiumInstalled = false;
    private boolean shouldCreateErrorLog = true;
    private final List<String> errorMessages = new ArrayList<String>();
    private int lastProcessedErrorCount = 0;
    private boolean hasErrors = false;
    private Timer errorShaderTimer = null;
    private boolean errorShaderScheduled = false;
    private static final int ERROR_COLLECTION_DELAY_MS = 4000;
    private final Object errorCollectionLock = new Object();
    private String lastErrorURL = null;
    private final boolean doErrorClipboardCopy = ModLoaderSpecifics.isInstance("Fabric") || ModLoaderSpecifics.isInstance("NeoForge") || ModLoaderSpecifics.isInstance("Forge");
    private boolean errorURLAlreadyCopied = false;

    public void checkAndSetupSodiumLogging() {
        this.isSodiumInstalled = SodiumConsole.isSodiumAvailable();
        if (this.isSodiumInstalled) {
            EuphoriaLogger.debugLog("Sodium found, using Sodium logging!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(int messageLevel, int messageFadeTimer, String message) {
        String loggingMessage = "EuphoriaPatcher: " + message;
        if (messageLevel == -1) {
            loggingMessage = "\n \n" + loggingMessage + "\n\n ";
        }
        if (this.isSodiumInstalled && messageFadeTimer > 0) {
            SodiumConsole.logMessage(messageLevel, messageFadeTimer, loggingMessage);
        }
        switch (messageLevel) {
            case 0: 
            case 1: {
                if (log4jAvailable && logger != null) {
                    logger.info(loggingMessage);
                    break;
                }
                System.out.println("[INFO] " + loggingMessage);
                break;
            }
            case 2: {
                if (log4jAvailable && logger != null) {
                    logger.warn(loggingMessage);
                } else {
                    System.out.println("[WARN] " + loggingMessage);
                }
                if (messageFadeTimer <= 0) break;
                this.appendToErrorLogFile("[WARNING] " + loggingMessage);
                this.collectErrorMessage(loggingMessage);
                break;
            }
            case 3: {
                String url;
                if (log4jAvailable && logger != null) {
                    logger.error(loggingMessage);
                } else {
                    System.err.println("[ERROR] " + loggingMessage);
                }
                if (messageFadeTimer <= 0) break;
                this.appendToErrorLogFile("[ERROR] " + loggingMessage);
                this.collectErrorMessage(loggingMessage);
                if (!this.doErrorClipboardCopy || (url = this.extractURL(message)) == null) break;
                Object object = this.errorCollectionLock;
                synchronized (object) {
                    this.errorURLAlreadyCopied = false;
                    this.lastErrorURL = url;
                    EuphoriaLogger.debugLog("Stored error URL for clipboard: " + this.lastErrorURL);
                    break;
                }
            }
            default: {
                System.out.println(loggingMessage);
            }
        }
        if (message.contains("Have fun developing Euphoria Patches!") || message.contains("Thank you for using Euphoria Patches - SpacEagle17")) {
            this.deleteErrorLogFile();
        }
    }

    public void log(int messageLevel, String message) {
        int[] fadeTimers = new int[]{0, 4, 8, 16};
        int messageFadeTimer = messageLevel >= 0 && messageLevel < fadeTimers.length ? fadeTimers[messageLevel] : 0;
        this.log(messageLevel, messageFadeTimer, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectErrorMessage(String message) {
        Object object = this.errorCollectionLock;
        synchronized (object) {
            this.errorMessages.add(message);
            this.hasErrors = true;
            EuphoriaLogger.debugLog("Collected error #" + this.errorMessages.size() + ": " + message);
            EuphoriaLogger.debugLog("lastProcessedErrorCount = " + this.lastProcessedErrorCount);
            if (this.errorMessages.size() == 1) {
                EuphoriaLogger.debugLog("First error, scheduling initial generation");
                this.scheduleErrorShaderGeneration();
            } else if (this.errorMessages.size() >= 10 && this.errorMessages.size() - this.lastProcessedErrorCount >= 5) {
                EuphoriaLogger.debugLog("Many errors collected, generating immediately");
                this.cancelScheduledErrorShader();
                ErrorShaderGenerator.generateErrorShader(this.errorMessages);
                this.lastProcessedErrorCount = this.errorMessages.size();
                this.scheduleErrorShaderGeneration();
            } else if (!this.errorShaderScheduled && this.errorMessages.size() > this.lastProcessedErrorCount) {
                EuphoriaLogger.debugLog("New errors detected and no timer active, scheduling update");
                this.scheduleErrorShaderGeneration();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleErrorShaderGeneration() {
        Object object = this.errorCollectionLock;
        synchronized (object) {
            if (this.errorShaderScheduled) {
                EuphoriaLogger.debugLog("Timer already scheduled, skipping");
                return;
            }
            this.cancelScheduledErrorShader();
            this.errorShaderTimer = new Timer("ErrorShaderTimer", true);
            this.errorShaderTimer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = EuphoriaLogger.this.errorCollectionLock;
                    synchronized (object) {
                        EuphoriaLogger.debugLog("Timer firing: messages=" + EuphoriaLogger.this.errorMessages.size() + ", lastProcessed=" + EuphoriaLogger.this.lastProcessedErrorCount);
                        if (EuphoriaLogger.this.hasErrors && EuphoriaLogger.this.errorMessages.size() > EuphoriaLogger.this.lastProcessedErrorCount) {
                            EuphoriaLogger.debugLog("Generating shader with " + EuphoriaLogger.this.errorMessages.size() + " messages");
                            ErrorShaderGenerator.generateErrorShader(EuphoriaLogger.this.errorMessages);
                            EuphoriaLogger.this.lastProcessedErrorCount = EuphoriaLogger.this.errorMessages.size();
                        }
                        if (EuphoriaLogger.this.doErrorClipboardCopy) {
                            if (ErrorShaderGenerator.isErrorShaderActive() && EuphoriaLogger.this.lastErrorURL != null && !EuphoriaLogger.this.errorURLAlreadyCopied && ShaderLoader.isIrisRunning()) {
                                EuphoriaLogger.debugLog("Error shader is active, attempting to copy URL to clipboard: " + EuphoriaLogger.this.lastErrorURL);
                                boolean success = ModLoaderSpecifics.setClipboardStatic(EuphoriaLogger.this.lastErrorURL);
                                if (success) {
                                    EuphoriaLogger.debugLog("Successfully copied URL to clipboard");
                                    EuphoriaLogger.this.log(3, 8, "The download link has been copied to your clipboard. Paste it in your browser.");
                                } else {
                                    EuphoriaLogger.debugLog("Failed to copy URL to clipboard");
                                    EuphoriaLogger.this.log(3, 8, "Failed to copy error URL to clipboard. Please copy it manually from _0EUPHORIA_PATCHES_ERROR_LOGS.txt in your shaderpacks folder.");
                                }
                                ErrorShaderGenerator.generateErrorShader(EuphoriaLogger.this.errorMessages);
                                EuphoriaLogger.this.lastProcessedErrorCount = EuphoriaLogger.this.errorMessages.size();
                                EuphoriaLogger.this.errorURLAlreadyCopied = true;
                            } else {
                                EuphoriaLogger.debugLog("Error shader not active or no URL to copy (active=" + ErrorShaderGenerator.isErrorShaderActive() + ", url=" + EuphoriaLogger.this.lastErrorURL + ", alreadyCopied=" + EuphoriaLogger.this.errorURLAlreadyCopied + ")");
                            }
                        }
                        EuphoriaLogger.this.errorShaderScheduled = false;
                        EuphoriaLogger.this.scheduleErrorShaderGeneration();
                    }
                }
            }, 4000L);
            this.errorShaderScheduled = true;
            EuphoriaLogger.debugLog("Scheduled error shader generation in 4 seconds");
        }
    }

    private void cancelScheduledErrorShader() {
        if (this.errorShaderTimer != null) {
            this.errorShaderTimer.cancel();
            this.errorShaderTimer = null;
            this.errorShaderScheduled = false;
        }
    }

    public void checkErrorLogFileAndAddSeparator() {
        if (!this.shouldCreateErrorLog) {
            return;
        }
        try {
            if (Files.exists(this.errorLogFilePath, new LinkOption[0])) {
                String separator = "\n--------------------------------------\nRestart happened\n--------------------------------------\n";
                Files.write(this.errorLogFilePath, separator.getBytes(), StandardOpenOption.APPEND);
                this.log(0, "Added restart separator to error log file");
            }
        }
        catch (IOException e) {
            this.log(0, "Failed to add restart separator to error log file: " + e.getMessage());
        }
    }

    private void appendToErrorLogFile(String message) {
        if (!this.shouldCreateErrorLog) {
            return;
        }
        try {
            if (!Files.exists(this.errorLogFilePath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.errorLogFilePath.getParent(), new FileAttribute[0]);
            }
            String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
            String logEntry = timestamp + " " + message + System.lineSeparator();
            StandardOpenOption option = Files.exists(this.errorLogFilePath, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE;
            Files.write(this.errorLogFilePath, logEntry.getBytes(), option);
        }
        catch (IOException e) {
            this.log(0, "Failed to write to error log file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteErrorLogFile() {
        Object object = this.errorCollectionLock;
        synchronized (object) {
            try {
                Path errorShaderPath;
                if (Files.exists(this.errorLogFilePath, new LinkOption[0])) {
                    Files.delete(this.errorLogFilePath);
                    this.log(0, "Deleted error log file as shader was successfully installed");
                    this.shouldCreateErrorLog = false;
                }
                if (Files.exists(errorShaderPath = EuphoriaPatcher.shaderpacks.resolve("_0EuphoriaPatches_ErrorShader"), new LinkOption[0])) {
                    FileUtils.deleteDirectory(errorShaderPath.toFile());
                    this.log(0, "Deleted error shader as installation was successful");
                }
                this.errorMessages.clear();
                this.hasErrors = false;
                this.lastProcessedErrorCount = 0;
                this.cancelScheduledErrorShader();
            }
            catch (IOException e) {
                this.log(0, "Failed to delete error log file: " + e.getMessage());
            }
        }
    }

    public static void debugLog(String message) {
        if (ConfigHandler.doDebugLogging) {
            EuphoriaPatcher.log(0, message);
        }
    }

    public static String getStackTrace(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n");
        for (StackTraceElement element : e.getStackTrace()) {
            sb.append("  at ").append(element.toString()).append("\n");
        }
        return sb.toString();
    }

    private String extractURL(String message) {
        String[] words;
        for (String word : words = message.split("\\s+")) {
            if (!word.startsWith("http://") && !word.startsWith("https://")) continue;
            String url = word.replaceAll("[,;:.)!]+$", "");
            EuphoriaLogger.debugLog("Extracted URL from error message: " + url);
            return url;
        }
        return null;
    }

    static {
        log4jAvailable = true;
        try {
            logger = LogManager.getLogger((String)"euphoria_patcher");
        }
        catch (Exception | NoClassDefFoundError e) {
            log4jAvailable = false;
            System.out.println("[EuphoriaLogger] Log4j not available, using System.out fallback");
        }
    }
}

