/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.integration.iris;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.config.ConfigHandler;
import com.euphoriapatches.euphoria_patcher.features.UpdateShaderConfig;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.monitoring.PotatoFileMonitor;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import com.euphoriapatches.euphoria_patcher.util.UpdateChecker;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;

public class IrisDefineHelper {
    private static int injectCount = 0;
    public static boolean isIrisRunning = false;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[IrisDefineHelper] " + message);
    }

    public static void addEuphoriaDefines(List<?> standardDefines, boolean isLegacy, BiConsumer<List<?>, String> defineKey, BiConsumer<List<?>, String[]> defineKeyValue) {
        try {
            Path currentShaderpack;
            ++injectCount;
            IrisDefineHelper.debugLog("Adding Euphoria Patches defines to Iris" + (isLegacy ? " (Legacy)" : ""));
            isIrisRunning = true;
            if (EuphoriaPatcher.isSpacEagle()) {
                defineKey.accept(standardDefines, "SPACEAGLE17");
                IrisDefineHelper.debugLog("Adding SPACEAGLE17 define");
            }
            String currentVersion = IrisDefineHelper.formatVersion("_1.8.6");
            defineKeyValue.accept(standardDefines, new String[]{"CURRENT_EUPHORIA_PATCHES_VERSION", currentVersion});
            IrisDefineHelper.debugLog("Adding CURRENT_EUPHORIA_PATCHES_VERSION = " + currentVersion + " define");
            defineKey.accept(standardDefines, "EUPHORIA_PATCHES_MOD_INSTALLED");
            IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_MOD_INSTALLED define");
            if (ModLoaderSpecifics.isCurrentDimensionInMappingsStatic()) {
                defineKey.accept(standardDefines, "EUPHORIA_PATCHES_DIMENSION_IN_PROPERTIES");
                IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_DIMENSION_IN_PROPERTIES define");
            } else {
                IrisDefineHelper.debugLog("Not adding EUPHORIA_PATCHES_DIMENSION_IN_PROPERTIES define - dimension not in dimensions.properties");
            }
            String currentDimension = "CURRENT_EUPHORIA_PATCHES_DIMENSION_" + ModLoaderSpecifics.getCurrentDimensionStatic().toUpperCase(Locale.ROOT);
            defineKey.accept(standardDefines, currentDimension);
            IrisDefineHelper.debugLog("Adding " + currentDimension + " define");
            String shaderLoader = ShaderLoader.getShaderLoader().toUpperCase(Locale.ROOT);
            defineKey.accept(standardDefines, "EUPHORIA_PATCHES_" + shaderLoader);
            IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_" + shaderLoader + " define");
            String[] shaderLoaderVersionDefine = ShaderLoader.getShaderLoaderVersionDefine();
            if (shaderLoaderVersionDefine != null) {
                defineKeyValue.accept(standardDefines, shaderLoaderVersionDefine);
                IrisDefineHelper.debugLog("Adding " + shaderLoaderVersionDefine[0] + " = " + shaderLoaderVersionDefine[1] + " define");
            }
            if ((currentShaderpack = ShaderLoader.getCurrentShaderpackPath()) != null) {
                if (PotatoFileMonitor.shouldAddPotatoRemovedDefine(currentShaderpack)) {
                    defineKey.accept(standardDefines, "EUPHORIA_PATCHES_POTATO_REMOVED");
                    IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_POTATO_REMOVED define - potato.png not found");
                } else {
                    IrisDefineHelper.debugLog("Not adding EUPHORIA_PATCHES_POTATO_REMOVED define - potato.png found");
                }
            } else {
                IrisDefineHelper.debugLog("Cannot check for potato.png - currentShaderpack is null");
            }
            if (UpdateChecker.shouldUserUpdate() && ConfigHandler.doDisplayShaderInGameMessage && injectCount <= 2) {
                defineKey.accept(standardDefines, "NEW_EUPHORIA_PATCHES_UPDATE");
                IrisDefineHelper.debugLog("Adding NEW_EUPHORIA_PATCHES_UPDATE define");
                if (UpdateChecker.getNewModVersion() != null) {
                    String nextVersionFormatted = IrisDefineHelper.formatVersion(UpdateChecker.getNewModVersion());
                    defineKeyValue.accept(standardDefines, new String[]{"NEXT_EUPHORIA_PATCHES_VERSION", nextVersionFormatted});
                    IrisDefineHelper.debugLog("Adding NEXT_EUPHORIA_PATCHES_VERSION: " + nextVersionFormatted + " define");
                }
            } else if (injectCount > 2) {
                IrisDefineHelper.debugLog("Not adding NEW_EUPHORIA_PATCHES_UPDATE define - already injected " + injectCount + " times");
            } else if (!ConfigHandler.doDisplayShaderInGameMessage) {
                IrisDefineHelper.debugLog("Not adding NEW_EUPHORIA_PATCHES_UPDATE define - in-game messages disabled");
            } else {
                IrisDefineHelper.debugLog("Not adding NEW_EUPHORIA_PATCHES_UPDATE define - no update available");
            }
            UpdateShaderConfig.markCurrentEPSettingsFile();
            if (injectCount == 1) {
                EuphoriaPatcher.log(0, "Added Euphoria Patches defines to " + shaderLoader.substring(0, 1).toUpperCase(Locale.ROOT) + shaderLoader.substring(1).toLowerCase(Locale.ROOT) + (isLegacy ? " (Legacy)" : ""));
            }
        }
        catch (Exception e) {
            IrisDefineHelper.debugLog("Exception while adding defines: " + e.getMessage());
        }
    }

    public static String formatVersion(String version) {
        String[] versionParts = version.replace("_", "").split("\\.");
        StringBuilder versionBuilder = new StringBuilder();
        for (int i = 0; i < versionParts.length; ++i) {
            versionBuilder.append("_").append(versionParts[i]);
            if (i >= versionParts.length - 1) continue;
            versionBuilder.append(", _dot, ");
        }
        return versionBuilder.toString();
    }
}

