/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.features.properties;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.features.properties.PropertiesMerger;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class PropertiesWatcher {
    private static volatile String currentShaderpackPath = null;
    private static Thread configWatcherThread = null;
    private static Thread propertiesWatcherThread = null;
    private static volatile boolean running = false;
    private static WatchService configWatchService = null;
    private static WatchService propertiesWatchService = null;
    private static final Map<WatchKey, Path> propertiesWatchKeys = new ConcurrentHashMap<WatchKey, Path>();
    private static final Map<Path, Long> lastModificationTimes = new ConcurrentHashMap<Path, Long>();
    private static final long DEBOUNCE_DELAY_MS = 1000L;
    private static volatile long lastMergeTime = 0L;
    private static final long MERGE_COOLDOWN_MS = 2000L;
    private static final String PROPERTIES_DIR_NAME = "blockProperties";
    private static final String TARGET_PROPERTIES_FILE_NAME = "block.properties";

    public static void startWatcher() {
        if (running) {
            PropertiesWatcher.debugLog("Watcher already running - stopping old threads first");
            PropertiesWatcher.stopMonitoring();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        running = true;
        PropertiesWatcher.debugLog("Starting PropertiesWatcher");
        PropertiesWatcher.startConfigWatcher();
        PropertiesWatcher.updateCurrentShader();
    }

    private static void startConfigWatcher() {
        configWatcherThread = new Thread(() -> {
            PropertiesWatcher.debugLog("Started config file monitoring thread");
            try {
                Path configPath = ShaderLoader.getShaderLoaderConfigPath();
                if (configPath == null || !Files.exists(configPath, new LinkOption[0])) {
                    PropertiesWatcher.debugLog("No shader loader config file found, cannot monitor");
                    return;
                }
                configWatchService = FileSystems.getDefault().newWatchService();
                Path configDir = configPath.getParent();
                WatchKey configKey = configDir.register(configWatchService, StandardWatchEventKinds.ENTRY_MODIFY);
                PropertiesWatcher.debugLog("Registered WatchService on config directory: " + configDir);
                while (running) {
                    try {
                        WatchKey key = configWatchService.poll(500L, TimeUnit.MILLISECONDS);
                        if (key == null) continue;
                        for (WatchEvent<?> event : key.pollEvents()) {
                            WatchEvent<?> ev;
                            Path filename;
                            Path changedFile;
                            WatchEvent.Kind<?> kind = event.kind();
                            if (kind == StandardWatchEventKinds.OVERFLOW || !Files.isSameFile(changedFile = configDir.resolve(filename = (Path)(ev = event).context()), configPath)) continue;
                            PropertiesWatcher.debugLog("Config file changed, checking for shader change");
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            PropertiesWatcher.updateCurrentShader();
                        }
                        boolean valid = key.reset();
                        if (valid) continue;
                        PropertiesWatcher.debugLog("Config WatchKey no longer valid");
                        break;
                    }
                    catch (InterruptedException e) {
                        if (running) {
                            PropertiesWatcher.debugLog("Config watcher interrupted");
                        }
                        break;
                    }
                    catch (Exception e) {
                        PropertiesWatcher.debugLog("Error in config watcher: " + e.getMessage());
                        PropertiesWatcher.debugLog(EuphoriaLogger.getStackTrace(e));
                    }
                }
            }
            catch (IOException e) {
                PropertiesWatcher.debugLog("Failed to create config WatchService: " + e.getMessage());
                PropertiesWatcher.debugLog(EuphoriaLogger.getStackTrace(e));
            }
            finally {
                if (configWatchService != null) {
                    try {
                        configWatchService.close();
                    }
                    catch (IOException e) {
                        PropertiesWatcher.debugLog("Error closing config watch service: " + e.getMessage());
                    }
                }
            }
            PropertiesWatcher.debugLog("Stopped config file monitoring thread");
        }, "PropertiesWatcher-Config");
        configWatcherThread.setDaemon(true);
        configWatcherThread.start();
    }

    private static void updateCurrentShader() {
        Path shaderpackPath = ShaderLoader.getCurrentShaderpackPath();
        if (shaderpackPath == null) {
            PropertiesWatcher.debugLog("No current shaderpack detected");
            PropertiesWatcher.stopPropertiesWatcher();
            currentShaderpackPath = null;
            return;
        }
        String pathKey = shaderpackPath.toString();
        if (!pathKey.equals(currentShaderpackPath)) {
            PropertiesWatcher.debugLog("Shaderpack changed to: " + pathKey);
            if (currentShaderpackPath != null) {
                PropertiesWatcher.debugLog("Stopping monitoring for previous shaderpack");
                PropertiesWatcher.stopPropertiesWatcher();
            }
            currentShaderpackPath = pathKey;
            EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
            if (instance == null) {
                PropertiesWatcher.debugLog("EuphoriaPatcher instance not available yet");
                return;
            }
            ShaderDetector shaderDetector = instance.getShaderDetector();
            if (!shaderDetector.isEuphoriaPatchesShader(shaderpackPath)) {
                PropertiesWatcher.debugLog("Shaderpack is not an Euphoria Patches shader, skipping monitoring");
                return;
            }
            Path propertiesDir = shaderpackPath.resolve("shaders/blockProperties");
            if (!Files.exists(propertiesDir, new LinkOption[0]) || !Files.isDirectory(propertiesDir, new LinkOption[0])) {
                PropertiesWatcher.debugLog("Properties directory does not exist, skipping monitoring");
                return;
            }
            PropertiesWatcher.debugLog("Euphoria Patches shader with properties directory detected");
            PropertiesWatcher.performMerge(shaderpackPath);
            if (Files.isDirectory(shaderpackPath, new LinkOption[0])) {
                PropertiesWatcher.debugLog("Starting properties monitoring for directory shaderpack");
                PropertiesWatcher.startPropertiesWatcher(shaderpackPath);
            } else {
                PropertiesWatcher.debugLog("Shaderpack is not a directory, skipping continuous monitoring");
            }
        }
    }

    private static void startPropertiesWatcher(Path shaderpackPath) {
        propertiesWatcherThread = new Thread(() -> {
            PropertiesWatcher.debugLog("Started properties monitoring thread for: " + shaderpackPath);
            try {
                PropertiesWatcher.monitorPropertiesDirectory(shaderpackPath);
            }
            catch (Exception e) {
                PropertiesWatcher.debugLog("Error in properties monitoring thread: " + e.getMessage());
                PropertiesWatcher.debugLog(EuphoriaLogger.getStackTrace(e));
            }
            PropertiesWatcher.debugLog("Stopped properties monitoring thread");
        }, "PropertiesWatcher-Properties");
        propertiesWatcherThread.setDaemon(true);
        propertiesWatcherThread.start();
    }

    private static void stopPropertiesWatcher() {
        if (propertiesWatcherThread != null) {
            PropertiesWatcher.debugLog("Stopping properties watcher thread");
            propertiesWatcherThread.interrupt();
            try {
                propertiesWatcherThread.join(2000L);
            }
            catch (InterruptedException e) {
                PropertiesWatcher.debugLog("Interrupted while waiting for properties watcher to stop");
            }
            propertiesWatcherThread = null;
        }
        for (WatchKey key : propertiesWatchKeys.keySet()) {
            key.cancel();
        }
        propertiesWatchKeys.clear();
        if (propertiesWatchService != null) {
            try {
                propertiesWatchService.close();
            }
            catch (IOException e) {
                PropertiesWatcher.debugLog("Error closing properties watch service: " + e.getMessage());
            }
            propertiesWatchService = null;
        }
        lastModificationTimes.clear();
    }

    public static void stopMonitoring() {
        if (!running) {
            return;
        }
        PropertiesWatcher.debugLog("Stopping all monitoring threads");
        running = false;
        if (configWatcherThread != null) {
            configWatcherThread.interrupt();
            try {
                configWatcherThread.join(2000L);
            }
            catch (InterruptedException e) {
                PropertiesWatcher.debugLog("Interrupted while waiting for config watcher to stop");
            }
            configWatcherThread = null;
        }
        if (configWatchService != null) {
            try {
                configWatchService.close();
            }
            catch (IOException e) {
                PropertiesWatcher.debugLog("Error closing config watch service: " + e.getMessage());
            }
            configWatchService = null;
        }
        PropertiesWatcher.stopPropertiesWatcher();
        currentShaderpackPath = null;
    }

    private static void monitorPropertiesDirectory(Path shaderpackPath) {
        Path propertiesDir = shaderpackPath.resolve("shaders/blockProperties");
        if (!Files.exists(propertiesDir, new LinkOption[0]) || !Files.isDirectory(propertiesDir, new LinkOption[0])) {
            PropertiesWatcher.debugLog("Properties directory does not exist, cannot monitor");
            return;
        }
        try {
            propertiesWatchService = FileSystems.getDefault().newWatchService();
            PropertiesWatcher.registerDirectoryTree(propertiesDir);
            PropertiesWatcher.debugLog("Registered WatchService on properties directory and subdirectories");
            while (running && propertiesWatcherThread != null && !propertiesWatcherThread.isInterrupted()) {
                try {
                    WatchKey key = propertiesWatchService.poll(500L, TimeUnit.MILLISECONDS);
                    if (key == null) continue;
                    Path dir = propertiesWatchKeys.get(key);
                    if (dir == null) {
                        PropertiesWatcher.debugLog("WatchKey not in map, skipping");
                        key.reset();
                        continue;
                    }
                    boolean shouldMerge = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent<?> ev = event;
                        Path filename = (Path)ev.context();
                        Path fullPath = dir.resolve(filename);
                        PropertiesWatcher.debugLog("Detected " + kind.name() + " for: " + fullPath);
                        if (kind == StandardWatchEventKinds.ENTRY_CREATE && Files.isDirectory(fullPath, new LinkOption[0])) {
                            PropertiesWatcher.debugLog("New directory created, registering: " + fullPath);
                            PropertiesWatcher.registerDirectoryTree(fullPath);
                        }
                        if (!fullPath.toString().endsWith(".properties") && !Files.isDirectory(fullPath, new LinkOption[0])) continue;
                        long currentTime = System.currentTimeMillis();
                        Long lastModTime = lastModificationTimes.get(fullPath);
                        if (lastModTime == null || currentTime - lastModTime > 1000L) {
                            lastModificationTimes.put(fullPath, currentTime);
                            shouldMerge = true;
                            PropertiesWatcher.debugLog("Change detected in properties structure, will trigger merge");
                            continue;
                        }
                        PropertiesWatcher.debugLog("Change detected but within debounce period, skipping");
                    }
                    boolean valid = key.reset();
                    if (!valid) {
                        PropertiesWatcher.debugLog("WatchKey no longer valid, removing");
                        propertiesWatchKeys.remove(key);
                    }
                    if (!shouldMerge) continue;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastMergeTime > 2000L) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PropertiesWatcher.debugLog("Triggering properties merge");
                        PropertiesWatcher.performMerge(shaderpackPath);
                        lastMergeTime = currentTime;
                        continue;
                    }
                    PropertiesWatcher.debugLog("Merge request within cooldown period, skipping");
                }
                catch (InterruptedException e) {
                    PropertiesWatcher.debugLog("Properties watcher interrupted");
                    break;
                }
                catch (Exception e) {
                    PropertiesWatcher.debugLog("Error processing properties watch events: " + e.getMessage());
                    PropertiesWatcher.debugLog(EuphoriaLogger.getStackTrace(e));
                }
            }
        }
        catch (IOException e) {
            PropertiesWatcher.debugLog("Failed to create properties WatchService: " + e.getMessage());
            PropertiesWatcher.debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    private static void registerDirectoryTree(Path directory) throws IOException {
        PropertiesWatcher.registerDirectory(directory);
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !path.equals(directory)).forEach(path -> {
                try {
                    PropertiesWatcher.registerDirectory(path);
                }
                catch (IOException e) {
                    PropertiesWatcher.debugLog("Failed to register directory: " + path + " - " + e.getMessage());
                }
            });
        }
    }

    private static void registerDirectory(Path directory) throws IOException {
        WatchKey key = directory.register(propertiesWatchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        propertiesWatchKeys.put(key, directory);
        PropertiesWatcher.debugLog("Registered directory: " + directory);
    }

    private static void performMerge(Path shaderpackPath) {
        try {
            Path propertiesDir = shaderpackPath.resolve("shaders/blockProperties");
            Path targetFile = shaderpackPath.resolve("shaders/block.properties");
            PropertiesWatcher.debugLog("Initiating merge: " + propertiesDir + " -> " + targetFile);
            boolean success = PropertiesMerger.mergeProperties(propertiesDir, targetFile);
            if (success) {
                PropertiesWatcher.debugLog("Properties merge completed successfully");
                EuphoriaPatcher.log(0, "Auto-merged properties files into block.properties");
            } else {
                PropertiesWatcher.debugLog("Properties merge failed");
            }
        }
        catch (Exception e) {
            PropertiesWatcher.debugLog("Error during merge: " + e.getMessage());
            PropertiesWatcher.debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    public static Path getCurrentShaderpackPath() {
        return currentShaderpackPath != null ? Paths.get(currentShaderpackPath, new String[0]) : null;
    }

    public static boolean isMonitoring() {
        return running;
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[PropertiesWatcher] " + message);
    }
}

