/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.features.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PropertiesOrder {
    private static final List<OrderEntry> MERGE_ORDER = Arrays.asList(new OrderEntry("instructions"), new OrderEntry("tags"), new OrderEntry("1.13+", new OrderEntry("block\\.5000-.*\\.properties")), new OrderEntry("1.8+"), new OrderEntry("1.7.10"), new OrderEntry("renderlayers"));

    public static List<OrderEntry> getMergeOrder() {
        return Collections.unmodifiableList(MERGE_ORDER);
    }

    public static boolean isInMergeOrder(String folderName) {
        return PropertiesOrder.findEntry(folderName, MERGE_ORDER) != null;
    }

    public static int getOrderIndex(String folderName) {
        for (int i = 0; i < MERGE_ORDER.size(); ++i) {
            if (!MERGE_ORDER.get(i).getName().equals(folderName)) continue;
            return i;
        }
        return -1;
    }

    private static OrderEntry findEntry(String name, List<OrderEntry> entries) {
        for (OrderEntry entry : entries) {
            OrderEntry found;
            if (entry.getName().equals(name)) {
                return entry;
            }
            if (!entry.hasChildren() || (found = PropertiesOrder.findEntry(name, entry.getChildren())) == null) continue;
            return found;
        }
        return null;
    }

    public static class OrderEntry {
        private final String name;
        private final List<OrderEntry> children;

        public OrderEntry(String name) {
            this.name = name;
            this.children = new ArrayList<OrderEntry>();
        }

        public OrderEntry(String name, OrderEntry ... children) {
            this.name = name;
            this.children = new ArrayList<OrderEntry>(Arrays.asList(children));
        }

        public String getName() {
            return this.name;
        }

        public List<OrderEntry> getChildren() {
            return this.children;
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }
}

