/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.features.properties;

import com.euphoriapatches.euphoria_patcher.features.properties.PropertiesOrder;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class PropertiesMerger {
    public static boolean mergeProperties(Path propertiesDir, Path targetFile) {
        if (!Files.exists(propertiesDir, new LinkOption[0]) || !Files.isDirectory(propertiesDir, new LinkOption[0])) {
            PropertiesMerger.debugLog("Properties directory does not exist or is not a directory: " + propertiesDir);
            return false;
        }
        try {
            PropertiesMerger.debugLog("Starting properties merge from: " + propertiesDir);
            List<Path> orderedFiles = PropertiesMerger.collectOrderedPropertiesFiles(propertiesDir);
            if (orderedFiles.isEmpty()) {
                PropertiesMerger.debugLog("No properties files found to merge");
                return false;
            }
            PropertiesMerger.debugLog("Found " + orderedFiles.size() + " properties files to merge");
            PropertiesMerger.mergeFilesIntoTarget(orderedFiles, targetFile, propertiesDir);
            PropertiesMerger.debugLog("Successfully merged properties into: " + targetFile);
            return true;
        }
        catch (IOException e) {
            PropertiesMerger.debugLog("Error during properties merge: " + e.getMessage());
            PropertiesMerger.debugLog(EuphoriaLogger.getStackTrace(e));
            return false;
        }
    }

    private static List<Path> collectOrderedPropertiesFiles(Path propertiesDir) throws IOException {
        ArrayList<Path> orderedFiles = new ArrayList<Path>();
        List<PropertiesOrder.OrderEntry> mergeOrder = PropertiesOrder.getMergeOrder();
        for (PropertiesOrder.OrderEntry entry : mergeOrder) {
            Path entryPath = propertiesDir.resolve(entry.getName());
            if (!Files.exists(entryPath, new LinkOption[0])) {
                PropertiesMerger.debugLog("Order entry not found, skipping: " + entry.getName());
                continue;
            }
            PropertiesMerger.collectFilesFromEntry(entryPath, entry, orderedFiles);
        }
        return orderedFiles;
    }

    private static void collectFilesFromEntry(Path entryPath, PropertiesOrder.OrderEntry entry, List<Path> result) throws IOException {
        if (Files.isRegularFile(entryPath, new LinkOption[0]) && entryPath.toString().endsWith(".properties")) {
            result.add(entryPath);
            PropertiesMerger.debugLog("Added file to merge order: " + entryPath.getFileName());
            return;
        }
        if (!Files.isDirectory(entryPath, new LinkOption[0])) {
            return;
        }
        if (entry.hasChildren()) {
            HashSet<String> processedNames = new HashSet<String>();
            for (PropertiesOrder.OrderEntry child : entry.getChildren()) {
                String childName = child.getName();
                if (PropertiesMerger.isPattern(childName)) {
                    List<Path> matchedPaths = PropertiesMerger.findMatchingPaths(entryPath, childName);
                    if (!matchedPaths.isEmpty()) {
                        PropertiesMerger.debugLog("Pattern '" + childName + "' matched " + matchedPaths.size() + " items");
                        for (Path matchedPath : matchedPaths) {
                            PropertiesMerger.collectFilesFromEntry(matchedPath, child, result);
                            processedNames.add(matchedPath.getFileName().toString());
                        }
                        continue;
                    }
                    PropertiesMerger.debugLog("Pattern '" + childName + "' matched no items");
                    continue;
                }
                Path childPath = entryPath.resolve(childName);
                if (!Files.exists(childPath, new LinkOption[0])) continue;
                PropertiesMerger.collectFilesFromEntry(childPath, child, result);
                processedNames.add(childName);
            }
            PropertiesMerger.collectRemainingPropertiesFiles(entryPath, processedNames, result);
        } else {
            PropertiesMerger.collectAllPropertiesFiles(entryPath, result);
        }
    }

    private static boolean isPattern(String name) {
        return name.contains(".*") || name.contains(".+") || name.contains("[") || name.contains("]") || name.contains("^") || name.contains("$") || name.contains("|") || name.contains("?") || name.contains("{") || name.matches(".*\\\\[dDwWsS].*");
    }

    private static List<Path> findMatchingPaths(Path directory, String patternString) throws IOException {
        ArrayList<Path> matches = new ArrayList<Path>();
        try {
            Pattern pattern = Pattern.compile(patternString);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    String fileName = path.getFileName().toString();
                    if (!pattern.matcher(fileName).matches()) continue;
                    matches.add(path);
                    PropertiesMerger.debugLog("Pattern '" + patternString + "' matched: " + fileName);
                }
            }
            matches.sort(Comparator.comparing(Path::getFileName));
        }
        catch (Exception e) {
            PropertiesMerger.debugLog("Error compiling pattern '" + patternString + "': " + e.getMessage());
        }
        return matches;
    }

    private static void collectRemainingPropertiesFiles(Path directory, Set<String> excludeNames, List<Path> result) throws IOException {
        ArrayList<Path> filesInDir = new ArrayList<Path>();
        ArrayList<Path> subDirs = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path path : stream) {
                String name = path.getFileName().toString();
                if (excludeNames.contains(name)) continue;
                if (Files.isRegularFile(path, new LinkOption[0]) && name.endsWith(".properties")) {
                    filesInDir.add(path);
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                subDirs.add(path);
            }
        }
        filesInDir.sort(Comparator.comparing(Path::getFileName));
        subDirs.sort(Comparator.comparing(Path::getFileName));
        for (Path file : filesInDir) {
            result.add(file);
            PropertiesMerger.debugLog("Added remaining file to merge order: " + file.getFileName());
        }
        for (Path subDir : subDirs) {
            PropertiesMerger.collectAllPropertiesFiles(subDir, result);
        }
    }

    private static void collectAllPropertiesFiles(Path directory, List<Path> result) throws IOException {
        ArrayList<Path> filesInDir = new ArrayList<Path>();
        ArrayList<Path> subDirs = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
            for (Path path : stream) {
                if (Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".properties")) {
                    filesInDir.add(path);
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                subDirs.add(path);
            }
        }
        filesInDir.sort(Comparator.comparing(Path::getFileName));
        for (Path file : filesInDir) {
            result.add(file);
            PropertiesMerger.debugLog("Added file to merge order: " + file.getFileName());
        }
        subDirs.sort(Comparator.comparing(Path::getFileName));
        for (Path subDir : subDirs) {
            PropertiesMerger.collectAllPropertiesFiles(subDir, result);
        }
    }

    private static void mergeFilesIntoTarget(List<Path> sourceFiles, Path targetFile, Path propertiesDir) throws IOException {
        Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
        StringBuilder mergedContent = new StringBuilder();
        mergedContent.append("###############################################################################\n");
        mergedContent.append("# Auto-merged block.properties file\n");
        mergedContent.append("# Generated by Euphoria Patcher - Properties Merger\n");
        mergedContent.append("# \n");
        mergedContent.append("# This file is automatically generated from fragmented properties files.\n");
        mergedContent.append("# Do not edit this file directly - your changes will be overwritten!\n");
        mergedContent.append("# Edit the individual files in shaders/properties/ instead.\n");
        mergedContent.append("# Enable the \"autoMergeBlockProperties\" option in the Euphoria Patches Mod's config to automatically merge on changes.\n");
        mergedContent.append("###############################################################################\n\n");
        for (Path sourceFile : sourceFiles) {
            Path relativePath = propertiesDir.relativize(sourceFile);
            mergedContent.append("\n");
            mergedContent.append("# ============================================================================\n");
            mergedContent.append("# Source: ").append(relativePath.toString().replace('\\', '/')).append("\n");
            mergedContent.append("# ============================================================================\n");
            String content = PropertiesMerger.readFileContent(sourceFile);
            mergedContent.append(content);
            if (content.endsWith("\n")) continue;
            mergedContent.append("\n");
        }
        Files.write(targetFile, mergedContent.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        PropertiesMerger.debugLog("Merged " + sourceFiles.size() + " files into " + targetFile.getFileName());
    }

    private static String readFileContent(Path file) throws IOException {
        return new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[PropertiesMerger] " + message);
    }
}

