/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.features;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.integration.iris.IrisReloadManager;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;

public class UpdateShaderLoaderConfig {
    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[UpdateShaderLoaderConfig] " + message);
    }

    public static void updateShaderLoaderConfig(boolean styleUnbound, boolean styleReimagined) {
        block19: {
            UpdateShaderLoaderConfig.debugLog("Starting updateShaderLoaderConfig - Unbound: " + styleUnbound + ", Reimagined: " + styleReimagined);
            Path shaderLoaderConfig = ShaderLoader.getShaderLoaderConfigPath();
            if (shaderLoaderConfig == null) {
                UpdateShaderLoaderConfig.debugLog("No shader loader config found");
                EuphoriaPatcher.log(0, "No shader loader config found");
                return;
            }
            UpdateShaderLoaderConfig.debugLog("Found shader loader config at: " + shaderLoaderConfig);
            String shaderLoaderName = shaderLoaderConfig.toString().contains("iris") ? "iris.properties" : (shaderLoaderConfig.toString().contains("oculus") ? "oculus.properties" : "OptiFine's optionsshaders.txt");
            UpdateShaderLoaderConfig.debugLog("Identified shader loader: " + shaderLoaderName);
            File fileToBeModified = shaderLoaderConfig.toFile();
            StringBuilder oldContent = new StringBuilder();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(fileToBeModified));
                try {
                    String line;
                    UpdateShaderLoaderConfig.debugLog("Reading shader loader config file");
                    while ((line = reader.readLine()) != null) {
                        oldContent.append(line).append(System.lineSeparator());
                    }
                    UpdateShaderLoaderConfig.debugLog("Successfully read shader loader config file");
                    boolean hasPatchName = oldContent.toString().contains("EuphoriaPatches");
                    boolean hasPatchVersion = oldContent.toString().contains("_1.8.6");
                    UpdateShaderLoaderConfig.debugLog("Config contains patch name: " + hasPatchName + ", contains patch version: " + hasPatchVersion);
                    if (hasPatchName && !hasPatchVersion) {
                        UpdateShaderLoaderConfig.debugLog("Need to update shader config - found old version reference");
                        String newContent = UpdateShaderLoaderConfig.setNewShaderLoaderSelectedPackName(oldContent, styleUnbound, styleReimagined);
                        UpdateShaderLoaderConfig.debugLog("Generated new content for config file");
                        try (FileWriter writer = new FileWriter(fileToBeModified);){
                            UpdateShaderLoaderConfig.debugLog("Writing updated content to config file");
                            writer.write(newContent);
                            UpdateShaderLoaderConfig.debugLog("Successfully wrote updated content");
                        }
                        catch (IOException e) {
                            UpdateShaderLoaderConfig.debugLog("Error writing to config file: " + e.getMessage());
                            EuphoriaPatcher.log(3, 0, "Error writing to " + shaderLoaderName + " config file: " + e.getMessage());
                            reader.close();
                            return;
                        }
                        String oldPack = oldContent.toString().contains("shaderPack=") ? oldContent.toString().split("shaderPack=")[1].split("\n")[0].trim() : "unknown";
                        String newPack = newContent.contains("shaderPack=") ? newContent.split("shaderPack=")[1].split("\n")[0].trim() : "unknown";
                        UpdateShaderLoaderConfig.debugLog("Updated shader pack reference from '" + oldPack + "' to '" + newPack + "'");
                        EuphoriaPatcher.log(0, "Successfully applied new version in " + shaderLoaderName + " config file!");
                        EuphoriaPatcher.log(0, oldPack + " -> " + newPack);
                        break block19;
                    }
                    UpdateShaderLoaderConfig.debugLog("No update needed for shader config");
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
            catch (IOException e) {
                UpdateShaderLoaderConfig.debugLog("Error accessing shader loader config file: " + e.getMessage());
                EuphoriaPatcher.log(3, 0, "Error reading or writing to " + shaderLoaderName + " config file: " + e.getMessage());
                return;
            }
        }
        UpdateShaderLoaderConfig.debugLog("Attempting to schedule shader reload");
        IrisReloadManager.findAndScheduleReload();
    }

    private static String setNewShaderLoaderSelectedPackName(StringBuilder oldContent, boolean styleUnbound, boolean styleReimagined) {
        String style;
        String string = style = styleUnbound ? "Unbound" : "Reimagined";
        if (styleUnbound && styleReimagined) {
            style = oldContent.toString().contains("EuphoriaPatches") && !oldContent.toString().contains("_1.8.6") && oldContent.toString().contains("Unbound") ? "Unbound" : "Reimagined";
        }
        String newName = "Complementary" + style + "_r5.7.1" + " + " + "EuphoriaPatches" + "_1.8.6";
        return oldContent.toString().replaceAll("shaderPack=.*", "shaderPack=" + newName);
    }
}

