/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.features;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.ModsDirectory;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ModFolderVersionChecker {
    private static final String MOD_PREFIX = "EuphoriaPatcher-";
    private static final Pattern VERSION_PATTERN = Pattern.compile("EuphoriaPatcher-(\\d+\\.\\d+\\.\\d+)(?:-r.*)?-.*\\.jar");

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ModFolderVersionChecker] " + message);
    }

    public static boolean existsNewerModInFolder() {
        ModFolderVersionChecker.debugLog("Checking for newer mod versions in folder");
        String currentVersion = "_1.8.6".substring(1);
        ModFolderVersionChecker.debugLog("Current version: " + currentVersion);
        File folder = ModsDirectory.get().toFile();
        ModFolderVersionChecker.debugLog("Checking mods directory: " + folder);
        File[] modFiles = folder.listFiles((dir, name) -> name.startsWith(MOD_PREFIX) && name.endsWith(".jar"));
        if (modFiles == null || modFiles.length == 0) {
            ModFolderVersionChecker.debugLog("No EuphoriaPatcher mod files found in directory");
            return false;
        }
        if (modFiles.length == 1) {
            ModFolderVersionChecker.debugLog("Only one EuphoriaPatcher mod file found (current version), no check needed");
            return false;
        }
        ModFolderVersionChecker.debugLog("Found " + modFiles.length + " EuphoriaPatcher mod file(s)");
        Arrays.sort(modFiles, Comparator.comparing(File::getName).reversed());
        for (File modFile : modFiles) {
            Matcher matcher = VERSION_PATTERN.matcher(modFile.getName());
            if (!matcher.find()) continue;
            String fileMainVersion = matcher.group(1);
            ModFolderVersionChecker.debugLog("Comparing file version " + fileMainVersion + " with current " + currentVersion);
            int mainComparison = VersionComparator.compareVersionStrings(fileMainVersion, currentVersion);
            if (mainComparison > 0) {
                ModFolderVersionChecker.debugLog("Found newer version: " + fileMainVersion);
                EuphoriaPatcher.log(0, "Found newer version: " + modFile.getName());
                return true;
            }
            if (mainComparison < 0) {
                ModFolderVersionChecker.debugLog("Found older version: " + fileMainVersion + ", attempting to delete");
                try {
                    Files.delete(modFile.toPath());
                    ModFolderVersionChecker.debugLog("Successfully deleted: " + modFile.getName());
                    EuphoriaPatcher.log(0, "Successfully deleted older version: " + modFile.getName());
                }
                catch (IOException e) {
                    ModFolderVersionChecker.debugLog("Failed to delete: " + modFile.getName() + " - " + e.getMessage());
                    EuphoriaPatcher.log(2, 0, "Failed to delete older version: " + modFile.getName() + " - " + e.getMessage());
                }
                continue;
            }
            ModFolderVersionChecker.debugLog("Same version found: " + fileMainVersion);
        }
        ModFolderVersionChecker.debugLog("No newer version found");
        return false;
    }
}

