/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.fabric.mixin;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import com.euphoriapatches.euphoria_patcher.util.ShaderData;
import com.euphoriapatches.euphoria_patcher.util.UpdateChecker;
import com.euphoriapatches.euphoria_patcher.util.VersionComparator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Pseudo
@Mixin(targets={"net.irisshaders.iris.gui.element.ShaderPackOptionList$HeaderEntry"}, remap=false)
public class IrisHeaderEntryMixin {
    @Unique
    private static String euphoriaPatcher$EuphoriaURL = "https://euphoriapatches.com/support";
    @Unique
    private long euphoriaPatcher$buttonHoverStartTime = 0L;
    @Unique
    private boolean euphoriaPatcher$isCurrentlyHovering = false;
    @Unique
    private static boolean euphoriaPatcher$hasShownExtendedTooltip = false;

    @Inject(method={"<init>"}, at={@At(value="RETURN")}, remap=false, require=0)
    private void onConstructor(CallbackInfo ci) {
        try {
            EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
            ShaderDetector shaderDetector = instance.getShaderDetector();
            Path currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath();
            String buttonText = "Support EP";
            int buttonColor = 0;
            boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath);
            if (isUpdateAvailable) {
                buttonText = "Update EP!";
                buttonColor = 2;
                euphoriaPatcher$EuphoriaURL = "https://euphoriapatches.com/download";
            } else {
                euphoriaPatcher$EuphoriaURL = "https://euphoriapatches.com/support";
            }
            if (this.euphoriaPatcher$shouldShowEPButton()) {
                this.euphoriaPatcher$addEPIrisButton(buttonText, buttonColor);
            }
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Failed to add Iris EP button: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Inject(method={"renderContent"}, at={@At(value="TAIL")}, remap=false, require=0)
    private void onRenderContent(@Coerce Object guiGraphics, int mouseX, int mouseY, boolean bl, float tickDelta, CallbackInfo ci) {
        try {
            Object utilityButtons = this.euphoriaPatcher$getFieldValue(this, "utilityButtons");
            Object resetButton = this.euphoriaPatcher$getFieldValue(this, "resetButton");
            if (utilityButtons == null) {
                return;
            }
            this.euphoriaPatcher$renderTooltip(guiGraphics, utilityButtons, resetButton);
            this.euphoriaPatcher$recolorEPButtonWhileShift();
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error rendering tooltip: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Unique
    private boolean euphoriaPatcher$shouldShowEPButton() {
        EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
        ShaderDetector shaderDetector = instance.getShaderDetector();
        Path currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath();
        boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath);
        ShaderData.PersistentShaderData data = ShaderData.load();
        boolean userAllowsSupportButton = false;
        if (data.supportEPButtonVisible == null || data.supportEPButtonVisible.booleanValue()) {
            this.euphoriaPatcher$debugLog("User has not dismissed EP support button");
            userAllowsSupportButton = true;
        } else {
            this.euphoriaPatcher$debugLog("User has dismissed EP support button - not adding button");
        }
        boolean shouldShowSupportButton = shaderDetector.noDevVersionsInstalled() && userAllowsSupportButton;
        boolean secondCondition = shouldShowSupportButton || isUpdateAvailable;
        return shaderDetector.isEuphoriaPatchesShader(currentShaderPackPath) && secondCondition;
    }

    @Unique
    private boolean euphoriaPatcher$isShiftDown() {
        try {
            Class<?> minecraftClass = Class.forName("net.minecraft.client.Minecraft");
            Object minecraft = minecraftClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            return (Boolean)minecraft.getClass().getMethod("hasShiftDown", new Class[0]).invoke(minecraft, new Object[0]);
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error detecting shift key: " + e.getMessage());
            return false;
        }
    }

    @Unique
    private void euphoriaPatcher$recolorEPButtonWhileShift() {
        try {
            String buttonColorFormatting;
            String buttonTextLiteral;
            Object utilityButtons = this.euphoriaPatcher$getFieldValue(this, "utilityButtons");
            Object resetButton = this.euphoriaPatcher$getFieldValue(this, "resetButton");
            if (utilityButtons == null) {
                return;
            }
            EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
            ShaderDetector shaderDetector = instance.getShaderDetector();
            Path currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath();
            boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath);
            boolean shiftDown = this.euphoriaPatcher$isShiftDown();
            if (isUpdateAvailable) {
                buttonTextLiteral = "Update EP!";
                buttonColorFormatting = "GREEN";
            } else if (shiftDown) {
                buttonTextLiteral = "Support EP";
                buttonColorFormatting = "RED";
            } else {
                buttonTextLiteral = "Support EP";
                buttonColorFormatting = "LIGHT_PURPLE";
            }
            Class<?> componentClass = Class.forName("net.minecraft.network.chat.Component");
            Class<?> chatFormattingClass = Class.forName("net.minecraft.ChatFormatting");
            Object buttonColorFormattingEnum = chatFormattingClass.getField(buttonColorFormatting).get(null);
            Object buttonText = componentClass.getMethod("literal", String.class).invoke(null, buttonTextLiteral);
            buttonText = buttonText.getClass().getMethod("withStyle", chatFormattingClass).invoke(buttonText, buttonColorFormattingEnum);
            Object children = utilityButtons.getClass().getMethod("children", new Class[0]).invoke(utilityButtons, new Object[0]);
            Iterable childrenIterable = (Iterable)children;
            Class<?> textButtonElementClass = Class.forName("net.irisshaders.iris.gui.element.IrisElementRow$TextButtonElement");
            for (Object child : childrenIterable) {
                if (!textButtonElementClass.isInstance(child) || child == resetButton) continue;
                Field textField = child.getClass().getField("text");
                textField.setAccessible(true);
                textField.set(child, buttonText);
                break;
            }
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error recoloring EP button: " + e.getMessage());
        }
    }

    @Unique
    private void euphoriaPatcher$addEPIrisButton(String buttonTextLiteral, int buttonColor) {
        try {
            String buttonColorFormatting;
            Object utilityButtons = this.euphoriaPatcher$getFieldValue(this, "utilityButtons");
            Object screen = this.euphoriaPatcher$getFieldValue(this, "screen");
            if (utilityButtons == null) {
                this.euphoriaPatcher$debugLog("utilityButtons field not found");
                return;
            }
            switch (buttonColor) {
                case 1: {
                    buttonColorFormatting = "RED";
                    break;
                }
                case 2: {
                    buttonColorFormatting = "GREEN";
                    break;
                }
                case 3: {
                    buttonColorFormatting = "BLUE";
                    break;
                }
                default: {
                    buttonColorFormatting = "LIGHT_PURPLE";
                }
            }
            Class<?> minecraftClass = Class.forName("net.minecraft.client.Minecraft");
            Object minecraft = minecraftClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Class<?> componentClass = Class.forName("net.minecraft.network.chat.Component");
            Class<?> chatFormattingClass = Class.forName("net.minecraft.ChatFormatting");
            Object buttonColorFormattingEnum = chatFormattingClass.getField(buttonColorFormatting).get(null);
            Object buttonText = componentClass.getMethod("literal", String.class).invoke(null, buttonTextLiteral);
            buttonText = buttonText.getClass().getMethod("withStyle", chatFormattingClass).invoke(buttonText, buttonColorFormattingEnum);
            Object supportEPButton = this.euphoriaPatcher$createIrisButton(buttonText, () -> this.euphoriaPatcher$handleSupportEPButtonClick(minecraft, screen));
            this.euphoriaPatcher$addButtonToRow(utilityButtons, supportEPButton, 66);
            this.euphoriaPatcher$debugLog("Successfully added Iris EP button (Modern)");
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error in addEPIrisButton: " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Unique
    private Object euphoriaPatcher$createIrisButton(Object buttonText, Runnable action) throws Exception {
        Class<?> textButtonElementClass = Class.forName("net.irisshaders.iris.gui.element.IrisElementRow$TextButtonElement");
        for (Constructor<?> ctor : textButtonElementClass.getConstructors()) {
            Class<?>[] paramTypes = ctor.getParameterTypes();
            if (paramTypes.length != 2) continue;
            Class<?> actionClass = paramTypes[1];
            Object actionProxy = Proxy.newProxyInstance(actionClass.getClassLoader(), new Class[]{actionClass}, (proxy, method, args) -> {
                action.run();
                return true;
            });
            return ctor.newInstance(buttonText, actionProxy);
        }
        throw new Exception("Could not find TextButtonElement constructor");
    }

    @Unique
    private void euphoriaPatcher$addButtonToRow(Object utilityButtons, Object button, int width) throws Exception {
        for (Method method : utilityButtons.getClass().getMethods()) {
            Class<?>[] paramTypes;
            if (!method.getName().equals("add") || method.getParameterCount() != 2 || (paramTypes = method.getParameterTypes())[1] != Integer.TYPE && paramTypes[1] != Integer.class) continue;
            method.invoke(utilityButtons, button, width);
            return;
        }
        throw new Exception("Could not find add method on utilityButtons");
    }

    @Unique
    private void euphoriaPatcher$handleSupportEPButtonClick(Object minecraft, Object screen) {
        try {
            this.euphoriaPatcher$playButtonClickSound();
            if (this.euphoriaPatcher$isShiftDown()) {
                this.euphoriaPatcher$debugLog("Pressed Shift while clicking EP button - removing button");
                ShaderData.save(ShaderData.SaveData.of(ShaderData.DataField.SUPPORT_EP_BUTTON, false));
                return;
            }
            Class<?> confirmLinkScreenClass = Class.forName("net.minecraft.client.gui.screens.ConfirmLinkScreen");
            Constructor<?> constructor = null;
            Class<?> consumerClass = null;
            for (Constructor<?> ctor : confirmLinkScreenClass.getConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (paramTypes.length != 3 || paramTypes[1] != String.class || paramTypes[2] != Boolean.TYPE) continue;
                constructor = ctor;
                consumerClass = paramTypes[0];
                break;
            }
            if (constructor == null) {
                this.euphoriaPatcher$debugLog("Could not find ConfirmLinkScreen constructor");
                return;
            }
            Object booleanConsumer = Proxy.newProxyInstance(consumerClass.getClassLoader(), new Class[]{consumerClass}, (proxy, method, args) -> {
                if (args != null && args.length > 0 && args[0] instanceof Boolean) {
                    boolean confirmed = (Boolean)args[0];
                    if (confirmed) {
                        this.euphoriaPatcher$openUrl();
                    }
                    this.euphoriaPatcher$setScreen(minecraft, screen);
                }
                return null;
            });
            Object confirmScreen = constructor.newInstance(booleanConsumer, euphoriaPatcher$EuphoriaURL, true);
            this.euphoriaPatcher$setScreen(minecraft, confirmScreen);
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Error handling button click (Modern): " + e.getMessage());
            this.euphoriaPatcher$debugLog(EuphoriaLogger.getStackTrace(e));
        }
    }

    @Unique
    private void euphoriaPatcher$playButtonClickSound() {
        try {
            Class<?> guiUtilClass = Class.forName("net.irisshaders.iris.gui.GuiUtil");
            guiUtilClass.getMethod("playButtonClickSound", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Unique
    private void euphoriaPatcher$openUrl() {
        try {
            Class<?> utilClass;
            try {
                utilClass = Class.forName("net.minecraft.Util");
            }
            catch (ClassNotFoundException e) {
                utilClass = Class.forName("net.minecraft.util.Util");
            }
            Object platform = utilClass.getMethod("getPlatform", new Class[0]).invoke(null, new Object[0]);
            platform.getClass().getMethod("openUri", String.class).invoke(platform, euphoriaPatcher$EuphoriaURL);
            this.euphoriaPatcher$debugLog("Successfully opened URL (Modern)");
        }
        catch (Exception e) {
            this.euphoriaPatcher$debugLog("Failed to open URL (Modern): " + e.getMessage());
        }
    }

    @Unique
    private void euphoriaPatcher$setScreen(Object minecraft, Object screen) throws Exception {
        Class<?> screenClass = Class.forName("net.minecraft.client.gui.screens.Screen");
        minecraft.getClass().getMethod("setScreen", screenClass).invoke(minecraft, screen);
    }

    @Unique
    private void euphoriaPatcher$renderTooltip(Object guiGraphics, Object utilityButtons, Object resetButton) throws Exception {
        Class<?> minecraftClass = Class.forName("net.minecraft.client.Minecraft");
        Object minecraft = minecraftClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        Object font = minecraft.getClass().getField("font").get(minecraft);
        Object children = utilityButtons.getClass().getMethod("children", new Class[0]).invoke(utilityButtons, new Object[0]);
        Iterable childrenIterable = (Iterable)children;
        Class<?> textButtonElementClass = Class.forName("net.irisshaders.iris.gui.element.IrisElementRow$TextButtonElement");
        for (Object child : childrenIterable) {
            if (!textButtonElementClass.isInstance(child) || child == resetButton) continue;
            boolean isHovered = (Boolean)child.getClass().getMethod("isHovered", new Class[0]).invoke(child, new Object[0]);
            boolean isFocused = false;
            try {
                isFocused = (Boolean)child.getClass().getMethod("isFocused", new Class[0]).invoke(child, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isHovered || isFocused) {
                String colorFormatting;
                String tooltipString;
                Path currentShaderPackPath;
                if (!euphoriaPatcher$hasShownExtendedTooltip) {
                    long hoverDuration;
                    long currentTime = System.currentTimeMillis();
                    if (!this.euphoriaPatcher$isCurrentlyHovering) {
                        this.euphoriaPatcher$buttonHoverStartTime = currentTime;
                        this.euphoriaPatcher$isCurrentlyHovering = true;
                    }
                    if ((hoverDuration = currentTime - this.euphoriaPatcher$buttonHoverStartTime) >= 1715L) {
                        euphoriaPatcher$hasShownExtendedTooltip = true;
                    }
                }
                boolean shiftDown = this.euphoriaPatcher$isShiftDown();
                EuphoriaPatcher instance = EuphoriaPatcher.getInstance();
                ShaderDetector shaderDetector = instance.getShaderDetector();
                boolean isUpdateAvailable = this.euphoriaPatcher$isUpdateAvailable(shaderDetector, currentShaderPackPath = ShaderLoader.getCurrentShaderpackPath());
                if (isUpdateAvailable) {
                    tooltipString = "Update Euphoria Patches!";
                    colorFormatting = "GREEN";
                } else if (shiftDown) {
                    tooltipString = "Remove Support Button? Requires re-entering the menu to show effect";
                    colorFormatting = "RED";
                } else {
                    String removeString = "";
                    if (euphoriaPatcher$hasShownExtendedTooltip) {
                        removeString = " (SHIFT Click to Remove)";
                    }
                    tooltipString = "Support Euphoria Patches!" + removeString;
                    colorFormatting = "LIGHT_PURPLE";
                }
                Class<?> componentClass = Class.forName("net.minecraft.network.chat.Component");
                Class<?> formattedTextClass = Class.forName("net.minecraft.network.chat.FormattedText");
                Class<?> chatFormattingClass = Class.forName("net.minecraft.ChatFormatting");
                Object colorFormattingEnum = chatFormattingClass.getField(colorFormatting).get(null);
                Object tooltipText = componentClass.getMethod("literal", String.class).invoke(null, tooltipString);
                tooltipText = tooltipText.getClass().getMethod("withStyle", chatFormattingClass).invoke(tooltipText, colorFormattingEnum);
                Object rect = child.getClass().getMethod("getRectangle", new Class[0]).invoke(child, new Object[0]);
                Class<?> screenDirectionClass = Class.forName("net.minecraft.client.gui.navigation.ScreenDirection");
                Object rightDirection = screenDirectionClass.getField("RIGHT").get(null);
                int rightBound = (Integer)rect.getClass().getMethod("getBoundInDirection", screenDirectionClass).invoke(rect, rightDirection);
                Object position = rect.getClass().getMethod("position", new Class[0]).invoke(rect, new Object[0]);
                int yPos = (Integer)position.getClass().getMethod("y", new Class[0]).invoke(position, new Object[0]);
                int textWidth = (Integer)font.getClass().getMethod("width", formattedTextClass).invoke(font, tooltipText);
                int tooltipX = rightBound - (textWidth + 10);
                int tooltipY = yPos - 16;
                Object finalFont = font;
                Object finalGuiGraphics = guiGraphics;
                Object finalTooltipText = tooltipText;
                int finalTooltipX = tooltipX;
                int finalTooltipY = tooltipY;
                Class<?> shaderPackScreenClass = Class.forName("net.irisshaders.iris.gui.screen.ShaderPackScreen");
                Object renderQueue = shaderPackScreenClass.getField("TOP_LAYER_RENDER_QUEUE").get(null);
                Class<?> guiUtilClass = Class.forName("net.irisshaders.iris.gui.GuiUtil");
                Runnable renderTask = () -> {
                    try {
                        guiUtilClass.getMethod("drawTextPanel", finalFont.getClass(), finalGuiGraphics.getClass(), componentClass, Integer.TYPE, Integer.TYPE).invoke(null, finalFont, finalGuiGraphics, finalTooltipText, finalTooltipX, finalTooltipY);
                    }
                    catch (Exception e) {
                        this.euphoriaPatcher$debugLog("Error in render task: " + e.getMessage());
                    }
                };
                renderQueue.getClass().getMethod("add", Object.class).invoke(renderQueue, renderTask);
                break;
            }
            this.euphoriaPatcher$isCurrentlyHovering = false;
            break;
        }
    }

    @Unique
    private boolean euphoriaPatcher$isUpdateAvailable(ShaderDetector shaderDetector, Path currentShaderPackPath) {
        return UpdateChecker.shouldUserUpdate() && VersionComparator.isNewerVersion(UpdateChecker.getNewModVersion(), shaderDetector.readVersionFromPackJson(currentShaderPackPath));
    }

    @Unique
    private Object euphoriaPatcher$getFieldValue(Object obj, String fieldName) {
        for (Class<?> clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(obj);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                this.euphoriaPatcher$debugLog("Error accessing field " + fieldName + ": " + e.getMessage());
                return null;
            }
        }
        this.euphoriaPatcher$debugLog("Field " + fieldName + " not found in class hierarchy");
        return null;
    }

    @Unique
    private void euphoriaPatcher$debugLog(String message) {
        EuphoriaLogger.debugLog("[IrisHeaderEntryMixinModern] " + message);
    }
}

