/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.fabric;

import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.util.Dimensions;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class FabricModLoaderSpecifics
extends ModLoaderSpecifics {
    private final Path shaderpacksPath = FabricLoader.getInstance().getGameDir().resolve("shaderpacks");
    private final Path configDirectory = FabricLoader.getInstance().getConfigDir();
    private static Boolean useYarnMappings = null;

    @Override
    public Path getShaderpacksPath() {
        return this.shaderpacksPath;
    }

    @Override
    public String getInstanceName() {
        return "Fabric";
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    @Override
    public boolean serverCheck() {
        try {
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
                System.err.println("[EuphoriaPatcher] Server Detected! The Euphoria Patcher Mod disables itself gracefully on a server. Disabling...");
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getCurrentDimension() {
        return Dimensions.getCurrentDimension(this.getCurrentDimensionID());
    }

    @Override
    public boolean isCurrentDimensionInMappings() {
        return Dimensions.isCurrentDimensionInMappings(this.getCurrentDimensionID());
    }

    @Override
    public boolean setClipboard(String str) {
        if (useYarnMappings == null) {
            this.discoverMappingBranch();
        }
        try {
            long windowHandle;
            if (useYarnMappings.booleanValue()) {
                class_310 client = class_310.method_1551();
                if (client == null || client.method_22683() == null) {
                    this.debugLog("Client or window is null, cannot set clipboard");
                    return false;
                }
                windowHandle = client.method_22683().method_4490();
            } else {
                Class<?> mcClass = Class.forName("net.minecraft.client.Minecraft");
                Object mcInstance = mcClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                if (mcInstance == null) {
                    this.debugLog("Minecraft instance is null, cannot set clipboard");
                    return false;
                }
                Object window = mcClass.getMethod("getWindow", new Class[0]).invoke(mcInstance, new Object[0]);
                if (window == null) {
                    this.debugLog("Window is null, cannot set clipboard");
                    return false;
                }
                Class<?> windowClass = window.getClass();
                this.debugLog("Window class: " + windowClass.getName());
                try {
                    windowHandle = (Long)windowClass.getMethod("handle", new Class[0]).invoke(window, new Object[0]);
                    this.debugLog("Accessed window handle via handle() method");
                }
                catch (NoSuchMethodException e1) {
                    this.debugLog("handle() method not found");
                    return false;
                }
            }
            GLFW.glfwSetClipboardString((long)windowHandle, (CharSequence)str);
            return true;
        }
        catch (Exception e) {
            this.debugLog("Error setting clipboard: " + e.getMessage());
            return false;
        }
    }

    private String getCurrentDimensionID() {
        if (useYarnMappings == null) {
            this.discoverMappingBranch();
        }
        if (useYarnMappings != null && useYarnMappings.booleanValue()) {
            return this.getCurrentDimensionIDYarn();
        }
        if (useYarnMappings != null && !useYarnMappings.booleanValue()) {
            return this.getCurrentDimensionIDModern();
        }
        return "minecraft:overworld";
    }

    private void discoverMappingBranch() {
        if (useYarnMappings != null) {
            return;
        }
        try {
            class_310 client = class_310.method_1551();
            if (client != null) {
                useYarnMappings = true;
                this.debugLog("Using Yarn mappings");
                return;
            }
        }
        catch (Throwable t) {
            this.debugLog("Yarn method failed, trying reflection: " + t.getMessage());
        }
        try {
            Class<?> mcClass = Class.forName("net.minecraft.client.Minecraft");
            Object mcInstance = mcClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            if (mcInstance != null) {
                useYarnMappings = false;
                this.debugLog("Using reflection");
                return;
            }
        }
        catch (Throwable t) {
            this.debugLog("Reflection method also failed: " + t.getMessage());
        }
    }

    private String getCurrentDimensionIDYarn() {
        this.debugLog("Getting current dimension (Yarn)");
        try {
            class_310 client = class_310.method_1551();
            if (client == null || client.field_1687 == null) {
                this.debugLog("Client or world is null, defaulting to 'minecraft:overworld'");
                return "minecraft:overworld";
            }
            class_2960 dimensionId = client.field_1687.method_27983().method_29177();
            String currentDimensionId = dimensionId.toString();
            this.debugLog("Current dimension ID: " + currentDimensionId);
            return currentDimensionId;
        }
        catch (Exception e) {
            this.debugLog("Error in Yarn method: " + e.getMessage());
            return "minecraft:overworld";
        }
    }

    private String getCurrentDimensionIDModern() {
        this.debugLog("Getting current dimension (Reflection for net.minecraft.client.Minecraft)");
        try {
            Class<?> mcClass = Class.forName("net.minecraft.client.Minecraft");
            Object mcInstance = mcClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            if (mcInstance == null) {
                this.debugLog("Minecraft instance is null, defaulting to 'minecraft:overworld'");
                return "minecraft:overworld";
            }
            Object level = mcClass.getField("level").get(mcInstance);
            if (level == null) {
                this.debugLog("Level is null, defaulting to 'minecraft:overworld'");
                return "minecraft:overworld";
            }
            Class<?> levelClass = level.getClass();
            Object dimension = levelClass.getMethod("dimension", new Class[0]).invoke(level, new Object[0]);
            String dimensionString = dimension.toString();
            this.debugLog("Dimension toString(): " + dimensionString);
            String currentDimensionId = dimensionString.contains("/") ? dimensionString.substring(dimensionString.indexOf("/") + 1).replace("]", "").trim() : "minecraft:overworld";
            this.debugLog("Current dimension ID (parsed): " + currentDimensionId);
            return currentDimensionId;
        }
        catch (Exception e) {
            this.debugLog("Error in reflection method: " + e.getMessage());
            return "minecraft:overworld";
        }
    }

    private void debugLog(String message) {
        EuphoriaLogger.debugLog("[FabricModLoaderSpecifics] " + message);
    }
}

