/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.config;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.config.Config;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.util.Locale;

public class ConfigHandler {
    public static boolean doPopUpLogging = true;
    public static String updateMode = "important";
    public static boolean doRenameOldShaderFiles = true;
    public static boolean doDeleteOldShaderFiles = false;
    public static boolean doDisplayShaderInGameMessage = true;
    public static boolean doDebugLogging = false;
    public static String alternativeShaderNames = "";
    public static boolean autoMergeBlockProperties = false;

    public static void configStuff() {
        Config.initialize();
        Config.setConfigCategoryOrder("display", "updates", "maintenance", "debug", "advanced");
        doPopUpLogging = Config.readWriteConfig("display", "doPopUpLogging", true, "Option for the sodium message popup logging.\nDefault = true");
        updateMode = Config.readWriteConfig("updates", "doUpdateChecking", "important", "Option which determines what updates the update checker considers.\nUpdate checker mode: 'important' (critical or big updates only), 'all' (all updates), 'none' (disabled).\nUses the Modrinth API to fetch update information.\nDefault = important", new String[]{"important", "all", "none"}, Config.TypeMigration.map(false, "none"), Config.TypeMigration.map(true, "important")).toLowerCase(Locale.ROOT);
        doRenameOldShaderFiles = Config.readWriteConfig("maintenance", "doRenameOldShaderFiles", true, "Option that automatically renames outdated Euphoria Patches folders and config files to a new name.\nThis makes it easier for users to identify which ones are outdated.\nDefault = true");
        doDeleteOldShaderFiles = Config.readWriteConfig("maintenance", "doDeleteOldShaderFiles", false, "Option that automatically deletes outdated Euphoria Patches folders and config files.\nDefault = false");
        doDisplayShaderInGameMessage = Config.readWriteConfig("display", "doDisplayShaderInGameMessage", true, "Option that enables or disables the in-game shader messages, for example an update message made by the shader itself. Only works on Iris or Oculus\nDefault = true");
        alternativeShaderNames = Config.readWriteConfig("advanced", "alternativeShaderNames", "", "Here one can set alternative Shader Names which will also be generated alongside the normal one.\nThis is useful if you want multiple different settings you can quickly switch between\nDefault = Empty String, which means no alternative names will be generated.\nIn case of multiple names, separate them with a comma\nYou can also use {baseVersion} or {patchVersion} in names to insert the base shader or Euphoria Patches version.\nExample: Euphoria Saturated, Comp_{baseVersion} + EP_{patchVersion} Dark Settings, EP High Performance, etc...");
        boolean configDebugLogging = Config.readWriteConfig("debug", "doDebugLogging", false, "Option that enables or disables debug logging. Alternatively, one can also set the JVM argument -DebugEP=true/false which takes priority over this setting.\nDefault = false");
        ConfigHandler.handleJVMArgumentDebugLogging(configDebugLogging);
        boolean configAutoMergeBlockProperties = Config.readWriteConfig("advanced", "autoMergeBlockProperties", false, "Option that enables or disables automatic merging of the fragmented block.properties files into the main block.properties file.\nThe properties files inside \"Euphoria Patches/shaders/properties/\" will be merged into a single block.properties file at the specified interval if any of them have changed.\nThis helps organizing the files, reduces the number of entries in a single file and improves speed while editing them. \nSince they are merged automatically into the final block.properties file, the individual files can be edited without worrying about merge conflicts or losing changes.\nDefault = false");
        ConfigHandler.handleSpaceEagleAutoMergeBlockProperties(configAutoMergeBlockProperties);
        Config.regenerateConfig();
        Config.startConfigWatcher();
    }

    private static void handleJVMArgumentDebugLogging(boolean configDebugLogging) {
        String jvmDebugArg = System.getProperty("ebugEP");
        if (jvmDebugArg != null) {
            String argLower = jvmDebugArg.trim().toLowerCase(Locale.ROOT);
            if ("true".equals(argLower) || "false".equals(argLower)) {
                doDebugLogging = Boolean.parseBoolean(argLower);
                ConfigHandler.debugLog("Debug logging set via JVM argument -DebugEP=" + jvmDebugArg + " (overriding config value)");
            } else {
                EuphoriaPatcher.log(2, 0, "Invalid value for -DebugEP: " + jvmDebugArg + ". Only 'true' or 'false' are accepted. Using config value.");
                doDebugLogging = configDebugLogging;
            }
        } else {
            doDebugLogging = configDebugLogging;
        }
    }

    private static void handleSpaceEagleAutoMergeBlockProperties(boolean configAutoMergeBlockProperties) {
        if (EuphoriaPatcher.isSpacEagle()) {
            autoMergeBlockProperties = true;
            ConfigHandler.debugLog("Automatic merging of block.properties files enabled due to user being SpaceEagle17");
        } else {
            autoMergeBlockProperties = configAutoMergeBlockProperties;
            ConfigHandler.debugLog("Automatic merging of block.properties files set to " + autoMergeBlockProperties + " via config");
        }
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[ConfigHandler] " + message);
    }

    public static final class UpdateMode {
        public static final String IMPORTANT = "important";
        public static final String ALL = "all";
        public static final String NONE = "none";

        private UpdateMode() {
        }
    }
}

