/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.config;

public class ConfigEntry<T> {
    private final String category;
    private final String key;
    private final T defaultValue;
    private final String description;
    private final ConfigType type;
    private final String[] allowedValues;

    public ConfigEntry(String category, String key, T defaultValue, String description) {
        this(category, key, defaultValue, description, null);
    }

    public ConfigEntry(String category, String key, T defaultValue, String description, String[] allowedValues) {
        this.category = category;
        this.key = key;
        this.defaultValue = defaultValue;
        this.description = description;
        this.type = this.determineType(defaultValue);
        this.allowedValues = allowedValues;
    }

    private ConfigType determineType(Object value) {
        if (value instanceof Boolean) {
            return ConfigType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return ConfigType.INTEGER;
        }
        if (value instanceof Double) {
            return ConfigType.DOUBLE;
        }
        return ConfigType.STRING;
    }

    public String getCategory() {
        return this.category;
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public ConfigType getType() {
        return this.type;
    }

    public String[] getAllowedValues() {
        return this.allowedValues;
    }

    public String getAsString(Object value) {
        if (value != null) {
            return value.toString();
        }
        if (this.defaultValue != null) {
            return this.defaultValue.toString();
        }
        return "";
    }

    public Boolean getAsBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        if (this.defaultValue instanceof Boolean) {
            return (Boolean)this.defaultValue;
        }
        return false;
    }

    public Integer getAsInteger(Object value) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                if (this.defaultValue instanceof Integer) {
                    return (Integer)this.defaultValue;
                }
                return 0;
            }
        }
        if (this.defaultValue instanceof Integer) {
            return (Integer)this.defaultValue;
        }
        return 0;
    }

    public Double getAsDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                if (this.defaultValue instanceof Double) {
                    return (Double)this.defaultValue;
                }
                return 0.0;
            }
        }
        if (this.defaultValue instanceof Double) {
            return (Double)this.defaultValue;
        }
        return 0.0;
    }

    public static enum ConfigType {
        BOOLEAN,
        INTEGER,
        DOUBLE,
        STRING;

    }
}

