/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher.config;

import com.euphoriapatches.euphoria_patcher.EuphoriaPatcher;
import com.euphoriapatches.euphoria_patcher.config.ConfigEntry;
import com.euphoriapatches.euphoria_patcher.config.ConfigHandler;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Config {
    public static final Path CONFIG_DIR = EuphoriaPatcher.configDirectory.resolve("euphoria_patcher");
    private static final Path CONFIG_PATH = CONFIG_DIR.resolve("settings.toml");
    private static final Path OLD_CONFIG_PATH = EuphoriaPatcher.configDirectory.resolve("euphoria_patcher.properties");
    private static final Map<String, Object> configValues = new LinkedHashMap<String, Object>();
    private static final Map<String, ConfigEntry<?>> configSchema = new LinkedHashMap();
    private static final List<String> categoryOrder = new ArrayList<String>();
    private static FileTime lastModified = null;
    private static boolean watcherActive = false;
    private static ScheduledExecutorService scheduler;
    private static boolean migrationCompleted;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[Config] " + message);
    }

    private static void migrateOldConfig() {
        if (migrationCompleted || !Files.exists(OLD_CONFIG_PATH, new LinkOption[0])) {
            migrationCompleted = true;
            return;
        }
        migrationCompleted = true;
        Config.debugLog("Migrating old config file to TOML format");
        try (InputStream in = Files.newInputStream(OLD_CONFIG_PATH, new OpenOption[0]);){
            Properties oldProps = new Properties();
            oldProps.load(in);
            for (String key : oldProps.stringPropertyNames()) {
                String value = oldProps.getProperty(key);
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    configValues.put(key, Boolean.parseBoolean(value));
                    continue;
                }
                configValues.put(key, value);
            }
            Files.delete(OLD_CONFIG_PATH);
            EuphoriaPatcher.log(0, "Successfully migrated config to TOML format. Old config deleted.");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error migrating old config: " + e.getMessage());
        }
    }

    public static void initialize() {
        Config.migrateOldConfig();
        Config.loadConfig();
    }

    private static void loadConfig() {
        try {
            if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Config.debugLog("No config file found, will create on first save");
                return;
            }
            String currentCategory = "";
            for (String line : Files.readAllLines(CONFIG_PATH)) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    currentCategory = line.substring(1, line.length() - 1);
                    continue;
                }
                if (!line.contains("=")) continue;
                int eqIdx = line.indexOf(61);
                String key = line.substring(0, eqIdx).trim();
                String value = line.substring(eqIdx + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    value = value.replace("\\\\", "\\").replace("\\\"", "\"").replace("\\n", "\n");
                }
                String fullKey = currentCategory.isEmpty() ? key : currentCategory + "." + key;
                configValues.put(fullKey, Config.parseValue(value));
            }
            lastModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
            Config.debugLog("Config loaded successfully");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Error loading config: " + e.getMessage());
        }
    }

    private static Object parseValue(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        try {
            if (value.contains(".")) {
                return Double.parseDouble(value);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static void setConfigCategoryOrder(String ... categories) {
        categoryOrder.clear();
        categoryOrder.addAll(Arrays.asList(categories));
        Config.debugLog("Category order set: " + String.join((CharSequence)", ", categories));
    }

    public static <T> T readWriteConfig(String category, String key, T defaultValue, String description) {
        return Config.readWriteConfig(category, key, defaultValue, description, null, null);
    }

    public static <T> T readWriteConfig(String category, String key, T defaultValue, String description, String[] allowedValues) {
        return Config.readWriteConfig(category, key, defaultValue, description, allowedValues, null);
    }

    public static <T> T readWriteConfig(String category, String key, T defaultValue, String description, String[] allowedValues, TypeMigration ... migrations) {
        ConfigEntry<T> entry = new ConfigEntry<T>(category, key, defaultValue, description, allowedValues);
        String schemaKey = category + "." + key;
        configSchema.put(schemaKey, entry);
        String categorizedKey = category + "." + key;
        Object value = configValues.get(categorizedKey);
        if (value == null && (value = configValues.get(key)) != null) {
            Config.debugLog("Found legacy value for " + key + ", will be moved to " + categorizedKey + " on regenerate");
            configValues.put(categorizedKey, value);
        }
        if (value == null) {
            Config.debugLog("Using default value for " + categorizedKey);
            value = defaultValue;
            configValues.put(categorizedKey, defaultValue);
        } else {
            Object migratedValue = Config.handleTypeMigration(categorizedKey, value, defaultValue, migrations);
            if (migratedValue != value) {
                configValues.put(categorizedKey, migratedValue);
                Config.debugLog("Updated " + categorizedKey + " with migrated value: " + migratedValue);
            }
            value = migratedValue;
        }
        T result = Config.convertValue(entry, value);
        if (allowedValues != null && allowedValues.length > 0 && result instanceof String) {
            String strResult = (String)result;
            boolean isValid = false;
            String normalizedValue = null;
            for (String allowed : allowedValues) {
                if (!allowed.equalsIgnoreCase(strResult)) continue;
                isValid = true;
                normalizedValue = allowed;
                break;
            }
            if (isValid) {
                String typedValue = normalizedValue;
                result = typedValue;
                configValues.put(categorizedKey, normalizedValue);
            } else {
                Config.debugLog("Invalid value '" + strResult + "' for " + categorizedKey + ", using default: " + defaultValue);
                result = defaultValue;
                configValues.put(categorizedKey, defaultValue);
            }
        }
        return result;
    }

    private static Object handleTypeMigration(String key, Object oldValue, Object defaultValue, TypeMigration[] customMigrations) {
        if (oldValue.getClass().equals(defaultValue.getClass())) {
            return oldValue;
        }
        if (customMigrations != null) {
            for (TypeMigration migration : customMigrations) {
                if (!migration.matches(oldValue)) continue;
                Object migratedValue = migration.getNewValue();
                EuphoriaPatcher.log(0, "Migrated '" + key + "' from " + oldValue.getClass().getSimpleName() + " (" + oldValue + ") to " + migratedValue.getClass().getSimpleName() + " (" + migratedValue + ")");
                configValues.put(key, migratedValue);
                return migratedValue;
            }
        }
        EuphoriaPatcher.log(0, "Type mismatch for '" + key + "': stored type " + oldValue.getClass().getSimpleName() + " does not match expected type " + defaultValue.getClass().getSimpleName() + ", using default");
        return defaultValue;
    }

    private static <T> T convertValue(ConfigEntry<T> entry, Object value) {
        switch (entry.getType()) {
            case BOOLEAN: {
                return (T)entry.getAsBoolean(value);
            }
            case INTEGER: {
                return (T)entry.getAsInteger(value);
            }
            case DOUBLE: {
                return (T)entry.getAsDouble(value);
            }
        }
        return (T)entry.getAsString(value);
    }

    public static void regenerateConfig() {
        try {
            LinkedHashMap<String, Object> allValues = new LinkedHashMap<String, Object>(configValues);
            Config.writeTomlFile(allValues);
            Config.loadConfig();
            Config.debugLog("Config file regenerated with proper ordering and header");
        }
        catch (Exception e) {
            EuphoriaPatcher.log(3, 0, "Error regenerating config: " + e.getMessage());
        }
    }

    private static void writeTomlFile(Map<String, Object> values) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# This file stores configuration options for the Euphoria Patcher mod");
        lines.add("# Made for version " + "_1.8.6".replace("_", ""));
        lines.add("# Thank you for using Euphoria Patches - SpacEagle17");
        lines.add("");
        for (int catIndex = 0; catIndex < categoryOrder.size(); ++catIndex) {
            String category = categoryOrder.get(catIndex);
            if (catIndex > 0) {
                lines.add("");
            }
            lines.add("[" + category + "]");
            boolean firstEntry = true;
            for (Map.Entry<String, ConfigEntry<?>> entry : configSchema.entrySet()) {
                String[] commentLines;
                ConfigEntry<?> configEntry = entry.getValue();
                if (!configEntry.getCategory().equals(category)) continue;
                if (!firstEntry) {
                    lines.add("");
                }
                firstEntry = false;
                String fullKey = entry.getKey();
                Object value = values.getOrDefault(fullKey, configEntry.getDefaultValue());
                for (String commentLine : commentLines = Config.formatDescription(configEntry.getDescription()).split("\n")) {
                    lines.add("\t# " + commentLine);
                }
                String valueStr = Config.formatValue(value);
                lines.add("\t" + configEntry.getKey() + " = " + valueStr);
            }
        }
        Files.write(CONFIG_PATH, lines, new OpenOption[0]);
        Config.debugLog("TOML file written with proper ordering");
    }

    private static String formatDescription(String description) {
        String[] lines;
        StringBuilder sb = new StringBuilder();
        for (String line : lines = description.split("\\n")) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line.trim());
        }
        return sb.toString();
    }

    private static String formatValue(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            str = str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
            return "\"" + str + "\"";
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        return "\"" + value.toString() + "\"";
    }

    public static void startConfigWatcher() {
        if (watcherActive) {
            return;
        }
        watcherActive = true;
        scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "EuphoriaConfigWatcher");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> {
            try {
                FileTime currentModified;
                if (Files.exists(CONFIG_PATH, new LinkOption[0]) && !(currentModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0])).equals(lastModified)) {
                    Config.debugLog("Config file changed externally, reloading");
                    Config.loadConfig();
                    ConfigHandler.configStuff();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        Config.debugLog("Config watcher started");
    }

    public static void stopConfigWatcher() {
        if (watcherActive && scheduler != null) {
            scheduler.shutdown();
            watcherActive = false;
            Config.debugLog("Config watcher stopped");
        }
    }

    static {
        migrationCompleted = false;
    }

    public static class TypeMigration {
        private final Object oldValue;
        private final Object newValue;

        private TypeMigration(Object oldValue, Object newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public static TypeMigration map(Object oldValue, Object newValue) {
            return new TypeMigration(oldValue, newValue);
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public boolean matches(Object value) {
            if (this.oldValue == null) {
                return value == null;
            }
            if (value == null) {
                return false;
            }
            if (this.oldValue instanceof String && value instanceof String) {
                return ((String)this.oldValue).equalsIgnoreCase((String)value);
            }
            return this.oldValue.equals(value);
        }
    }
}

