/*
 * Decompiled with CFR 0.152.
 */
package com.euphoriapatches.euphoria_patcher;

import com.euphoriapatches.euphoria_patcher.GUIScreen;
import com.euphoriapatches.euphoria_patcher.config.Config;
import com.euphoriapatches.euphoria_patcher.config.ConfigHandler;
import com.euphoriapatches.euphoria_patcher.features.ModFolderVersionChecker;
import com.euphoriapatches.euphoria_patcher.features.ModifyOutdatedPatches;
import com.euphoriapatches.euphoria_patcher.features.ModifyPatchedShaderpacks;
import com.euphoriapatches.euphoria_patcher.features.UpdateShaderConfig;
import com.euphoriapatches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import com.euphoriapatches.euphoria_patcher.features.properties.PropertiesWatcher;
import com.euphoriapatches.euphoria_patcher.integration.ShaderLoader;
import com.euphoriapatches.euphoria_patcher.logging.EuphoriaLogger;
import com.euphoriapatches.euphoria_patcher.monitoring.PotatoFileMonitor;
import com.euphoriapatches.euphoria_patcher.monitoring.ShaderpacksWatcher;
import com.euphoriapatches.euphoria_patcher.services.ShaderDetector;
import com.euphoriapatches.euphoria_patcher.services.ShaderNamingService;
import com.euphoriapatches.euphoria_patcher.services.ShaderPatchingService;
import com.euphoriapatches.euphoria_patcher.util.ArchiveOperations;
import com.euphoriapatches.euphoria_patcher.util.JsonUtilReader;
import com.euphoriapatches.euphoria_patcher.util.ModLoaderSpecifics;
import com.euphoriapatches.euphoria_patcher.util.ShaderData;
import com.euphoriapatches.euphoria_patcher.util.ShaderPropertyReader;
import com.euphoriapatches.euphoria_patcher.util.ShaderVersionComparator;
import com.euphoriapatches.euphoria_patcher.util.UpdateChecker;
import com.euphoriapatches.euphoria_patcher.util.UserInstallErrorMessages;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;

public class EuphoriaPatcher {
    public static final String BRAND_NAME = "Complementary";
    public static final String PATCH_NAME = "EuphoriaPatches";
    public static final String VERSION = "_r5.7.1";
    public static final String PATCH_VERSION = "_1.8.6";
    public static final String COMP_DOWNLOAD_URL = "https://www.complementary.dev/";
    public static final String EP_DOWNLOAD_URL = "https://euphoriapatches.com/download";
    public static final String COMMON_LOCATION = "shaders/lib/common.glsl";
    public static final String LANG_LOCATION = "shaders/lang";
    public static final String SHADERS_PROPERTIES_LOCATION = "shaders/shaders.properties";
    public static final String SHADER_MYFILE_LOCATION = "shaders/lib/misc/myFile.glsl";
    public static Path shaderpacks = ModLoaderSpecifics.shaderpacks();
    public static Path configDirectory = ModLoaderSpecifics.configDirectory();
    private static boolean ALREADY_LAUNCHED = false;
    private static EuphoriaPatcher instance;
    private ShaderpacksWatcher shaderpacksWatcher;
    private static EuphoriaLogger loggerInstance;
    private ShaderDetector shaderDetector;
    private ShaderPatchingService patchingService;
    private ShaderVersionComparator versionComparator;
    private ShaderNamingService namingService;

    public EuphoriaPatcher() {
        if (ALREADY_LAUNCHED) {
            return;
        }
        ALREADY_LAUNCHED = true;
        instance = this;
        System.out.println("\nEuphoria Patcher:");
        loggerInstance = new EuphoriaLogger();
        loggerInstance.checkErrorLogFileAndAddSeparator();
        GUIScreen.doSomethingRandomToPreventMinimization(3, 7);
        ConfigHandler.configStuff();
        ShaderData.validateShaderDataHash();
        if (ShaderData.isIncorrectVersion()) {
            ShaderData.resetShaderStyles();
        }
        if (ModFolderVersionChecker.existsNewerModInFolder()) {
            return;
        }
        if (ConfigHandler.doPopUpLogging) {
            loggerInstance.checkAndSetupSodiumLogging();
        }
        UpdateChecker.checkForUpdates();
        ShaderLoader.getShaderLoader();
        EuphoriaPatcher.log(0, JsonUtilReader.getRandomMessage("startupMessages"));
        UpdateShaderConfig.markAllEPSettingsFiles();
        this.initializeServices();
        ShaderDetector.ShaderInfo shaderInfo = this.shaderDetector.detectInstalledShaders(this.namingService);
        if (!shaderInfo.isAlreadyInstalled) {
            if (shaderInfo.baseFile == null) {
                UserInstallErrorMessages.handleShaderNotFound(this.versionComparator);
                return;
            }
        } else {
            if (!shaderInfo.styleReimagined && !shaderInfo.styleUnbound && ShaderData.dataFileExists()) {
                ShaderData.PersistentShaderData data = ShaderData.load();
                if (data.styleReimagined == null || data.styleUnbound == null) {
                    EuphoriaPatcher.debugLog("Could not load data.json, cannot check for missing styles");
                } else {
                    shaderInfo.styleReimagined = data.styleReimagined;
                    shaderInfo.styleUnbound = data.styleUnbound;
                }
            }
            this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined, shaderInfo.installedDir, true);
            return;
        }
        Path temp = ArchiveOperations.createTempDirectory();
        if (temp == null || shaderInfo.baseFile == null) {
            return;
        }
        this.completeShaderPatching(shaderInfo, temp);
    }

    private void initializeServices() {
        this.versionComparator = new ShaderVersionComparator(BRAND_NAME, PATCH_NAME, VERSION, shaderpacks);
        this.shaderDetector = new ShaderDetector(BRAND_NAME, PATCH_NAME, VERSION, PATCH_VERSION, COMMON_LOCATION, SHADER_MYFILE_LOCATION, shaderpacks);
        this.namingService = new ShaderNamingService(BRAND_NAME, PATCH_NAME, VERSION, PATCH_VERSION, COMMON_LOCATION, SHADER_MYFILE_LOCATION, shaderpacks, this.shaderDetector);
        this.patchingService = new ShaderPatchingService(PATCH_NAME, PATCH_VERSION, COMMON_LOCATION, shaderpacks, this.namingService);
    }

    public static EuphoriaPatcher getInstance() {
        return instance;
    }

    public ShaderVersionComparator getVersionComparator() {
        return this.versionComparator;
    }

    public ShaderDetector getShaderDetector() {
        return this.shaderDetector;
    }

    public ShaderNamingService getNamingService() {
        return this.namingService;
    }

    private boolean completeShaderPatching(ShaderDetector.ShaderInfo shaderInfo, Path temp) {
        if (!this.patchingService.processAndPatchShaders(shaderInfo, temp)) {
            return false;
        }
        UpdateShaderConfig.updateShaderTxtConfigFile(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        UpdateShaderLoaderConfig.updateShaderLoaderConfig(shaderInfo.styleUnbound, shaderInfo.styleReimagined);
        if (ConfigHandler.doDeleteOldShaderFiles) {
            ModifyOutdatedPatches.delete();
        }
        if (ConfigHandler.doRenameOldShaderFiles) {
            ModifyOutdatedPatches.rename();
        }
        ShaderData.saveShaderStyles(shaderInfo.styleReimagined, shaderInfo.styleUnbound);
        this.thankYouMessage(shaderInfo.baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined, shaderInfo.installedDir, shaderInfo.isAlreadyInstalled);
        return true;
    }

    public static void log(int messageLevel, int messageFadeTimer, String message) {
        if (loggerInstance == null) {
            System.out.println("EuphoriaPatcher (early log): " + message);
            return;
        }
        loggerInstance.log(messageLevel, messageFadeTimer, message);
    }

    public static void log(int messageLevel, String message) {
        if (loggerInstance == null) {
            System.out.println("EuphoriaPatcher (early log): " + message);
            return;
        }
        loggerInstance.log(messageLevel, message);
    }

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[EuphoriaPatcher] " + message);
    }

    public static boolean isSpacEagle() {
        try {
            boolean containsSpacEagle = shaderpacks.toString().contains("SpacEagle");
            EuphoriaPatcher.debugLog("Contains SpacEagle in Path: " + containsSpacEagle);
            Path euphoriaFolder = shaderpacks.resolve("Euphoria-Patches");
            boolean hasEuphoriaFolder = Files.exists(euphoriaFolder, new LinkOption[0]) && Files.isDirectory(euphoriaFolder, new LinkOption[0]);
            EuphoriaPatcher.debugLog("Euphoria-Patches folder exists: " + hasEuphoriaFolder);
            return containsSpacEagle && hasEuphoriaFolder;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void thankYouMessage(Path baseFile, boolean styleUnbound, boolean styleReimagined, Path installedDir, boolean isAlreadyInstalled) {
        Path shader = this.findInstalledShaderPath(baseFile, installedDir);
        if (shader != null) {
            this.applyShaderModifications(shader, styleUnbound, styleReimagined, isAlreadyInstalled);
            this.displayFinalMessage();
        } else {
            EuphoriaPatcher.debugLog("No valid shader path found for thank you message");
            EuphoriaPatcher.log(-1, "Thank you for using Euphoria Patches - SpacEagle17");
        }
    }

    private Path findInstalledShaderPath(Path baseFile, Path installedDir) {
        if (installedDir != null) {
            EuphoriaPatcher.debugLog("Using already detected installed directory: " + installedDir);
            return installedDir;
        }
        if (baseFile != null) {
            return this.namingService.getPatchedShaderPath(baseFile);
        }
        return this.shaderDetector.findPatchedShaderDirectory();
    }

    private void applyShaderModifications(Path shader, boolean styleUnbound, boolean styleReimagined, boolean isAlreadyInstalled) {
        this.applyUpdateNotification(shader, styleUnbound, styleReimagined);
        this.applyCompatibilityModifications(shader, styleUnbound, styleReimagined);
        this.applyDeveloperModifications(shader, styleUnbound, styleReimagined);
        this.namingService.createAlternativeShaderNames(shader, isAlreadyInstalled, ConfigHandler.alternativeShaderNames);
        if (ConfigHandler.autoMergeBlockProperties) {
            EuphoriaPatcher.debugLog("Auto-merge block properties is enabled, starting properties watcher");
            PropertiesWatcher.startWatcher();
        } else {
            EuphoriaPatcher.debugLog("Auto-merge block properties is disabled, not starting properties watcher");
        }
    }

    private void applyUpdateNotification(Path shader, boolean styleUnbound, boolean styleReimagined) {
        if (!UpdateChecker.shouldUserUpdate()) {
            return;
        }
        boolean isOculus = ShaderLoader.getShaderLoader().equals("oculus");
        boolean isOptifine = ShaderLoader.getShaderLoader().equals("optifine");
        String newVersionText = "value.info19.0=\u00a7c" + PATCH_VERSION.replace("_", "") + " \u00a7r->\u00a7a " + UpdateChecker.getNewModVersion();
        if (isOculus || isOptifine && !ShaderLoader.isMinecraftVersionAtLeast("1.21.1")) {
            newVersionText = "value.info19.0=\u00a7c" + PATCH_VERSION.replace("_", "") + " -> " + UpdateChecker.getNewModVersion();
        }
        try {
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "screen=<empty> <empty>", "screen=info19 info20");
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, LANG_LOCATION, ".lang", "value\\.info19\\.0=.*", newVersionText);
            String shaderDescriptionText = "\\\\u00A7cComplementary Shaders " + VERSION.replace("_", "") + "\\\\u00A7r + \\\\u00A7dEuphoria Patches " + PATCH_VERSION.replace("_", "") + "\\\\u00A7r Complementary add-on by SpacEagle17 extending it with many more unique optional features and settings.\\\\nDev versions: \\\\u00A7dwww.euphoriapatches.com/support\\\\u00A7r";
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, "shaders/pack.json", null, "\"shaderDescription\":.*", "\"shaderDescription\": \"\\\\u00A7aUPDATE AVAILABLE!\\\\u00A7r\\\\nCurrent version: \\\\u00A7c" + PATCH_VERSION.replace("_", "") + "\\\\u00A7r -> New version: \\\\u00A7a" + UpdateChecker.getNewModVersion() + "\\\\u00A7r\\\\n----------------\\\\n" + shaderDescriptionText + "\",");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Could not modify the shader to show the user that a new version is available" + e.getMessage());
        }
    }

    private void applyCompatibilityModifications(Path shader, boolean styleUnbound, boolean styleReimagined) {
        boolean isIris = ShaderLoader.getShaderLoader().equals("iris");
        boolean isOculus = ShaderLoader.getShaderLoader().equals("oculus");
        boolean isMacOS = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac");
        if (!isMacOS && (isIris || isOculus)) {
            return;
        }
        try {
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?COLORED_LIGHTING=)192(\\s+.*)", "$10  $2");
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?END_CRYSTAL_VORTEX=)3(\\s+.*)", "$10$2");
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?)\\s+DRAGON_DEATH_EFFECT=1(\\s+.*)", "$1DRAGON_DEATH_EFFECT=0$2");
            ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADERS_PROPERTIES_LOCATION, null, "(profile\\.POPULAR\\s+=\\s+.*?)\\s+END_PORTAL_BEAM(\\s+.*)", "$1 !END_PORTAL_BEAM$2");
            EuphoriaPatcher.debugLog("Applied compatibility modifications for macOS/non-iris loader: disabled COLORED_LIGHTING, END_CRYSTAL_VORTEX, DRAGON_DEATH_EFFECT, and END_PORTAL_BEAM in POPULAR profile");
        }
        catch (IOException e) {
            EuphoriaPatcher.log(3, 0, "Could not apply compatibility shader modifications: " + e.getMessage());
        }
    }

    private void applyDeveloperModifications(Path shader, boolean styleUnbound, boolean styleReimagined) {
        if (EuphoriaPatcher.isSpacEagle()) {
            try {
                ModifyPatchedShaderpacks.modifyFiles(shader, styleUnbound, styleReimagined, SHADER_MYFILE_LOCATION, null, "\\/\\/ Developed by SpacEagle17", "#define SPACEAGLE17");
            }
            catch (IOException e) {
                EuphoriaPatcher.log(3, 0, "Could not modify the shader for SpacEagle17" + e.getMessage());
            }
        }
    }

    private void displayFinalMessage() {
        if (EuphoriaPatcher.isSpacEagle()) {
            EuphoriaPatcher.log(1, "Have fun developing Euphoria Patches!\n");
        } else {
            EuphoriaPatcher.log(-1, "Thank you for using Euphoria Patches - SpacEagle17");
        }
    }

    public void startShaderpacksWatcher() {
        if (this.shaderpacksWatcher != null && this.shaderpacksWatcher.isRunning()) {
            return;
        }
        this.shaderpacksWatcher = ShaderpacksWatcher.createAndStart(this, true);
        if (this.shaderpacksWatcher != null) {
            EuphoriaPatcher.log(0, "Watching shaderpacks folder for changes...");
        }
    }

    public ShaderpacksWatcher getShaderpacksWatcher() {
        return this.shaderpacksWatcher;
    }

    private void stopShaderpacksWatcher() {
        if (this.shaderpacksWatcher != null) {
            this.shaderpacksWatcher.stopWatching();
        }
    }

    public void startWatcherAfterByteSizeFailure() {
        if (this.shaderpacksWatcher != null) {
            this.shaderpacksWatcher.resetAfterByeSizeFailure();
        } else {
            this.startShaderpacksWatcher();
        }
    }

    public synchronized boolean processNewShaderpack(Path baseFile) {
        try {
            EuphoriaPatcher.log(0, "Processing newly detected shader pack: " + baseFile.getFileName());
            ShaderDetector.ShaderInfo shaderInfo = new ShaderDetector.ShaderInfo();
            shaderInfo.baseFile = baseFile;
            String name = baseFile.getFileName().toString();
            if (this.shaderDetector.isNewerDevVersion(baseFile, shaderInfo)) {
                EuphoriaPatcher.debugLog("Accepted newer dev version: " + baseFile.getFileName());
                this.stopShaderpacksWatcher();
                this.thankYouMessage(baseFile, shaderInfo.styleUnbound, shaderInfo.styleReimagined, shaderInfo.installedDir, true);
                return true;
            }
            Path temp = ArchiveOperations.createTempDirectory();
            if (temp == null) {
                return false;
            }
            if (name.contains("Reimagined")) {
                shaderInfo.styleReimagined = true;
            } else if (name.contains("Unbound")) {
                shaderInfo.styleUnbound = true;
            } else {
                String detectedStyle = ShaderPropertyReader.detectStyleFromCommonFile(baseFile, COMMON_LOCATION);
                shaderInfo.styleReimagined = "Reimagined".equals(detectedStyle);
                shaderInfo.styleUnbound = "Unbound".equals(detectedStyle);
            }
            boolean success = this.completeShaderPatching(shaderInfo, temp);
            if (success) {
                this.stopShaderpacksWatcher();
            } else if (this.shaderpacksWatcher != null) {
                this.shaderpacksWatcher.trackInvalidByteSizeFile(baseFile.getFileName().toString());
            }
            return success;
        }
        catch (Exception e) {
            EuphoriaPatcher.log(3, "Error processing newly detected shader pack: " + e.getMessage());
            return false;
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                UpdateShaderConfig.shutdownFileWriter();
                Config.stopConfigWatcher();
                EuphoriaPatcher.instance.shaderpacksWatcher.stopWatching();
                PotatoFileMonitor.stopMonitoring();
                PropertiesWatcher.stopMonitoring();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

