/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.netherportalspread_common_forge.events.SpreadEvent;
import java.lang.invoke.MethodHandles;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeSpreadEvent {
    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeSpreadEvent.class);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent.Post e) {
        Level level = e.level();
        if (level.isClientSide()) {
            return;
        }
        SpreadEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        SpreadEvent.onWorldLoad((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onPortalSpawn(BlockEvent.PortalSpawnEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        SpreadEvent.onPortalSpawn(level, e.getPos(), e.getPortalSize());
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        SpreadEvent.onDimensionChange((ServerLevel)level, (ServerPlayer)player);
    }
}

