/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import java.util.List;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_11971;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2478;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_3902;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_8242;
import net.minecraft.class_827;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import vectorwing.farmersdelight.common.block.state.CanvasSign;

public abstract class AbstractCanvasSignRenderer
implements class_827<class_2625, class_11971> {
    private static final int OUTLINE_RENDER_DISTANCE = class_3532.method_34954((int)16);
    private final class_327 font;
    private final class_11701 materials;

    public AbstractCanvasSignRenderer(class_5614.class_5615 context) {
        this.font = context.comp_4540();
        this.materials = context.comp_4541();
    }

    protected abstract class_3879.class_9948 getSignModel(class_2680 var1);

    protected abstract class_4730 getSignMaterial(class_1767 var1);

    protected abstract float getSignModelRenderScale();

    protected abstract float getSignTextRenderScale();

    protected abstract class_243 getTextOffset();

    protected abstract void translateSign(class_4587 var1, float var2, class_2680 var3);

    public void submit(class_11971 renderState, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState) {
        class_2680 blockState = renderState.field_62674;
        class_2478 signBlock = (class_2478)blockState.method_26204();
        class_1767 dye = class_1767.field_7952;
        if (signBlock instanceof CanvasSign) {
            CanvasSign canvasSign = (CanvasSign)signBlock;
            dye = canvasSign.getBackgroundColor();
        }
        class_3879.class_9948 simple = this.getSignModel(blockState);
        this.submitSignWithText(renderState, poseStack, blockState, signBlock, dye, simple, renderState.field_62677, nodeCollector);
    }

    private void submitSignWithText(class_11971 renderState, class_4587 poseStack, class_2680 blockState, class_2478 sign, class_1767 dyeColor, class_3879.class_9948 model, @Nullable class_11683.class_11792 crumblingOverlay, class_11659 nodeCollector) {
        poseStack.method_22903();
        this.translateSign(poseStack, -sign.method_49814(blockState), blockState);
        this.submitSign(poseStack, renderState.field_62676, dyeColor, model, crumblingOverlay, nodeCollector);
        this.submitSignText(renderState, poseStack, nodeCollector, true);
        this.submitSignText(renderState, poseStack, nodeCollector, false);
        poseStack.method_22909();
    }

    protected void submitSign(class_4587 poseStack, int packedLight, class_1767 dyColor, class_3879.class_9948 model, @Nullable class_11683.class_11792 crumblingOverlay, class_11659 nodeCollector) {
        poseStack.method_22903();
        float scale = this.getSignModelRenderScale();
        poseStack.method_22905(scale, -scale, -scale);
        class_4730 material = this.getSignMaterial(dyColor);
        class_1921 renderType = material.method_24146(arg_0 -> ((class_3879.class_9948)model).method_23500(arg_0));
        nodeCollector.method_73490((class_3879)model, (Object)class_3902.field_17274, poseStack, renderType, packedLight, class_4608.field_21444, -1, this.materials.method_73030(material), 0, crumblingOverlay);
        poseStack.method_22909();
    }

    private void submitSignText(class_11971 renderState, class_4587 poseStack, class_11659 nodeCollector, boolean isFront) {
        class_8242 signText;
        class_8242 class_82422 = signText = isFront ? renderState.field_62739 : renderState.field_62740;
        if (signText != null) {
            int l;
            boolean bl;
            int k;
            poseStack.method_22903();
            this.translateSignText(poseStack, isFront, this.getTextOffset());
            int i = AbstractCanvasSignRenderer.getDarkColor(signText);
            int j = 4 * renderState.field_62741 / 2;
            class_5481[] formattedCharSequences = signText.method_49868(renderState.field_62743, component -> {
                List list = this.font.method_1728((class_5348)component, renderState.field_62742);
                return list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
            });
            if (signText.method_49856()) {
                k = signText.method_49872().method_16357();
                bl = k == class_1767.field_7963.method_16357() || renderState.field_62744;
                l = 0xF000F0;
            } else {
                k = i;
                bl = false;
                l = renderState.field_62676;
            }
            for (int m = 0; m < 4; ++m) {
                class_5481 formattedCharSequence = formattedCharSequences[m];
                float f = -this.font.method_30880(formattedCharSequence) / 2;
                nodeCollector.method_73478(poseStack, f, (float)(m * renderState.field_62741 - j), formattedCharSequence, false, class_327.class_6415.field_33995, l, k, 0, bl ? i : 0);
            }
            poseStack.method_22909();
        }
    }

    private void translateSignText(class_4587 poseStack, boolean isFront, class_243 offset) {
        if (!isFront) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
        }
        float f = 0.015625f * this.getSignTextRenderScale();
        poseStack.method_61958(offset);
        poseStack.method_22905(f, -f, f);
    }

    private static boolean isOutlineVisible(class_2338 pos) {
        class_310 minecraft = class_310.method_1551();
        class_746 localPlayer = minecraft.field_1724;
        if (localPlayer != null && minecraft.field_1690.method_31044().method_31034() && localPlayer.method_31550()) {
            return true;
        }
        class_1297 entity = minecraft.method_1560();
        return entity != null && entity.method_5707(class_243.method_24953((class_2382)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    public static int getDarkColor(class_8242 text) {
        int i = text.method_49872().method_16357();
        return i == class_1767.field_7963.method_16357() && text.method_49856() ? -988212 : class_9848.method_61321((int)i, (float)0.4f);
    }

    public class_11971 createRenderState() {
        return new class_11971();
    }

    public void extractRenderState(class_2625 blockEntity, class_11971 renderState, float partialTick, class_243 cameraPosition, @Nullable class_11683.class_11792 breakProgress) {
        super.method_74331((class_2586)blockEntity, (class_11954)renderState, partialTick, cameraPosition, breakProgress);
        renderState.field_62742 = blockEntity.method_45470();
        renderState.field_62741 = blockEntity.method_45469();
        renderState.field_62739 = blockEntity.method_49853();
        renderState.field_62740 = blockEntity.method_49854();
        renderState.field_62743 = class_310.method_1551().method_33883();
        renderState.field_62744 = AbstractCanvasSignRenderer.isOutlineVisible(blockEntity.method_11016());
    }
}

