/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.codecs.YRangeAllowance;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3542;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5434;
import net.minecraft.class_6122;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_9822;

public class MineshaftStructure
extends GenericJigsawStructure {
    public static final MapCodec<MineshaftStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MineshaftStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)YRangeAllowance.CODEC.optionalFieldOf("y_allowance").forGetter(structure -> structure.yAllowance), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.BOOL.fieldOf("cannot_spawn_in_liquid").orElse((Object)false).forGetter(structure -> structure.cannotSpawnInLiquid), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("terrain_height_radius_check").forGetter(structure -> structure.terrainHeightCheckRadius), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("allowed_terrain_height_range").forGetter(structure -> structure.allowedTerrainHeightRange), (App)Codec.intRange((int)1, (int)100).optionalFieldOf("valid_biome_radius_check").forGetter(structure -> structure.biomeRadius), (App)class_2960.field_25139.listOf().fieldOf("pools_that_ignore_boundaries").orElse(new ArrayList()).xmap(HashSet::new, ArrayList::new).forGetter(structure -> structure.poolsThatIgnoreBoundaries), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)class_3542.method_28140(GenericJigsawStructure.BURYING_TYPE::values).optionalFieldOf("burying_type").forGetter(structure -> structure.buryingType), (App)Codec.BOOL.fieldOf("use_bounding_box_hack").orElse((Object)false).forGetter(structure -> structure.useBoundingBoxHack), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, MineshaftStructure::new));

    public MineshaftStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, Optional<YRangeAllowance> yAllowance, class_6122 startHeight, Optional<class_2902.class_2903> projectStartToHeightmap, boolean cannotSpawnInLiquid, Optional<Integer> terrainHeightCheckRadius, Optional<Integer> allowedTerrainHeightRange, Optional<Integer> biomeRadius, HashSet<class_2960> poolsThatIgnoreBoundaries, Optional<Integer> maxDistanceFromCenter, Optional<GenericJigsawStructure.BURYING_TYPE> buryingType, boolean useBoundingBoxHack, class_9822 liquidSettings) {
        super(config, startPool, size, yAllowance, startHeight, projectStartToHeightmap, cannotSpawnInLiquid, terrainHeightCheckRadius, allowedTerrainHeightRange, biomeRadius, poolsThatIgnoreBoundaries, maxDistanceFromCenter, buryingType, useBoundingBoxHack, liquidSettings);
    }

    @Override
    protected void postLayoutAdjustments(class_6626 structurePiecesBuilder, class_3195.class_7149 context, int offsetY, class_2338 blockpos, int topClipOff, int bottomClipOff, List<class_3790> pieces) {
        int justBelowTerrain = MineshaftStructure.getTerrainHeight(context.comp_568().method_33943(0), context) - 15;
        int finalJustBelowTerrain = Math.max(justBelowTerrain, bottomClipOff);
        Optional<class_3790> topPiece = pieces.stream().max(Comparator.comparingInt(piece -> piece.method_14935().method_35419()));
        if (topPiece.isPresent() && finalJustBelowTerrain < topClipOff && finalJustBelowTerrain < topPiece.get().method_14935().method_35419()) {
            int topPieceMaxY = topPiece.get().method_14935().method_35419();
            pieces.forEach(piece -> GeneralUtils.movePieceProperly((class_3443)piece, 0, finalJustBelowTerrain - topPieceMaxY, 0));
        }
    }

    private static int getTerrainHeight(class_2338 centerPos, class_3195.class_7149 context) {
        int height = GeneralUtils.getCachedFreeHeight(context.comp_562(), centerPos.method_10263(), centerPos.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564()) - 1;
        class_2338 pos = new class_2338(centerPos.method_10263(), 0, centerPos.method_10260());
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, GeneralUtils.getCachedFreeHeight(context.comp_562(), mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13195, context.comp_569(), context.comp_564())) - 1;
        }
        return height;
    }

    @Override
    public class_7151<?> method_41618() {
        return RSStructures.GENERIC_MINESHAFT.get();
    }
}

