/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.misc.mobspawners.MobSpawnerManager;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6497;
import net.minecraft.class_7923;

public class SpawnerRandomizingProcessor
extends class_3491 {
    public static final MapCodec<SpawnerRandomizingProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("rs_spawner_resourcelocation").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.rsSpawnerResourcelocation), (App)class_6497.field_34390.optionalFieldOf("valid_block_light_level").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.validBlockLightLevel), (App)class_6497.field_34390.optionalFieldOf("valid_sky_light_level").forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.validSkyLightLevel), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("delay").orElse((Object)20).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.delay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_nearby_entities").orElse((Object)6).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.maxNearbyEntities), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_spawn_delay").orElse((Object)800).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.maxSpawnDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_spawn_delay").orElse((Object)200).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.minSpawnDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("required_player_range").orElse((Object)16).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.requiredPlayerRange), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("spawn_count").orElse((Object)4).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.spawnCount), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("spawn_range").orElse((Object)4).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.spawnRange), (App)class_2680.field_24734.fieldOf("spawner_replacement_block").orElse((Object)class_2246.field_10124.method_9564()).forGetter(spawnerRandomizingProcessor -> spawnerRandomizingProcessor.replacementState)).apply((Applicative)instance, instance.stable(SpawnerRandomizingProcessor::new)));
    public final class_2960 rsSpawnerResourcelocation;
    public final Optional<class_6497<Integer>> validBlockLightLevel;
    public final Optional<class_6497<Integer>> validSkyLightLevel;
    public final int delay;
    public final int maxNearbyEntities;
    public final int maxSpawnDelay;
    public final int minSpawnDelay;
    public final int requiredPlayerRange;
    public final int spawnCount;
    public final int spawnRange;
    public final class_2680 replacementState;

    private SpawnerRandomizingProcessor(class_2960 rsSpawnerResourcelocation, Optional<class_6497<Integer>> validBlockLightLevel, Optional<class_6497<Integer>> validSkyLightLevel, int delay, int maxNearbyEntities, int maxSpawnDelay, int minSpawnDelay, int requiredPlayerRange, int spawnCount, int spawnRange, class_2680 replacementState) {
        this.rsSpawnerResourcelocation = rsSpawnerResourcelocation;
        this.validBlockLightLevel = validBlockLightLevel;
        this.validSkyLightLevel = validSkyLightLevel;
        this.delay = delay;
        this.maxNearbyEntities = maxNearbyEntities;
        this.maxSpawnDelay = maxSpawnDelay;
        this.minSpawnDelay = minSpawnDelay;
        this.requiredPlayerRange = requiredPlayerRange;
        this.spawnCount = spawnCount;
        this.spawnRange = spawnRange;
        this.replacementState = replacementState;
    }

    public class_3499.class_3501 method_15110(class_4538 worldView, class_2338 pos, class_2338 blockPos, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 structurePlacementData) {
        if (structureBlockInfoWorld.comp_1342().method_26204() instanceof class_2496) {
            class_2338 worldPos = structureBlockInfoWorld.comp_1341();
            class_5819 random = structurePlacementData.method_15115(structureBlockInfoWorld.comp_1341());
            class_2487 spawnerNBT = this.SetMobSpawnerEntity(random);
            if (spawnerNBT == null) {
                return new class_3499.class_3501(worldPos, this.replacementState, null);
            }
            return new class_3499.class_3501(worldPos, structureBlockInfoWorld.comp_1342(), spawnerNBT);
        }
        return structureBlockInfoWorld;
    }

    private class_2487 SetMobSpawnerEntity(class_5819 random) {
        class_1299<?> entity = MobSpawnerManager.MOB_SPAWNER_MANAGER.getSpawnerMob(this.rsSpawnerResourcelocation, random);
        if (entity != null) {
            class_2960 entityRL = class_7923.field_41177.method_10221(entity);
            class_2487 compound = new class_2487();
            compound.method_10575("Delay", (short)this.delay);
            compound.method_10575("MinSpawnDelay", (short)this.minSpawnDelay);
            compound.method_10575("MaxSpawnDelay", (short)this.maxSpawnDelay);
            compound.method_10575("SpawnCount", (short)this.spawnCount);
            compound.method_10575("MaxNearbyEntities", (short)this.maxNearbyEntities);
            compound.method_10575("RequiredPlayerRange", (short)this.requiredPlayerRange);
            compound.method_10575("SpawnRange", (short)this.spawnRange);
            class_2487 spawnData = new class_2487();
            class_2487 spawnPotentialData = new class_2487();
            class_2487 entityData = new class_2487();
            entityData.method_10582("id", entityRL.toString());
            spawnPotentialData.method_10566("entity", (class_2520)entityData);
            if (this.validBlockLightLevel.isPresent() || this.validSkyLightLevel.isPresent()) {
                class_2487 customSpawnRule = new class_2487();
                this.validBlockLightLevel.ifPresent(blockLightLimit -> {
                    class_2487 blockLightTag = new class_2487();
                    blockLightTag.method_10569("min_inclusive", ((Integer)blockLightLimit.comp_1()).intValue());
                    blockLightTag.method_10569("max_inclusive", ((Integer)blockLightLimit.comp_2()).intValue());
                    customSpawnRule.method_10566("block_light_limit", (class_2520)blockLightTag);
                });
                this.validSkyLightLevel.ifPresent(skyLightLimit -> {
                    class_2487 skyLightTag = new class_2487();
                    skyLightTag.method_10569("min_inclusive", ((Integer)skyLightLimit.comp_1()).intValue());
                    skyLightTag.method_10569("max_exclusive", ((Integer)skyLightLimit.comp_2()).intValue());
                    customSpawnRule.method_10566("sky_light_limit", (class_2520)skyLightTag);
                });
                spawnPotentialData.method_10566("custom_spawn_rules", (class_2520)customSpawnRule);
                spawnData.method_10566("custom_spawn_rules", (class_2520)customSpawnRule);
            }
            class_2487 listEntry = new class_2487();
            listEntry.method_10566("data", (class_2520)spawnPotentialData);
            listEntry.method_10569("weight", 1);
            class_2499 listTag = new class_2499();
            listTag.add((Object)listEntry);
            compound.method_10566("SpawnPotentials", (class_2520)listTag);
            class_2487 entityEntry = new class_2487();
            entityEntry.method_10582("id", entityRL.toString());
            spawnData.method_10566("entity", (class_2520)entityEntry);
            compound.method_10566("SpawnData", (class_2520)spawnData);
            return compound;
        }
        return null;
    }

    protected class_3828<?> method_16772() {
        return RSProcessors.SPAWNER_RANDOMIZING_PROCESSOR.get();
    }
}

