/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3233;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class BottomPillarProcessor
extends class_3491 {
    private static final class_2960 EMPTY_RL = class_2960.method_60655((String)"minecraft", (String)"empty");
    public static final MapCodec<BottomPillarProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("pillar_processor_list", (Object)EMPTY_RL).forGetter(processor -> processor.processorList), (App)Codec.INT.optionalFieldOf("pillar_length", (Object)1000).forGetter(config -> config.pillarLength), (App)Codec.BOOL.optionalFieldOf("forced_placement", (Object)false).forGetter(config -> config.forcePlacement)).apply((Applicative)instance, instance.stable(BottomPillarProcessor::new)));
    public final class_2960 processorList;
    public final int pillarLength;
    public final boolean forcePlacement;

    private BottomPillarProcessor(class_2960 processorList, int pillarLength, boolean forcePlacement) {
        this.processorList = processorList;
        this.pillarLength = pillarLength;
        this.forcePlacement = forcePlacement;
    }

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 templateOffset, class_2338 worldOffset, class_3499.class_3501 structureBlockInfoLocal, class_3499.class_3501 structureBlockInfoWorld, class_3492 structurePlacementData) {
        class_2680 blockState = structureBlockInfoWorld.comp_1342();
        if (structureBlockInfoLocal.comp_1341().method_10264() == 0) {
            class_3233 worldGenRegion;
            class_2338 worldPos = structureBlockInfoWorld.comp_1341();
            class_2680 replacementState = blockState;
            class_2680 originalReplacementState = blockState;
            class_2338.class_2339 currentPos = new class_2338.class_2339().method_10101((class_2382)worldPos);
            Optional structureProcessorList = Optional.empty();
            if (this.processorList != null && !this.processorList.equals((Object)EMPTY_RL)) {
                structureProcessorList = levelReader.method_30349().method_30530(class_7924.field_41247).method_10223(this.processorList);
            }
            if (levelReader instanceof class_3233 && !(worldGenRegion = (class_3233)levelReader).method_33561().equals((Object)new class_1923((class_2338)currentPos))) {
                return structureBlockInfoWorld;
            }
            int terrainY = Integer.MIN_VALUE;
            if (!this.forcePlacement && (terrainY = GeneralUtils.getFirstLandYFromPos(levelReader, worldPos)) <= levelReader.method_31607() && this.pillarLength + 2 >= worldPos.method_10264() - levelReader.method_31607()) {
                return structureBlockInfoWorld;
            }
            class_2791 chunkAccess = levelReader.method_22350(worldPos);
            currentPos.method_10098(class_2350.field_11033);
            class_2680 currentBlock = chunkAccess.method_8320((class_2338)currentPos);
            boolean currentLayer = this.isSpotValidForReplacement(levelReader, currentBlock, currentPos, terrainY, worldPos);
            currentPos.method_10098(class_2350.field_11033);
            class_2680 secondBottomBlock = chunkAccess.method_8320((class_2338)currentPos);
            boolean skipInitialLayer = this.isSpotValidForReplacement(levelReader, secondBottomBlock, currentPos, terrainY, worldPos);
            currentPos.method_10098(class_2350.field_11036);
            while (skipInitialLayer || currentLayer) {
                skipInitialLayer = false;
                class_3499.class_3501 newPillarState1 = new class_3499.class_3501(currentPos.method_10059((class_2382)worldPos).method_10081((class_2382)templateOffset), replacementState, null);
                class_3499.class_3501 newPillarState2 = new class_3499.class_3501(currentPos.method_10062(), replacementState, null);
                if (structureProcessorList.isPresent()) {
                    for (class_3491 processor : ((class_5497)((class_6880.class_6883)structureProcessorList.get()).comp_349()).method_31027()) {
                        if (newPillarState2 == null) break;
                        newPillarState2 = processor.method_15110(levelReader, newPillarState1.comp_1341(), newPillarState2.comp_1341(), newPillarState1, newPillarState2, structurePlacementData);
                    }
                }
                if (newPillarState2 != null) {
                    chunkAccess.method_12010((class_2338)currentPos, newPillarState2.comp_1342(), 2);
                }
                currentPos.method_10098(class_2350.field_11033);
                currentBlock = chunkAccess.method_8320((class_2338)currentPos);
                currentLayer = this.isSpotValidForReplacement(levelReader, currentBlock, currentPos, terrainY, worldPos);
            }
        }
        return structureBlockInfoWorld;
    }

    private boolean isSpotValidForReplacement(class_4538 levelReader, class_2680 currentBlock, class_2338.class_2339 currentPos, int terrainY, class_2338 worldPos) {
        return (this.forcePlacement && currentBlock.method_26204().method_36555() >= 0.0f || !currentBlock.method_26225()) && !levelReader.method_31601(currentPos.method_10264()) && currentPos.method_19771((class_2382)worldPos, (double)this.pillarLength);
    }

    protected class_3828<?> method_16772() {
        return RSProcessors.BOTTOM_PILLAR_PROCESSOR.get();
    }
}

