/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;

public class BoxOctree {
    private static final int subdivideThreshold = 10;
    private static final int maximumDepth = 3;
    private final class_238 boundary;
    private final class_2382 size;
    private final int depth;
    private final List<class_238> innerBoxes = new ArrayList<class_238>();
    private final List<BoxOctree> childrenOctants = new ArrayList<BoxOctree>();

    public BoxOctree(class_238 axisAlignedBB) {
        this(axisAlignedBB, 0);
    }

    private BoxOctree(class_238 axisAlignedBB, int parentDepth) {
        this.boundary = axisAlignedBB.method_989(0.0, 0.0, 0.0);
        this.size = new class_2382(this.roundAwayFromZero(this.boundary.method_17939()), this.roundAwayFromZero(this.boundary.method_17940()), this.roundAwayFromZero(this.boundary.method_17941()));
        this.depth = parentDepth + 1;
    }

    private int roundAwayFromZero(double value) {
        return value >= 0.0 ? (int)Math.ceil(value) : (int)Math.floor(value);
    }

    private void subdivide() {
        if (!this.childrenOctants.isEmpty()) {
            throw new UnsupportedOperationException("repurposed_structures - Tried to subdivide when there are already children octants.");
        }
        int halfXSize = this.size.method_10263() / 2;
        int halfYSize = this.size.method_10264() / 2;
        int halfZSize = this.size.method_10260() / 2;
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323, this.boundary.field_1322, this.boundary.field_1321, this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1321 + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323, this.boundary.field_1322, this.boundary.field_1321 + (double)halfZSize, this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1324), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1322, this.boundary.field_1321, this.boundary.field_1320, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1321 + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1322, this.boundary.field_1321 + (double)halfZSize, this.boundary.field_1320, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1324), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1321, this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1325, this.boundary.field_1321 + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1321 + (double)halfZSize, this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1325, this.boundary.field_1324), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1321, this.boundary.field_1320, this.boundary.field_1325, this.boundary.field_1321 + (double)halfZSize), this.depth));
        this.childrenOctants.add(new BoxOctree(new class_238(this.boundary.field_1323 + (double)halfXSize, this.boundary.field_1322 + (double)halfYSize, this.boundary.field_1321 + (double)halfZSize, this.boundary.field_1320, this.boundary.field_1325, this.boundary.field_1324), this.depth));
        for (class_238 parentInnerBox : this.innerBoxes) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryIntersects(parentInnerBox)) continue;
                octree.addBox(parentInnerBox);
            }
        }
        this.innerBoxes.clear();
    }

    public void addBox(class_238 axisAlignedBB) {
        if (this.depth < 3 && this.innerBoxes.size() > 10) {
            this.subdivide();
        }
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryIntersects(axisAlignedBB)) continue;
                octree.addBox(axisAlignedBB);
            }
        } else {
            for (class_238 parentInnerBox : this.innerBoxes) {
                if (!parentInnerBox.equals((Object)axisAlignedBB)) continue;
                return;
            }
            this.innerBoxes.add(axisAlignedBB);
        }
    }

    public boolean boundaryEntirelyContains(class_238 axisAlignedBB) {
        return this.boundary.method_1008(axisAlignedBB.field_1323, axisAlignedBB.field_1322, axisAlignedBB.field_1321) && this.boundary.method_1008(axisAlignedBB.field_1320, axisAlignedBB.field_1325, axisAlignedBB.field_1324);
    }

    public boolean boundaryIntersects(class_238 axisAlignedBB) {
        return this.boundary.method_994(axisAlignedBB);
    }

    public boolean withinBoundsButNotIntersectingChildren(class_238 axisAlignedBB) {
        return this.boundaryEntirelyContains(axisAlignedBB) && !this.intersectsAnyBox(axisAlignedBB);
    }

    public boolean intersectsAnyBox(class_238 axisAlignedBB) {
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryIntersects(axisAlignedBB) || !octree.intersectsAnyBox(axisAlignedBB)) continue;
                return true;
            }
        } else {
            for (class_238 innerBox : this.innerBoxes) {
                if (!innerBox.method_994(axisAlignedBB)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean boundaryContains(class_2338 position) {
        return this.boundary.method_1008((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260());
    }

    public boolean withinAnyBox(class_2338 position) {
        if (!this.childrenOctants.isEmpty()) {
            for (BoxOctree octree : this.childrenOctants) {
                if (!octree.boundaryContains(position) || !octree.withinAnyBox(position)) continue;
                return true;
            }
        } else {
            for (class_238 innerBox : this.innerBoxes) {
                if (!innerBox.method_1008((double)position.method_10263(), (double)position.method_10264(), (double)position.method_10260())) continue;
                return true;
            }
        }
        return false;
    }
}

