/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.pooladditions;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.events.lifecycle.ServerGoingToStartEvent;
import com.telepathicgrunt.repurposedstructures.mixins.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.modinit.RSConditionsRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7924;

public final class PoolAdditionMergerManager
extends class_4309<JsonElement> {
    public static final PoolAdditionMergerManager POOL_ADDITIONS_MERGER_MANAGER = new PoolAdditionMergerManager();
    private static Map<class_2960, JsonElement> cachedMap = null;

    public PoolAdditionMergerManager() {
        super(class_5699.field_40721, class_7654.method_45114((String)"rs_pool_additions"));
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        cachedMap = loader;
    }

    public static void mergeAdditionPools(ServerGoingToStartEvent event) {
        if (cachedMap != null) {
            PoolAdditionMergerManager.parsePoolsAndBeginMerger(cachedMap, event.getServer().method_30611(), event.getServer().method_34864());
            cachedMap = null;
        }
    }

    private static void parsePoolsAndBeginMerger(Map<class_2960, JsonElement> poolAdditionJSON, class_5455.class_6890 frozen, class_3300 manager) {
        class_2378 poolRegistry = frozen.method_30530(class_7924.field_41249);
        class_6903 customRegistryOps = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)frozen);
        for (Map.Entry<class_2960, JsonElement> entry : poolAdditionJSON.entrySet()) {
            class_2960 targetPool = class_2960.method_60654((String)entry.getValue().getAsJsonObject().get("target_pool").getAsString());
            if (poolRegistry.method_10223(targetPool) == null) continue;
            try {
                AdditionalStructureTemplatePool.DIRECT_CODEC.parse((DynamicOps)customRegistryOps, (Object)entry.getValue()).resultOrPartial(messageString -> PoolAdditionMergerManager.logBadData((class_2960)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMergerManager.mergeIntoExistingPool(validPool, poolRegistry.method_10223(targetPool), manager));
            }
            catch (Exception e) {
                RepurposedStructures.LOGGER.error("\nRepurposed Structures: Pool Addition json failed to be parsed.\nThis is usually due to using a mod compat datapack without the other mod being on.\nFile failed to be resolved: %s\nTarget pool: %s\nRegistry being used: %s\nError message is: %s".formatted(entry.getKey(), targetPool, poolRegistry, e.getMessage()).indent(1));
            }
        }
    }

    private static void mergeIntoExistingPool(AdditionalStructureTemplatePool feedingPool, Optional<class_6880.class_6883<class_3785>> gluttonyPoolOptional, class_3300 manager) {
        if (gluttonyPoolOptional.isEmpty() || ((class_3785)gluttonyPoolOptional.get().comp_349()).method_16632() == 0) {
            return;
        }
        class_3785 gluttonyPool = (class_3785)gluttonyPoolOptional.get().comp_349();
        ObjectArrayList elements = new ObjectArrayList(((StructurePoolAccessor)gluttonyPool).repurposedstructures$getTemplates());
        ArrayList<Pair<class_3784, Integer>> elementCounts = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)gluttonyPool).repurposedstructures$getRawTemplates());
        elements.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures$getTemplates());
        elementCounts.addAll(((StructurePoolAccessor)((Object)feedingPool)).repurposedstructures$getRawTemplates());
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures$setTemplates((ObjectArrayList<class_3784>)elements);
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures$setRawTemplates(elementCounts);
    }

    private static void logBadData(class_2960 poolPath, String messageString) {
        RepurposedStructures.LOGGER.error("(Repurposed Structures POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }

    private static class AdditionalStructureTemplatePool
    extends class_3785 {
        private static final Codec<ExpandedPoolEntry> EXPANDED_POOL_ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3784.field_24953.fieldOf("element").forGetter(ExpandedPoolEntry::poolElement), (App)Codec.intRange((int)1, (int)5000).fieldOf("weight").forGetter(ExpandedPoolEntry::weight), (App)class_2960.field_25139.optionalFieldOf("condition").forGetter(ExpandedPoolEntry::condition)).apply((Applicative)instance, ExpandedPoolEntry::new));
        public static final Codec<AdditionalStructureTemplatePool> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("target_pool").forGetter(structureTemplatePool -> structureTemplatePool.targetPool), (App)Codec.lazyInitialized(() -> StructurePoolAccessor.repurposedstructures$getCODEC_REFERENCE().getValue()).fieldOf("fallback").forGetter(class_3785::method_46736), (App)EXPANDED_POOL_ENTRY_CODEC.listOf().fieldOf("elements").forGetter(structureTemplatePool -> structureTemplatePool.rawTemplatesWithConditions)).apply((Applicative)instance, AdditionalStructureTemplatePool::new));
        protected final List<ExpandedPoolEntry> rawTemplatesWithConditions;
        protected final class_2960 targetPool;

        public AdditionalStructureTemplatePool(class_2960 targetPool, class_6880<class_3785> fallback, List<ExpandedPoolEntry> rawTemplatesWithConditions) {
            super(fallback, rawTemplatesWithConditions.stream().filter(triple -> {
                if (triple.condition().isPresent()) {
                    Supplier<Boolean> supplier = RSConditionsRegistry.RS_JSON_CONDITIONS_REGISTRY.lookup().get(triple.condition.get());
                    if (supplier != null) {
                        return supplier.get();
                    }
                    RepurposedStructures.LOGGER.error("Repurposed Structures Error: Found {} entry has a condition that does not exist. Extra info: {}", (Object)targetPool, (Object)fallback);
                }
                return true;
            }).map(triple -> Pair.of((Object)triple.poolElement(), (Object)triple.weight())).collect(Collectors.toList()));
            this.rawTemplatesWithConditions = rawTemplatesWithConditions;
            this.targetPool = targetPool;
        }

        public record ExpandedPoolEntry(class_3784 poolElement, Integer weight, Optional<class_2960> condition) {
        }
    }
}

