/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabricservertools.htm.lock;

import com.github.fabricservertools.htm.api.FlagType;
import com.github.fabricservertools.htm.config.SingleBlockSelector;
import com.github.fabricservertools.htm.lock.FlagSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public record BlockFlagSet(Map<SingleBlockSelector, FlagSet> overrides, FlagSet fallback, BlockFlagPredicate flagPredicate) {
    private static final Codec<Map<SingleBlockSelector, FlagSet>> OVERRIDES_CODEC = Codec.unboundedMap(SingleBlockSelector.CODEC, FlagSet.CONFIG_CODEC);
    public static final Codec<BlockFlagSet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OVERRIDES_CODEC.fieldOf("overrides").forGetter(BlockFlagSet::overrides), (App)FlagSet.CONFIG_CODEC.fieldOf("default").forGetter(BlockFlagSet::fallback)).apply((Applicative)instance, BlockFlagSet::new));
    public static final Codec<BlockFlagSet> SAFE_CODEC = Codec.withAlternative(CODEC, FlagSet.CONFIG_CODEC, fallback -> new BlockFlagSet(Map.of(), (FlagSet)fallback));
    public static final BlockFlagSet DEFAULT = new BlockFlagSet(Map.of(), FlagSet.DEFAULT_FLAGS);

    public BlockFlagSet(Map<SingleBlockSelector, FlagSet> overrides, FlagSet fallback) {
        this(Map.copyOf(overrides), fallback.expand(), BlockFlagSet.createFlagPredicate(overrides, fallback));
    }

    public boolean get(FlagType flag, class_2680 state) {
        return this.flagPredicate.test(flag, (class_6880<class_2248>)class_7923.field_41175.method_47983((Object)state.method_26204()));
    }

    private static BlockFlagPredicate createFlagPredicate(Map<SingleBlockSelector, FlagSet> overrides, FlagSet fallback) {
        Iterator<Map.Entry<SingleBlockSelector, FlagSet>> overridesIterator = overrides.entrySet().iterator();
        BlockFlagPredicate builder = new BlockFlagPredicate((flag, block) -> fallback.getNoFallback((FlagType)((Object)flag)));
        while (overridesIterator.hasNext()) {
            builder = new BlockFlagPredicate(overridesIterator.next(), builder);
        }
        return builder;
    }

    private record BlockFlagPredicate(BiFunction<FlagType, class_6880<class_2248>, Boolean> predicate, BlockFlagPredicate fallback) implements BiPredicate<FlagType, class_6880<class_2248>>
    {
        private BlockFlagPredicate(Map.Entry<SingleBlockSelector, FlagSet> entry, BlockFlagPredicate fallback) {
            this((FlagType flag, class_6880<class_2248> block) -> {
                if (((SingleBlockSelector)entry.getKey()).is((class_6880<class_2248>)block)) {
                    return ((FlagSet)entry.getValue()).getNoFallback((FlagType)((Object)flag));
                }
                return null;
            }, fallback);
        }

        private BlockFlagPredicate(BiPredicate<FlagType, class_6880<class_2248>> fallback) {
            this(fallback::test, null);
        }

        @Override
        public boolean test(FlagType flag, class_6880<class_2248> block) {
            Boolean override = this.predicate.apply(flag, block);
            if (override != null) {
                return override;
            }
            return this.fallback.test(flag, block);
        }
    }
}

