/*
 * Decompiled with CFR 0.152.
 */
package com.github.fabricservertools.htm.listeners;

import com.github.fabricservertools.htm.HTM;
import com.github.fabricservertools.htm.HTMTexts;
import com.github.fabricservertools.htm.Utility;
import com.github.fabricservertools.htm.api.LockableObject;
import com.github.fabricservertools.htm.config.HTMConfig;
import com.github.fabricservertools.htm.events.PlayerPlaceBlockCallback;
import com.github.fabricservertools.htm.interactions.InteractionManager;
import com.github.fabricservertools.htm.lock.HTMContainerLock;
import com.github.fabricservertools.htm.lock.type.PrivateLock;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerEventListener {
    public static void init() {
        PlayerPlaceBlockCallback.EVENT.register(PlayerEventListener::onPlace);
        PlayerBlockBreakEvents.BEFORE.register(PlayerEventListener::onBeforeBreak);
        AttackBlockCallback.EVENT.register(PlayerEventListener::onAttackBlock);
    }

    private static class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 pos, class_2350 direction) {
        class_3222 serverPlayer;
        if (player instanceof class_3222 && InteractionManager.pendingActions.containsKey((Object)(serverPlayer = (class_3222)player))) {
            InteractionManager.execute(serverPlayer.method_51469().method_8503(), serverPlayer, pos);
            world.method_8452(pos, world.method_8320(pos).method_26204(), null);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static boolean onBeforeBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        if (world.method_8608()) {
            return true;
        }
        class_3222 playerEntity = (class_3222)player;
        if (blockEntity instanceof LockableObject) {
            Optional<HTMContainerLock> lock = InteractionManager.getLock(playerEntity, pos);
            if (lock.isEmpty()) {
                return true;
            }
            if (lock.get().isOwner(playerEntity) || HTMConfig.get().canTrustedPlayersBreakChests() && lock.get().canOpen(playerEntity)) {
                Optional<LockableObject> unlocked;
                if (state.method_26204() instanceof class_2281 && (unlocked = InteractionManager.getUnlockedLockable((class_3218)world, pos, blockEntity)).isPresent()) {
                    unlocked.get().setLock(lock.get());
                    return true;
                }
                Utility.sendMessage((class_1657)playerEntity, HTMTexts.CONTAINER_UNLOCKED);
                return true;
            }
            Utility.sendMessage((class_1657)playerEntity, HTMTexts.NOT_OWNER);
            return false;
        }
        return true;
    }

    private static class_1269 onPlace(class_1657 playerEntity, class_1750 context) {
        try {
            class_2338 pos = context.method_8037();
            class_1937 world = context.method_8045();
            class_2680 state = world.method_8320(pos);
            if (world.method_8608() || !state.method_31709()) {
                return class_1269.field_5811;
            }
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof LockableObject && HTMConfig.get().isAutoLocking(state)) {
                if (InteractionManager.getLock((class_3218)world, pos, blockEntity).isPresent()) {
                    return class_1269.field_5811;
                }
                ((LockableObject)blockEntity).setLock(new HTMContainerLock(PrivateLock.INSTANCE, (class_3222)playerEntity));
                Utility.sendMessage(playerEntity, (class_2561)HTMTexts.CONTAINER_SET.apply(PrivateLock.INSTANCE.displayName()));
            }
        }
        catch (Exception e) {
            HTM.LOGGER.warn("Something went wrong auto locking", (Throwable)e);
        }
        return class_1269.field_5811;
    }
}

