/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.backupmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.mcjunky33.backupmod.backup.BackupManager;
import de.mcjunky33.backupmod.backup.BackupRenameManager;
import de.mcjunky33.backupmod.backup.BackupScheduler;
import de.mcjunky33.backupmod.backup.BackupUploadManager;
import de.mcjunky33.backupmod.backup.RestoreManager;
import de.mcjunky33.backupmod.config.BackupConfig;
import de.mcjunky33.backupmod.lang.LangManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class BackupCommand {
    private static final SuggestionProvider<class_2168> SUGGESTION_AUTO = (ctx, builder) -> {
        builder.suggest("Enter a number between 1 and 40");
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> SUGGESTION_MAX = (ctx, builder) -> {
        builder.suggest("Enter a number between 1 and 100");
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> SUGGESTION_ROOT_FILES = (ctx, builder) -> {
        for (String entry : BackupCommand.getRootEntries(".")) {
            builder.suggest(entry);
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> SUGGESTION_EXCLUDES = (ctx, builder) -> {
        for (String entry : BackupConfig.excludePaths) {
            if (entry.startsWith("/")) {
                builder.suggest(entry.substring(1));
                continue;
            }
            builder.suggest(entry);
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<class_2168> SUGGESTION_ZIPS = (ctx, builder) -> {
        for (String zip : BackupCommand.getBackupZipFiles()) {
            builder.suggest(zip);
        }
        return builder.buildFuture();
    };

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"backup").requires(source -> BackupCommand.hasPerm(source))).then(class_2170.method_9247((String)"help").executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.help", new Object[0])), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.started", new Object[0])), false);
            String backupFile = BackupManager.createBackup(((class_2168)ctx.getSource()).method_9211());
            if (backupFile != null) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.completed", backupFile)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.failed", new Object[0])), false);
            return 0;
        })).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String customName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.started", new Object[0])), false);
            String backupFile = BackupManager.createBackup(((class_2168)ctx.getSource()).method_9211(), customName);
            if (backupFile != null) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.completed", backupFile)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.failed", new Object[0])), false);
            return 0;
        })))).then(class_2170.method_9247((String)"upload").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"url", (ArgumentType)StringArgumentType.greedyString()).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String url = StringArgumentType.getString((CommandContext)ctx, (String)"url");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            try {
                String resultName = BackupUploadManager.uploadBackupFromUrl(url, name);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.upload_success", resultName)), false);
                return 1;
            }
            catch (Exception e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.upload_failed", e.getMessage())));
                return 0;
            }
        }))).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String url = StringArgumentType.getString((CommandContext)ctx, (String)"url");
            try {
                String resultName = BackupUploadManager.uploadBackupFromUrl(url, "");
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.upload_success", resultName)), false);
                return 1;
            }
            catch (Exception e) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.upload_failed", e.getMessage())));
                return 0;
            }
        })))).then(class_2170.method_9247((String)"rename").then(class_2170.method_9244((String)"zipfile", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_ZIPS).then(class_2170.method_9244((String)"newname", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String zipName = StringArgumentType.getString((CommandContext)ctx, (String)"zipfile");
            String newName = StringArgumentType.getString((CommandContext)ctx, (String)"newname");
            File zipFile = new File("backups", zipName);
            if (!zipFile.exists() || !zipFile.isFile()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.rename_not_found", zipName)));
                return 0;
            }
            if (!BackupRenameManager.isRenameAllowed(zipFile)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.rename_not_allowed", zipName)));
                return 0;
            }
            String renamed = BackupRenameManager.renameBackupZip(zipFile, newName);
            if (!renamed.equals(zipName)) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.rename_success", renamed)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.rename_failed", zipName)));
            return 0;
        }))))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            List<String> backups = BackupManager.listBackups();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.backup_list", new Object[0])), false);
            backups.forEach(name -> ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)name), false));
            return 1;
        }))).then(class_2170.method_9247((String)"lang").then(class_2170.method_9244((String)"lang_lang", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String lang;
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.lang = lang = StringArgumentType.getString((CommandContext)ctx, (String)"lang_lang");
            BackupConfig.saveConfig();
            LangManager.load();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.lang_changed", lang)), false);
            return 1;
        })))).then(class_2170.method_9247((String)"restore").then(class_2170.method_9244((String)"backupzip", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_ZIPS).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String zip = StringArgumentType.getString((CommandContext)ctx, (String)"backupzip");
            File file = new File("backups", zip);
            if (!file.exists() || !file.isFile()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.restore.noexist", zip)));
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().forEach(player -> player.field_13987.method_52396((class_2561)class_2561.method_43470((String)LangManager.tr("backup.player_kicked", new Object[0]))));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.restoring", zip)), false);
            boolean success = RestoreManager.restoreBackup(zip, ((class_2168)ctx.getSource()).method_9211());
            if (success) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.restored", zip)), false);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.stopping", new Object[0])), false);
                ((class_2168)ctx.getSource()).method_9211().method_3747(false);
            }
            return success ? 1 : 0;
        })))).then(class_2170.method_9247((String)"restorelatest").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String backupName = BackupManager.getLatestBackup();
            if (backupName == null) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.no_backup_found", new Object[0])), false);
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571().forEach(player -> player.field_13987.method_52396((class_2561)class_2561.method_43470((String)LangManager.tr("backup.player_kicked", new Object[0]))));
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.restoring", backupName)), false);
            boolean success = RestoreManager.restoreBackup(backupName, ((class_2168)ctx.getSource()).method_9211());
            if (success) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.restored", backupName)), false);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.stopping", new Object[0])), false);
                ((class_2168)ctx.getSource()).method_9211().method_3747(false);
            }
            return success ? 1 : 0;
        }))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"backupzip", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_ZIPS).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String zipName = StringArgumentType.getString((CommandContext)ctx, (String)"backupzip");
            File zipFile = new File("backups", zipName);
            if (zipFile.exists() && zipFile.isFile()) {
                if (zipFile.delete()) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.delete_success", zipName)), false);
                    return 1;
                }
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.delete_failed", zipName)));
                return 0;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.delete_not_found", zipName)));
            return 0;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autobackup").then(class_2170.method_9247((String)"off").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.autoBackupEnabled = 0;
            BackupConfig.autoBackupTimes = 0;
            BackupConfig.saveConfig();
            BackupScheduler.resetSchedule();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.autobackup_disabled", new Object[0])), false);
            return 1;
        }))).then(class_2170.method_9247((String)"request").executes(ctx -> {
            String msg = BackupCommand.getNextAutoBackupString();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)msg), false);
            return 1;
        }))).then(class_2170.method_9244((String)"times", (ArgumentType)IntegerArgumentType.integer((int)1, (int)40)).suggests(SUGGESTION_AUTO).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            int times = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"times");
            if (times < 1 || times > 40) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Please enter a number between 1 and 40."));
                return 0;
            }
            BackupScheduler.setAutoBackupTimes(times);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.autobackup_enabled", String.valueOf(times))), false);
            String timerString = BackupScheduler.getNextScheduledBackupTimerString();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.autobackup_timer", timerString)).method_27692(class_124.field_1075), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"maxbackup").then(class_2170.method_9247((String)"off").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.maxBackups = Integer.MAX_VALUE;
            BackupConfig.saveConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.maxbackup_off", new Object[0])), false);
            return 1;
        }))).then(class_2170.method_9247((String)"request").executes(ctx -> {
            String msg = BackupCommand.getMaxBackupStatus();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)msg), false);
            return 1;
        }))).then(class_2170.method_9244((String)"max", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).suggests(SUGGESTION_MAX).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            int max = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"max");
            if (max < 1 || max > 100) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Please enter a number between 1 and 100."));
                return 0;
            }
            BackupConfig.maxBackups = max;
            BackupConfig.saveConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.maxbackup_set", String.valueOf(max))), false);
            return 1;
        })))).then(class_2170.method_9247((String)"exclude").then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_ROOT_FILES).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String path = StringArgumentType.getString((CommandContext)ctx, (String)"path");
            if (path.contains("/")) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.exclude_notfolder", new Object[0])));
                return 0;
            }
            String configPath = "/" + path;
            if (!BackupConfig.excludePaths.contains(configPath)) {
                BackupConfig.excludePaths.add(configPath);
                BackupConfig.saveConfig();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.exclude_success", configPath)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.exclude_already", new Object[0])));
            return 0;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"enclude").then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_EXCLUDES).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String path = StringArgumentType.getString((CommandContext)ctx, (String)"path");
            String configPath = "/" + path.replaceFirst("^/", "");
            if (BackupConfig.excludePaths.remove(configPath)) {
                BackupConfig.saveConfig();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.enclude_success", configPath)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.exclude_notfound", new Object[0])));
            return 0;
        }))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.exclude_list", new Object[0])), false);
            for (String entry : BackupConfig.excludePaths) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)entry), false);
            }
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permissions").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            class_3222 player = BackupCommand.getPlayerByName((class_2168)ctx.getSource(), name);
            if (player != null) {
                BackupConfig.addPermUser(player.method_5667().toString(), name);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.permissions_added", name)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.permissions_not_found", new Object[0])));
            return 0;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            class_3222 player = BackupCommand.getPlayerByName((class_2168)ctx.getSource(), name);
            if (player != null) {
                BackupConfig.removePermUser(player.method_5667().toString(), name);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.permissions_removed", name)), false);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("backup.permissions_not_found", new Object[0])));
            return 0;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            StringBuilder sb = new StringBuilder();
            for (BackupConfig.PermUser u : BackupConfig.permissionUsers) {
                sb.append(u.name).append(" (").append(u.uuid).append("), ");
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.permissions_list", sb.toString())), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"log").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"normallog").then(class_2170.method_9247((String)"on").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.normallogEnabled = true;
            BackupConfig.saveConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.log_normallog_on", new Object[0])), false);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.normallogEnabled = false;
            BackupConfig.saveConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.log_normallog_off", new Object[0])), false);
            return 1;
        })))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"permlog").then(class_2170.method_9247((String)"on").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.permlogEnabled = true;
            BackupConfig.saveConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.log_permlog_on", new Object[0])), false);
            return 1;
        }))).then(class_2170.method_9247((String)"off").executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            BackupConfig.permlogEnabled = false;
            BackupConfig.saveConfig();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.log_permlog_off", new Object[0])), false);
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").requires(source -> source.method_9259(4) || BackupCommand.hasPerm(source))).then(class_2170.method_9247((String)"set.timer.value").then(class_2170.method_9244((String)"hours", (ArgumentType)IntegerArgumentType.integer((int)0, (int)23)).then(class_2170.method_9244((String)"minutes", (ArgumentType)IntegerArgumentType.integer((int)0, (int)59)).then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0, (int)59)).executes(ctx -> {
            int h = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"hours");
            int m = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"minutes");
            int s = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"seconds");
            BackupScheduler.setDebugTimer(h, m, s, ((class_2168)ctx.getSource()).method_9211());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[BackupMod] Debug-Timer set to: %02d:%02d:%02d".formatted(h, m, s)), false);
            String timerString = BackupScheduler.getNextScheduledBackupTimerString();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.autobackup_timer", timerString)).method_27692(class_124.field_1075), false);
            return 1;
        })))))).then(class_2170.method_9247((String)"set.autobackup.value").then(class_2170.method_9244((String)"times", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1440)).executes(ctx -> {
            if (!BackupCommand.hasPerm((class_2168)ctx.getSource())) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)LangManager.tr("error.permission", new Object[0])));
                return 0;
            }
            int times = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"times");
            if (times < 1 || times > 1440) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Please enter a number between 1 and 80."));
                return 0;
            }
            BackupScheduler.setAutoBackupTimes(times);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("[BackupMod] Debug-AutoBackup value set to: " + times)), false);
            String timerString = BackupScheduler.getNextScheduledBackupTimerString();
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)LangManager.tr("backup.autobackup_timer", timerString)).method_27692(class_124.field_1076), false);
            return 1;
        })))).then(class_2170.method_9247((String)"create.schedulebackup").executes(ctx -> {
            boolean ok = BackupScheduler.runScheduledBackup(((class_2168)ctx.getSource()).method_9211());
            if (ok) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[BackupMod] Scheduled backup executed!"), false);
            } else {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[BackupMod] Scheduled backup failed!"));
            }
            return ok ? 1 : 0;
        }))).then(class_2170.method_9247((String)"create.schedulebackup.name").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            boolean ok = BackupScheduler.runScheduledBackup(((class_2168)ctx.getSource()).method_9211());
            String customName = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            if (ok) {
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"[BackupMod] Scheduled backup executed as 'autobackup'! (Custom name ignored)"), false);
            } else {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[BackupMod] Scheduled backup failed!"));
            }
            return ok ? 1 : 0;
        }))))));
    }

    private static List<String> getRootEntries(String rootPath) {
        File root = new File(rootPath);
        File[] files = root.listFiles();
        ArrayList<String> result = new ArrayList<String>();
        if (files != null) {
            for (File f : files) {
                if (!f.getParentFile().equals(root) || f.getName().equalsIgnoreCase("backups")) continue;
                result.add(f.getName());
            }
        }
        return result;
    }

    private static List<String> getBackupZipFiles() {
        File dir = new File("backups");
        File[] files = dir.listFiles((d, name) -> name.toLowerCase().endsWith(".zip"));
        ArrayList<String> result = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                result.add(file.getName());
            }
        }
        return result;
    }

    public static String getNextAutoBackupString() {
        if (BackupConfig.autoBackupEnabled != 1 || BackupConfig.autoBackupTimes < 1) {
            return LangManager.tr("backup.autobackup_disabled", new Object[0]);
        }
        int times = BackupConfig.autoBackupTimes;
        String timerString = BackupScheduler.getNextScheduledBackupTimerString();
        return LangManager.tr("backup.autobackup_status", String.valueOf(times), timerString);
    }

    public static String getMaxBackupStatus() {
        if (BackupConfig.maxBackups >= Integer.MAX_VALUE) {
            return LangManager.tr("backup.maxbackup_not_set", new Object[0]);
        }
        return LangManager.tr("backup.maxbackup_current", String.valueOf(BackupConfig.maxBackups));
    }

    private static boolean hasPerm(class_2168 source) {
        if (source.method_9259(4)) {
            return true;
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return BackupConfig.hasBackupPerm(player.method_5667().toString(), player.method_5477().getString());
        }
        return false;
    }

    private static class_3222 getPlayerByName(class_2168 source, String name) {
        for (class_3222 sp : source.method_9211().method_3760().method_14571()) {
            if (!sp.method_5477().getString().equalsIgnoreCase(name)) continue;
            return sp;
        }
        return null;
    }
}

