/*
 * Decompiled with CFR 0.152.
 */
package de.mcjunky33.backupmod.backup;

import de.mcjunky33.backupmod.BackupMod;
import de.mcjunky33.backupmod.config.BackupConfig;
import de.mcjunky33.backupmod.lang.LangManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class RestoreManager {
    private static final String CONFIG_FILE_PATH = BackupConfig.CONFIG_FILE.replace("\\", "/");
    private static volatile boolean backupRunning = false;

    public static void setBackupRunning(boolean running) {
        backupRunning = running;
    }

    public static boolean isBackupRunning() {
        return backupRunning;
    }

    public static boolean restoreBackup(String backupFileName, MinecraftServer server) {
        BufferedWriter logWriter;
        File backupFile = new File("backups/" + backupFileName);
        if (!backupFile.exists()) {
            for (class_3222 player : server.method_3760().method_14571()) {
                boolean isOp = player.method_64475(2);
                boolean isPerm = BackupConfig.hasBackupPerm(player.method_5667().toString(), player.method_5477().getString());
                if (!isOp && !isPerm || !BackupConfig.permlogEnabled) continue;
                String msg2 = LangManager.tr("backup.restore.noexist", backupFileName);
                player.method_64398((class_2561)class_2561.method_43470((String)msg2));
            }
            return false;
        }
        RestoreManager.logToPlayers(server, LangManager.tr("backup.restore_requested", backupFileName), false, 0);
        String timestamp = backupFileName.replace(".zip", "");
        String logPath = "backups" + File.separator + "logs" + File.separator + timestamp + ".log";
        try {
            logWriter = new BufferedWriter(new FileWriter(logPath, true));
        }
        catch (IOException e) {
            logWriter = null;
        }
        BufferedWriter finalLogWriter = logWriter;
        Consumer<String> logRestore = msg -> {
            String out = "[RestoreManager] " + msg;
            if (finalLogWriter != null) {
                try {
                    finalLogWriter.write(out + "\n");
                    finalLogWriter.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            RestoreManager.logFile(out);
        };
        HashSet<String> dirsToDelete = new HashSet<String>();
        HashSet<String> filesToDelete = new HashSet<String>();
        boolean wasAutoSaveEnabled = true;
        try {
            logRestore.accept("Turning autosave OFF for restore.");
            RestoreManager.setAutosave(server, false);
            try (Iterator zis = new ZipInputStream(new FileInputStream(backupFile));){
                ZipEntry entry;
                while ((entry = ((ZipInputStream)((Object)zis)).getNextEntry()) != null) {
                    String entryName = entry.getName().replace("\\", "/");
                    if (entryName.equals(CONFIG_FILE_PATH)) {
                        logRestore.accept("Skipped config file from deletion/extraction: " + entryName);
                        ((ZipInputStream)((Object)zis)).closeEntry();
                        continue;
                    }
                    if (entry.isDirectory()) {
                        dirsToDelete.add(entryName.split("/")[0]);
                    } else {
                        String topFolder;
                        filesToDelete.add(entryName);
                        String string = topFolder = entryName.contains("/") ? entryName.split("/")[0] : null;
                        if (topFolder != null) {
                            dirsToDelete.add(topFolder);
                        }
                    }
                    ((ZipInputStream)((Object)zis)).closeEntry();
                }
            }
            for (String dirName : dirsToDelete) {
                File dir = new File(dirName);
                if (!dir.exists()) continue;
                logRestore.accept("Deleting folder before restore: " + dir.getAbsolutePath());
                RestoreManager.deleteDirectoryAndLog(dir, logRestore);
            }
            for (String fileName : filesToDelete) {
                File file;
                if (fileName.equals(CONFIG_FILE_PATH) || !(file = new File(fileName)).exists()) continue;
                logRestore.accept("Deleting file before restore: " + file.getAbsolutePath());
                file.delete();
            }
            int extracted = 0;
            int total = filesToDelete.size();
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(backupFile));){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    String entryName = entry.getName().replace("\\", "/");
                    if (entryName.equals(CONFIG_FILE_PATH)) {
                        zis.closeEntry();
                        continue;
                    }
                    if (entry.isDirectory()) {
                        outFile = new File(entryName);
                        outFile.mkdirs();
                        logRestore.accept("Extracting folder: " + entryName);
                    } else {
                        outFile = new File(entryName);
                        File parent = outFile.getParentFile();
                        if (parent != null && !parent.exists()) {
                            parent.mkdirs();
                        }
                        try (FileOutputStream fos = new FileOutputStream(outFile);){
                            int len;
                            byte[] buffer = new byte[4096];
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                        int percent = total > 0 ? (int)((float)(++extracted) * 100.0f / (float)total) : 100;
                        percent = Math.min(percent, 100);
                        RestoreManager.logToPlayers(server, null, true, percent);
                        logRestore.accept("Extracted file: " + entryName);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    zis.closeEntry();
                }
            }
            RestoreManager.logToPlayers(server, LangManager.tr("backup.restored", backupFileName), false, 100);
            logRestore.accept(LangManager.tr("backup.restored", backupFileName));
            File startSh = new File("start.sh");
            File startBat = new File("start.bat");
            RestoreManager.setAutosave(server, wasAutoSaveEnabled);
            logRestore.accept("Autosave restored to previous value.");
            if (startSh.exists() && startSh.isFile()) {
                logRestore.accept("Restore finished. Server will now shut down and start.sh will be executed!");
                if (finalLogWriter != null) {
                    finalLogWriter.close();
                }
                try {
                    Runtime.getRuntime().exec("sh start.sh");
                }
                catch (Exception e) {
                    logRestore.accept("Could not execute start.sh: " + e.getMessage());
                }
            } else if (startBat.exists() && startBat.isFile()) {
                logRestore.accept("Restore finished. Server will now shut down and start.bat will be executed!");
                if (finalLogWriter != null) {
                    finalLogWriter.close();
                }
                try {
                    Runtime.getRuntime().exec("cmd /c start.bat");
                }
                catch (Exception e) {
                    logRestore.accept("Could not execute start.bat: " + e.getMessage());
                }
            } else {
                logRestore.accept("Start Script Linux start.sh or Windows start.bat were not found. Server is shutting down without restart. Please restart the server manually.");
                if (finalLogWriter != null) {
                    finalLogWriter.close();
                }
            }
            return true;
        }
        catch (Exception e) {
            RestoreManager.logToPlayers(server, LangManager.tr("backup.restore_failed", e.getMessage()), true, 0);
            logRestore.accept("Restore failed: " + e.getMessage());
            if (finalLogWriter != null) {
                try {
                    finalLogWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static void deleteDirectoryAndLog(File dir, Consumer<String> logRestore) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    RestoreManager.deleteDirectoryAndLog(file, logRestore);
                    continue;
                }
                logRestore.accept("Deleting file: " + file.getAbsolutePath());
                file.delete();
            }
        }
        logRestore.accept("Deleting folder: " + dir.getAbsolutePath());
        dir.delete();
    }

    private static void logFile(String msg) {
        System.out.println(msg);
        BackupMod.LOGGER.info(msg);
    }

    private static void setAutosave(MinecraftServer server, boolean enable) {
        if (enable) {
            RestoreManager.runServerCommand(server, "save-on");
        } else {
            RestoreManager.runServerCommand(server, "save-off");
        }
    }

    private static void runServerCommand(MinecraftServer server, String cmd) {
        try {
            server.method_3734().method_9235().execute(cmd, (Object)server.method_3739());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logToPlayers(MinecraftServer server, String msg, boolean isDetail, int percent) {
        if (server == null) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            boolean isOp = player.method_64475(2);
            boolean isPerm = BackupConfig.hasBackupPerm(player.method_5667().toString(), player.method_5477().getString());
            if ((isOp || isPerm) && BackupConfig.permlogEnabled) {
                if (msg != null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)(LangManager.tr("backup.prefix", new Object[0]) + msg)));
                }
                if (percent <= 0) continue;
                player.method_64398((class_2561)class_2561.method_43470((String)(LangManager.tr("backup.prefix", new Object[0]) + LangManager.tr("backup.progress", percent))));
                continue;
            }
            if (!BackupConfig.normallogEnabled) continue;
            if (percent > 0) {
                player.method_64398((class_2561)class_2561.method_43470((String)(LangManager.tr("backup.prefix", new Object[0]) + LangManager.tr("backup.progress", percent))));
                continue;
            }
            if (msg == null || isDetail) continue;
            player.method_64398((class_2561)class_2561.method_43470((String)(LangManager.tr("backup.prefix", new Object[0]) + msg)));
        }
    }
}

