/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.screen.entries;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8662;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.components.ConfigsList;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigListEntry;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractConfigurationEntry<T, C extends AbstractConfiguration<T>>
extends AbstractConfigListEntry {
    protected final ConfigsList widget;
    protected final C configuration;
    protected final class_8662 resetWidget;
    protected T value;

    public AbstractConfigurationEntry(ConfigOptionsScreen parent, ConfigsList widget, C configuration) {
        super(parent);
        this.widget = widget;
        this.configuration = configuration;
        this.resetWidget = this.addChild(class_8662.method_52723((class_2561)class_2561.method_43471((String)"configs_screen.pneumonocore.reset"), button -> this.reset(), (boolean)true).method_52727(PneumonoCore.location("icon/reset"), 15, 15).method_52725(20).method_52724());
        this.resetWidget.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"configs_screen.pneumonocore.reset")));
        this.value = this.parent.getConfigValue(this.configuration);
    }

    public C getConfiguration() {
        return this.configuration;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.widget.updateEntryList();
        this.updateButtons();
    }

    public void reset() {
        this.setValue(((AbstractConfiguration)this.configuration).info().getDefaultValue());
    }

    @Override
    public boolean shouldDisplay() {
        AbstractConfiguration<?> configParent = ((AbstractConfiguration)this.configuration).info().getParent();
        if (configParent == null) {
            return true;
        }
        AbstractConfigurationEntry<?, ?> configParentEntry = this.widget.getEntry(configParent.info().getId());
        if (configParentEntry == null) {
            return true;
        }
        return ((AbstractConfiguration)this.configuration).info().isEnabled(configParentEntry.value);
    }

    public int getWidgetStartX() {
        return this.getRowEndXOffset() - 136;
    }

    public int getWidgetEndX() {
        return this.getRowEndXOffset() - this.resetWidget.method_25368() - 6;
    }

    public int getTotalWidgetWidth() {
        return this.getWidgetEndX() - this.getWidgetStartX();
    }

    public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float tickProgress) {
        int x = this.method_46426();
        int y = this.method_46427();
        int entryHeight = this.method_73384();
        class_5250 configName = class_2561.method_43471((String)ConfigApi.toTranslationKey(this.configuration));
        class_327 font = Objects.requireNonNull(this.parent.getMinecraft()).field_1772;
        graphics.method_27535(font, (class_2561)configName, x, y + entryHeight / 2 - 2, -1);
        if (mouseX >= x && mouseX <= x + 135 && mouseY >= y && mouseY <= y + entryHeight) {
            class_5250 class_52502 = class_2561.method_43471((String)ConfigApi.toTranslationKey(this.configuration, "tooltip")).method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)(((AbstractConfiguration)this.configuration).info().isClientSided() ? "configs_screen.pneumonocore.client" : "configs_screen.pneumonocore.server")).method_27692(class_124.field_1080)).method_27693("\n");
            graphics.method_51447(font, font.method_1728((class_5348)class_52502.method_10852((class_2561)class_2561.method_43471((String)(switch (((AbstractConfiguration)this.configuration).info().getLoadType()) {
                default -> throw new MatchException(null, null);
                case LoadType.INSTANT -> "configs_screen.pneumonocore.load_instant";
                case LoadType.RELOAD -> "configs_screen.pneumonocore.load_reload";
                case LoadType.RESTART -> "configs_screen.pneumonocore.load_restart";
            })).method_27692(class_124.field_1080)), 250), mouseX, mouseY);
        }
        this.resetWidget.method_46421(x + this.getRowEndXOffset() - this.resetWidget.method_25368());
        this.resetWidget.method_46419(y);
        this.resetWidget.method_25394(graphics, mouseX, mouseY, tickProgress);
    }

    public boolean shouldSaveValue() {
        return true;
    }
}

