/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.pneumono.pneumonocore.config_api.ConfigFile;
import net.pneumono.pneumonocore.config_api.ConfigSyncS2CPayload;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigManager;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigApi {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"PneumonoCoreConfig");
    private static final Map<String, ConfigFile> CONFIG_FILES = new HashMap<String, ConfigFile>();

    public static <T extends AbstractConfiguration<?>> T register(class_2960 id, T configuration) {
        if (id == null || Objects.equals(id.method_12836(), "") || Objects.equals(id.method_12832(), "")) {
            LOGGER.error("Config '{}' used an invalid ID, and so was not registered.", (Object)id);
            return configuration;
        }
        ConfigFile configFile = CONFIG_FILES.computeIfAbsent(id.method_12836(), ConfigFile::new);
        if (configFile.getConfiguration(id.method_12832()) != null) {
            LOGGER.error("Config '{}' is a duplicate, and so was not registered.", (Object)id);
            return configuration;
        }
        ConfigManager.register(configuration, id);
        configFile.addConfiguration(configuration);
        return configuration;
    }

    public static void finishRegistry(String modId) {
        ConfigApi.reloadValuesFromFile(modId, LoadType.RESTART);
    }

    public static void reloadValuesFromFiles(LoadType loadType) {
        for (ConfigFile configFile : CONFIG_FILES.values()) {
            configFile.readSavedFromFile(loadType);
        }
    }

    public static void reloadValuesFromFile(String modId, LoadType loadType) {
        ConfigFile configFile = CONFIG_FILES.get(modId);
        if (configFile != null) {
            configFile.readSavedFromFile(loadType);
        }
    }

    public static void sendConfigSyncPacket(Collection<class_3222> players) {
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ConfigSyncS2CPayload(CONFIG_FILES.values()));
        }
        LOGGER.info("Sent config sync packet to {} player(s)", (Object)players.size());
    }

    public static Collection<ConfigFile> getConfigFiles() {
        return CONFIG_FILES.values();
    }

    public static ConfigFile getConfigFile(String modId) {
        return CONFIG_FILES.get(modId);
    }

    public static AbstractConfiguration<?> getConfig(class_2960 id) {
        ConfigFile modConfigs = ConfigApi.getConfigFile(id.method_12836());
        if (modConfigs != null) {
            return modConfigs.getConfiguration(id.method_12832());
        }
        return null;
    }

    public static String toTranslationKey(AbstractConfiguration<?> configuration, String suffix) {
        return configuration.info().getId().method_48747("configs", suffix);
    }

    public static String toTranslationKey(AbstractConfiguration<?> configuration) {
        return configuration.info().getId().method_42093("configs");
    }
}

