/*
 * Decompiled with CFR 0.152.
 */
package lol.sylvie.petprotect.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import lol.sylvie.petprotect.PetProtect;

public class ConfigInstance {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @SerializedName(value="prevent_pet_damage")
    boolean preventPetDamage = true;
    @SerializedName(value="prevent_pet_death")
    boolean preventPetDeath = true;
    @SerializedName(value="apply_totem_effects")
    boolean applyTotemEffects = false;
    @SerializedName(value="prevent_pet_attack")
    boolean preventPetAttack = true;
    @SerializedName(value="allow_owner_damage")
    boolean allowOwnerDamage = false;
    @SerializedName(value="ignore_creative")
    boolean ignoreCreative = true;

    public static ConfigInstance fromFile(File file) {
        ConfigInstance configInstance;
        FileReader reader = new FileReader(file);
        try {
            configInstance = (ConfigInstance)GSON.fromJson((Reader)reader, ConfigInstance.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException readException) {
                PetProtect.LOGGER.warn("Couldn't load config for one reason or another. (ignore if this is the first time loading PetProtect)");
                ConfigInstance instance = new ConfigInstance();
                instance.writeToFile(file);
                return instance;
            }
        }
        reader.close();
        return configInstance;
    }

    public void writeToFile(File file) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException writeException) {
            PetProtect.LOGGER.error("Couldn't write to config!", (Throwable)writeException);
        }
    }

    public boolean preventPetDamage() {
        return this.preventPetDamage;
    }

    public boolean preventPetDeath() {
        return this.preventPetDeath;
    }

    public boolean applyTotemEffects() {
        return this.applyTotemEffects;
    }

    public boolean preventPetAttack() {
        return this.preventPetAttack;
    }

    public boolean allowOwnerDamage() {
        return this.allowOwnerDamage;
    }

    public boolean shouldIgnoreCreative() {
        return this.ignoreCreative;
    }
}

