/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.balm.api.EmptyLoadContext;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.entity.BalmEntity;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.network.NetworkVersions;
import net.blay09.mods.balm.api.network.ServerboundModListMessage;
import net.blay09.mods.balm.common.BalmLoadContexts;
import net.blay09.mods.balm.common.CommonCapabilities;
import net.blay09.mods.balm.fabric.FabricBalmProxy;
import net.blay09.mods.balm.fabric.FabricBalmRuntime;
import net.blay09.mods.balm.fabric.fluid.BalmFluidStorage;
import net.blay09.mods.balm.fabric.loader.FabricBalmPlatform;
import net.blay09.mods.balm.fabric.network.FabricBalmNetworking;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class FabricBalm
implements ModInitializer {
    private static final Supplier<FabricBalmProxy> proxy = Balm.sidedProxy("net.blay09.mods.balm.fabric.FabricBalmProxy", "net.blay09.mods.balm.fabric.client.FabricBalmClientProxy").buildLazily();

    public static FabricBalmProxy getProxy() {
        return proxy.get();
    }

    public void onInitialize() {
        BalmLoadContexts.register("balm", EmptyLoadContext.INSTANCE);
        ((FabricBalmRuntime)Balm.getRuntime()).initializeRuntime();
        ((FabricBalmPlatform)Balm.platform()).initialize();
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            class_2487 data = ((BalmEntity)oldPlayer).getFabricBalmData();
            ((BalmEntity)newPlayer).setFabricBalmData(data);
        });
        ItemStorage.SIDED.registerFallback((BlockApiLookup.BlockApiProvider)new BlockApiLookup.BlockApiProvider<Storage<ItemVariant>, class_2350>(this){
            private boolean running;

            @Nullable
            public Storage<ItemVariant> find(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_2350 direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmContainerProvider) {
                    class_1263 container;
                    BalmContainerProvider containerProvider = (BalmContainerProvider)blockEntity;
                    class_1263 class_12632 = container = direction != null ? containerProvider.getContainer(direction) : containerProvider.getContainer();
                    if (container != null) {
                        return InventoryStorage.of((class_1263)container, (class_2350)direction);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    class_1263 container = Balm.capabilities().getCapability(blockEntity, direction, CommonCapabilities.CONTAINER);
                    this.running = false;
                    if (container != null) {
                        return InventoryStorage.of((class_1263)container, (class_2350)direction);
                    }
                }
                return null;
            }
        });
        FluidStorage.SIDED.registerFallback((BlockApiLookup.BlockApiProvider)new BlockApiLookup.BlockApiProvider<Storage<FluidVariant>, class_2350>(this){
            private boolean running;

            @Nullable
            public Storage<FluidVariant> find(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_2350 direction) {
                if (this.running) {
                    return null;
                }
                if (blockEntity instanceof BalmFluidTankProvider) {
                    FluidTank fluidTank;
                    BalmFluidTankProvider fluidTankProvider = (BalmFluidTankProvider)blockEntity;
                    FluidTank fluidTank2 = fluidTank = direction != null ? fluidTankProvider.getFluidTank(direction) : fluidTankProvider.getFluidTank();
                    if (fluidTank != null) {
                        return new BalmFluidStorage(fluidTank);
                    }
                } else if (blockEntity != null) {
                    this.running = true;
                    FluidTank fluidTank = Balm.capabilities().getCapability(blockEntity, direction, CommonCapabilities.FLUID_TANK);
                    this.running = false;
                    if (fluidTank != null) {
                        return new BalmFluidStorage(fluidTank);
                    }
                }
                return null;
            }
        });
        Balm.networking().registerServerboundPacket(ServerboundModListMessage.TYPE, ServerboundModListMessage.class, class_9139.method_56437((buf, message) -> {
            buf.method_10804(message.modList().size());
            message.modList().forEach((modId, versions) -> {
                buf.method_10814(modId);
                buf.method_10814(versions.modVersion());
                buf.method_10814(versions.networkVersion());
                buf.method_52964(versions.requireRemote());
            });
        }, buf -> {
            HashMap<String, NetworkVersions> modVersions = new HashMap<String, NetworkVersions>();
            int modCount = buf.method_10816();
            for (int i = 0; i < modCount; ++i) {
                String modId = buf.method_19772();
                modVersions.put(modId, new NetworkVersions(buf.method_19772(), buf.method_19772(), buf.readBoolean()));
            }
            return new ServerboundModListMessage(modVersions);
        }), (player, message) -> {
            FabricBalmNetworking networking = (FabricBalmNetworking)Balm.networking();
            for (Map.Entry<String, NetworkVersions> entry : message.modList().entrySet()) {
                String modId = entry.getKey();
                NetworkVersions clientVersions = entry.getValue();
                Optional<NetworkVersions> serverVersionsOpt = networking.getNetworkVersions(modId, BalmEnvironment.DEDICATED_SERVER);
                if (serverVersionsOpt.isEmpty()) {
                    if (!clientVersions.requireRemote()) continue;
                    player.field_13987.method_52396((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_missing_on_server", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1061)}));
                    return;
                }
                NetworkVersions serverVersions = serverVersionsOpt.get();
                if (clientVersions.networkVersion().equals(serverVersions.networkVersion())) continue;
                player.field_13987.method_52396((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_version_mismatch", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1065), class_2561.method_43470((String)serverVersions.modVersion()).method_27692(class_124.field_1060), class_2561.method_43470((String)clientVersions.modVersion()).method_27692(class_124.field_1061)}));
                return;
            }
            for (String modId : networking.getRegisteredMods()) {
                NetworkVersions serverVersions = networking.getNetworkVersions(modId, BalmEnvironment.DEDICATED_SERVER).orElseThrow();
                if (!serverVersions.requireRemote() || message.modList().containsKey(modId)) continue;
                String serverModVersion = serverVersions.modVersion();
                player.field_13987.method_52396((class_2561)class_2561.method_43469((String)"disconnect.balm.mod_missing_on_client", (Object[])new Object[]{class_2561.method_43470((String)modId).method_27692(class_124.field_1061), class_2561.method_43470((String)modId).method_27692(class_124.field_1065), class_2561.method_43470((String)serverModVersion).method_27692(class_124.field_1060)}));
                return;
            }
        });
        Balm.initializeIfLoaded("team_reborn_energy", "net.blay09.mods.balm.fabric.compat.energy.RebornEnergy");
    }
}

