/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.rightclickharvest;

import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.JamLibPlatform;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.rightclickharvest.Config;
import io.github.jamalam360.rightclickharvest.HarvestContext;
import io.github.jamalam360.rightclickharvest.HelloPacket;
import io.github.jamalam360.rightclickharvest.RightClickHarvestPlatform;
import io.github.jamalam360.rightclickharvest.ServerLangProvider;
import io.github.jamalam360.rightclickharvest.mixin.CropBlockAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2266;
import net.minecraft.class_2282;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2421;
import net.minecraft.class_2523;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RightClickHarvest {
    public static final String MOD_ID = "rightclickharvest";
    public static final String MOD_NAME = "Right Click Harvest";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Right Click Harvest");
    public static final ConfigManager<Config> CONFIG = new ConfigManager("rightclickharvest", Config.class);
    public static final class_6862<class_2248> BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)RightClickHarvest.id("blacklist"));
    public static final class_6862<class_2248> HOE_NEVER_REQUIRED = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)RightClickHarvest.id("hoe_never_required"));
    public static final class_6862<class_2248> RADIUS_HARVEST_BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)RightClickHarvest.id("radius_harvest_blacklist"));
    public static final class_6862<class_1792> LOW_TIER_HOES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)RightClickHarvest.id("low_tier_hoes"));
    public static final class_6862<class_1792> MID_TIER_HOES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)RightClickHarvest.id("mid_tier_hoes"));
    public static final class_6862<class_1792> HIGH_TIER_HOES = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)RightClickHarvest.id("high_tier_hoes"));
    public static final class_2350[] CARDINAL_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    private static final class_6017 XP_PROVIDER = class_6019.method_35017((int)0, (int)2);
    private static final List<UUID> PLAYERS_WARNED_FOR_NOT_USING_HOE = new ArrayList<UUID>();

    public static void init() {
        LOGGER.info("Initializing Right Click Harvest on {}", (Object)JamLibPlatform.getPlatform().name());
        JamLib.checkForJarRenaming(RightClickHarvest.class);
        if (Platform.getEnvironment() == Env.SERVER) {
            NetworkManager.registerS2CPayloadType(HelloPacket.TYPE, HelloPacket.STREAM_CODEC);
        }
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (NetworkManager.canPlayerReceive((class_3222)player, HelloPacket.TYPE)) {
                NetworkManager.sendToPlayer((class_3222)player, (class_8710)new HelloPacket());
            }
        });
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, face) -> RightClickHarvest.onBlockUse(player, player.method_73183(), hand, new class_3965(player.method_73189(), face, pos, false), true));
    }

    @ApiStatus.Internal
    public static class_1269 onBlockUse(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult, boolean initialCall) {
        if (player.method_7325() || player.method_18276() || hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_2680 state = level.method_8320(hitResult.method_17777());
        class_1799 stackInHand = player.method_5998(hand);
        boolean hoeInUse = false;
        if (state.method_26164(BLACKLIST)) {
            return class_1269.field_5811;
        }
        if (((Config)RightClickHarvest.CONFIG.get()).hungerLevel != Config.HungerLevel.NONE && !player.method_31549().field_7477 && player.method_7344().method_7586() <= 0) {
            return class_1269.field_5811;
        }
        if (((Config)RightClickHarvest.CONFIG.get()).experienceType == Config.ExperienceType.COST && !player.method_31549().field_7477 && player.field_7520 < XP_PROVIDER.method_35011()) {
            return class_1269.field_5811;
        }
        if (!state.method_26164(HOE_NEVER_REQUIRED) && ((Config)RightClickHarvest.CONFIG.get()).requireHoe) {
            if (!RightClickHarvest.isHoe(stackInHand)) {
                RightClickHarvest.warnPlayerForNotUsingHoe(player, state, stackInHand);
                return class_1269.field_5811;
            }
            hoeInUse = true;
        }
        if (!initialCall && state.method_26164(RADIUS_HARVEST_BLACKLIST)) {
            return class_1269.field_5811;
        }
        if (state.method_26204() instanceof class_2282 || state.method_26204() instanceof class_2302 || state.method_26204() instanceof class_2421) {
            if (RightClickHarvest.isMature(state)) {
                if (initialCall && ((Config)RightClickHarvest.CONFIG.get()).harvestInRadius && !state.method_26164(RADIUS_HARVEST_BLACKLIST) && RightClickHarvest.isHoe(stackInHand)) {
                    int radius = 0;
                    boolean circle = false;
                    hoeInUse = true;
                    if (stackInHand.method_31573(HIGH_TIER_HOES)) {
                        radius = 2;
                        circle = true;
                    } else if (stackInHand.method_31573(MID_TIER_HOES)) {
                        radius = 1;
                        circle = false;
                    } else if (stackInHand.method_31573(LOW_TIER_HOES)) {
                        radius = 1;
                        circle = true;
                    }
                    if (radius == 1 && circle) {
                        for (class_2350 dir : CARDINAL_DIRECTIONS) {
                            RightClickHarvest.onBlockUse(player, level, hand, hitResult.method_29328(hitResult.method_17777().method_10093(dir)), false);
                        }
                    } else if (radius > 0) {
                        for (int x = -radius; x <= radius; ++x) {
                            for (int z = -radius; z <= radius; ++z) {
                                if (x == 0 && z == 0) continue;
                                class_2338 pos = hitResult.method_17777().method_30513(class_2350.class_2351.field_11048, x).method_30513(class_2350.class_2351.field_11051, z);
                                if (circle && pos.method_19455((class_2382)hitResult.method_17777()) > radius) continue;
                                RightClickHarvest.onBlockUse(player, level, hand, hitResult.method_29328(pos), false);
                            }
                        }
                    }
                }
                return RightClickHarvest.completeHarvest(level, state, hitResult.method_17777(), player, hand, stackInHand, hoeInUse, true, () -> {
                    class_2680 replantState = RightClickHarvest.getReplantState(state);
                    level.method_8501(hitResult.method_17777(), replantState);
                    player.method_7259(class_3468.field_15372.method_14956((Object)replantState.method_26204().method_8389()));
                });
            }
        } else if (state.method_26204() instanceof class_2523 || state.method_26204() instanceof class_2266) {
            if (hitResult.method_17780() == class_2350.field_11036 && (stackInHand.method_7909() == class_1802.field_17531 && state.method_26204() instanceof class_2523 || stackInHand.method_7909() == class_1802.field_17520 && state.method_26204() instanceof class_2266)) {
                return class_1269.field_5811;
            }
            class_2248 lookingFor = state.method_26204() instanceof class_2523 ? class_2246.field_10424 : class_2246.field_10029;
            class_2338 bottom = hitResult.method_17777();
            while (level.method_8320(bottom.method_10074()).method_27852(lookingFor)) {
                bottom = bottom.method_10074();
            }
            if (!level.method_8320(bottom.method_10084()).method_27852(lookingFor)) {
                return class_1269.field_5811;
            }
            class_2338 breakPos = bottom.method_10086(1);
            return RightClickHarvest.completeHarvest(level, state, breakPos, player, hand, stackInHand, hoeInUse, false, () -> level.method_8650(breakPos, false));
        }
        return class_1269.field_5811;
    }

    private static void warnPlayerForNotUsingHoe(class_1657 player, class_2680 state, class_1799 stackInHand) {
        class_3222 serverPlayer;
        if (!RightClickHarvest.isHarvestable(state) || !stackInHand.method_7960()) {
            return;
        }
        if (player.method_73183().method_8608()) {
            if (!((Config)RightClickHarvest.CONFIG.get()).hasUserBeenWarnedForNotUsingHoe) {
                player.method_7353((class_2561)class_2561.method_43469((String)"text.rightclickharvest.use_a_hoe_warning", (Object[])new Object[]{class_2561.method_43471((String)"config.rightclickharvest.requireHoe").method_27694(s -> s.method_10977(class_124.field_1060)), class_2561.method_43470((String)"false").method_27694(s -> s.method_10977(class_124.field_1060))}), false);
                ((Config)RightClickHarvest.CONFIG.get()).hasUserBeenWarnedForNotUsingHoe = true;
                CONFIG.save();
            }
        } else if (player instanceof class_3222 && !NetworkManager.canPlayerReceive((class_3222)(serverPlayer = (class_3222)player), HelloPacket.TYPE) && !PLAYERS_WARNED_FOR_NOT_USING_HOE.contains(player.method_5667())) {
            String playerLang = serverPlayer.method_53823().comp_1951();
            player.method_7353((class_2561)class_2561.method_43469((String)ServerLangProvider.getUseHoeMessageByLanguage(playerLang), (Object[])new Object[]{class_2561.method_43470((String)ServerLangProvider.getRequireHoeConfigByLanguage(playerLang)).method_27694(s -> s.method_10977(class_124.field_1060)), class_2561.method_43470((String)"false").method_27694(s -> s.method_10977(class_124.field_1060))}), false);
            PLAYERS_WARNED_FOR_NOT_USING_HOE.add(player.method_5667());
        }
    }

    private static class_1269 completeHarvest(class_1937 level, class_2680 state, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stackInHand, boolean hoeInUse, boolean removeReplant, Runnable setBlockAction) {
        if (!level.method_8608()) {
            class_2248 originalBlock = state.method_26204();
            if (RightClickHarvestPlatform.postBreakEvent(level, pos, state, player)) {
                return class_1269.field_5814;
            }
            if (RightClickHarvestPlatform.postPlaceEvent(level, pos, player)) {
                return class_1269.field_5814;
            }
            player.method_7259(class_3468.field_15427.method_14956((Object)state.method_26204()));
            player.method_7259(class_3468.field_15372.method_14956((Object)stackInHand.method_7909()));
            RightClickHarvest.dropStacks(state, (class_3218)level, pos, (class_1297)player, player.method_5998(hand), removeReplant);
            setBlockAction.run();
            if (hoeInUse) {
                stackInHand.method_7970(1, (class_1309)player, hand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            }
            player.method_7322(0.008f * ((Config)RightClickHarvest.CONFIG.get()).hungerLevel.modifier);
            int xp = switch (((Config)RightClickHarvest.CONFIG.get()).experienceType) {
                default -> throw new MatchException(null, null);
                case Config.ExperienceType.COST -> -XP_PROVIDER.method_35008(player.method_59922());
                case Config.ExperienceType.REWARD -> XP_PROVIDER.method_35008(player.method_59922());
                case Config.ExperienceType.NONE -> 0;
            };
            player.method_7255(xp);
            RightClickHarvestPlatform.postAfterHarvestEvent(new HarvestContext(player, originalBlock));
        } else {
            player.method_5783(state.method_26204() instanceof class_2421 ? class_3417.field_17613 : class_3417.field_17611, 1.0f, 1.0f);
        }
        return class_1269.field_5812;
    }

    private static boolean isHarvestable(class_2680 state) {
        if (state.method_26204() instanceof class_2282 || state.method_26204() instanceof class_2302 || state.method_26204() instanceof class_2421) {
            return RightClickHarvest.isMature(state);
        }
        return state.method_26204() instanceof class_2523 || state.method_26204() instanceof class_2266;
    }

    private static boolean isHoe(class_1799 stack) {
        return stack.method_31573(class_3489.field_42613) || stack.method_31573(LOW_TIER_HOES) || stack.method_31573(MID_TIER_HOES) || stack.method_31573(HIGH_TIER_HOES) || RightClickHarvestPlatform.isHoeAccordingToPlatform(stack);
    }

    private static boolean isMature(class_2680 state) {
        if (state.method_26204() instanceof class_2282) {
            return (Integer)state.method_11654((class_2769)class_2282.field_10779) >= 2;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            return cropBlock.method_9825(state);
        }
        if (state.method_26204() instanceof class_2421) {
            return (Integer)state.method_11654((class_2769)class_2421.field_11306) >= 3;
        }
        return false;
    }

    private static class_2680 getReplantState(class_2680 state) {
        if (state.method_26204() instanceof class_2282) {
            return (class_2680)state.method_11657((class_2769)class_2282.field_10779, (Comparable)Integer.valueOf(0));
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 cropBlock = (class_2302)class_22482;
            return (class_2680)state.method_11657((class_2769)((CropBlockAccessor)cropBlock).invokeGetAgeProperty(), (Comparable)Integer.valueOf(0));
        }
        if (state.method_26204() instanceof class_2421) {
            return (class_2680)state.method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    private static void dropStacks(class_2680 state, class_3218 world, class_2338 pos, class_1297 entity, class_1799 toolStack, boolean removeReplant) {
        class_1792 replant = state.method_65171((class_4538)world, pos, true).method_7909();
        boolean[] removedReplant = new boolean[]{!removeReplant};
        class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, null, (class_1297)entity, (class_1799)toolStack).forEach(stack -> {
            if (!removedReplant[0] && stack.method_7909() == replant) {
                stack.method_7939(stack.method_7947() - 1);
                removedReplant[0] = true;
            }
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack);
        });
        state.method_26180(world, pos, toolStack, true);
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }
}

