/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.core.util;

import net.minecraft.world.entity.player.Player;

public class ExperienceHelper {
    public static boolean hasEnoughExperiencePoints(Player player, int amount) {
        if (player.isCreative()) {
            return true;
        }
        return amount <= 0 || ExperienceHelper.getTotalPlayerExperiencePoints(player) >= amount;
    }

    public static boolean hasEnoughExperienceLevels(Player player, int amount) {
        if (player.isCreative()) {
            return true;
        }
        return amount <= 0 || ExperienceHelper.getTotalPlayerExperienceLevels(player) >= amount;
    }

    private static int getTotalPlayerExperienceLevels(Player player) {
        return player.experienceLevel;
    }

    public static void deductExperiencePoints(Player player, int amount) {
        int playerXP;
        if (amount > 0 && (playerXP = ExperienceHelper.getTotalPlayerExperiencePoints(player)) >= amount) {
            ExperienceHelper.addExperiencePoints(player, -amount);
        }
    }

    public static void deductExperienceLevels(Player player, int amount) {
        if (amount > 0) {
            player.experienceLevel -= amount;
        }
    }

    public static int getTotalPlayerExperiencePoints(Player player) {
        return (int)((float)ExperienceHelper.getExperiencePointsFromLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    public static void addExperiencePoints(Player player, int amount) {
        int experience;
        player.totalExperience = experience = ExperienceHelper.getTotalPlayerExperiencePoints(player) + amount;
        player.experienceLevel = ExperienceHelper.getLevelFromExperiencePoints(experience);
        int expForLevel = ExperienceHelper.getExperiencePointsFromLevel(player.experienceLevel);
        player.experienceProgress = (float)(experience - expForLevel) / (float)player.getXpNeededForNextLevel();
    }

    public static void addExperienceLevels(Player player, int amount) {
        player.experienceLevel += amount;
    }

    public static int getHighestExperienceAtLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static int getExperiencePointsFromLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceHelper.arithmeticSeriesSum(level, 7, 2);
        }
        return level <= 30 ? 315 + ExperienceHelper.arithmeticSeriesSum(level - 15, 37, 5) : 1395 + ExperienceHelper.arithmeticSeriesSum(level - 30, 112, 9);
    }

    public static int getLevelFromExperiencePoints(int amount) {
        int level = 0;
        int xpToNextLevel;
        while (amount >= (xpToNextLevel = ExperienceHelper.getHighestExperienceAtLevel(level))) {
            ++level;
            amount -= xpToNextLevel;
        }
        return level;
    }

    private static int arithmeticSeriesSum(int n, int a, int d) {
        return n / 2 * (2 * a + (n - 1) * d);
    }
}

