/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import common.com.cursee.disenchanting_table.DisEnchantingTableServer;
import common.com.cursee.disenchanting_table.core.world.block.entity.DisEnchantingTableBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class DisEnchantingTableRenderer
implements BlockEntityRenderer<DisEnchantingTableBlockEntity, TableRenderState> {
    private static final ItemStack MANUAL_STACK = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
    private final ItemModelResolver itemModelResolver;

    public DisEnchantingTableRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public TableRenderState createRenderState() {
        return new TableRenderState();
    }

    public void extractRenderState(DisEnchantingTableBlockEntity campfireBlockEntity, TableRenderState campfireRenderState, float f, Vec3 vec3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)campfireBlockEntity, (BlockEntityRenderState)campfireRenderState, f, vec3, crumblingOverlay);
        campfireRenderState.facing = (Direction)campfireBlockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        int i = (int)campfireBlockEntity.getBlockPos().asLong();
        campfireRenderState.items = new ArrayList<ItemStackRenderState>();
        ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
        this.itemModelResolver.updateForTopItem(itemStackRenderState, campfireBlockEntity.getItem(0), ItemDisplayContext.FIXED, campfireBlockEntity.getLevel(), (ItemOwner)null, i + 0);
        campfireRenderState.items.add(itemStackRenderState);
        campfireRenderState.manual = new ArrayList<ItemStackRenderState>();
        ItemStackRenderState manualStackState = new ItemStackRenderState();
        this.itemModelResolver.updateForTopItem(manualStackState, MANUAL_STACK, ItemDisplayContext.FIXED, campfireBlockEntity.getLevel(), (ItemOwner)null, i + 0);
        campfireRenderState.manual.add(manualStackState);
    }

    public void submit(TableRenderState campfireRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        Direction direction = campfireRenderState.facing;
        List<ItemStackRenderState> list = campfireRenderState.items;
        ItemStackRenderState itemStackRenderState = list.getFirst();
        if (!DisEnchantingTableServer.automatic_disenchanting) {
            itemStackRenderState = campfireRenderState.manual.getFirst();
        }
        if (!itemStackRenderState.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.75f, 0.5f);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Direction facing = Direction.from2DDataValue((int)(direction.get2DDataValue() % 4));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(facing != Direction.EAST && facing != Direction.WEST ? facing.getOpposite().toYRot() : facing.toYRot()));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            itemStackRenderState.submit(poseStack, submitNodeCollector, campfireRenderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }

    public boolean shouldRender(DisEnchantingTableBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }

    public static class TableRenderState
    extends BlockEntityRenderState {
        public List<ItemStackRenderState> manual = Collections.emptyList();
        public List<ItemStackRenderState> items = Collections.emptyList();
        public Direction facing = Direction.NORTH;
    }
}

