/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.disenchanting_table;

import common.com.cursee.disenchanting_table.Constants;
import common.com.cursee.disenchanting_table.DisEnchantingTable;
import common.com.cursee.disenchanting_table.impl.common.config.SimpleConfig;
import common.com.cursee.disenchanting_table.platform.Services;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class DisEnchantingTableServer {
    public static boolean automatic_disenchanting = false;
    public static int automatic_disenchanting_ticks = 10;
    public static boolean resets_repair_cost = true;
    public static boolean requires_experience = true;
    public static boolean uses_points = true;
    public static int experience_cost = 25;

    public static void createOrLoadConfiguration() {
        String configDirectoryPathString = Services.PLATFORM.getGameDirectory() + File.separator + "config";
        File configDirectory = new File(configDirectoryPathString);
        if (!configDirectory.isDirectory() && !configDirectory.mkdirs()) {
            DisEnchantingTable.mkdirsFailed(configDirectoryPathString);
            return;
        }
        String configFileNameString = "disenchanting_table-server.toml";
        String configFilePathString = configDirectoryPathString + File.separator + configFileNameString;
        File configFile = new File(configFilePathString);
        if (!configFile.exists()) {
            try (InputStream inputStream = DisEnchantingTable.class.getClassLoader().getResourceAsStream("assets/" + configFileNameString);){
                if (inputStream == null) {
                    Constants.LOG.info("Failed to initialize InputStream instance for assets/{}", (Object)configFileNameString);
                    return;
                }
                try (BufferedInputStream bis = new BufferedInputStream(inputStream);
                     BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(configFile));){
                    int bytesRead;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = bis.read(buffer)) != -1) {
                        bos.write(buffer, 0, bytesRead);
                    }
                }
            }
            catch (IOException e) {
                Constants.LOG.info("Failed to read internal resource: assets/{}", (Object)configFileNameString);
                Constants.LOG.info(e.getMessage());
            }
        } else {
            try {
                SimpleConfig config = new SimpleConfig(configFilePathString);
                automatic_disenchanting = config.getBoolean("automatic_disenchanting", automatic_disenchanting);
                automatic_disenchanting_ticks = config.getInteger("automatic_disenchanting_ticks", automatic_disenchanting_ticks);
                resets_repair_cost = config.getBoolean("resets_repair_cost", resets_repair_cost);
                requires_experience = config.getBoolean("requires_experience", requires_experience);
                uses_points = config.getBoolean("uses_points", uses_points);
            }
            catch (IOException ignored) {
                Constants.LOG.info("Failed to read {}, retaining default config values", (Object)configFilePathString);
            }
        }
    }
}

