/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import java.util.Set;
import net.minecraft.class_11944;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7833;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;
import pigcart.particlerain.particle.WeatherParticle;

public class CustomParticle
extends WeatherParticle {
    private static final Set<String> usuallyUntintableSprites = Set.of("particlerain:rain_0", "particlerain:rain_1", "particlerain:rain_2", "particlerain:rain_3");
    public ConfigData.ParticleData opts;
    private float oCollisionAnimProgress = 1.0f;
    private float collisionAnimProgress = 1.0f;
    private float speed = 0.0f;
    private final float rotationVariation;
    boolean doCollisionAnim = false;
    public class_2338.class_2339 pos;
    protected class_2338.class_2339 oPos;
    class_3965 collision = null;
    float baseTemp;
    float oQuadSize;
    float distance;

    public CustomParticle(class_638 level, double x, double y, double z, ConfigData.ParticleData opts) {
        super(level, x, y, z, VersionUtil.getSprite(VersionUtil.parseId(opts.spriteLocations.get(level.field_9229.method_43048(opts.spriteLocations.size())))));
        this.field_3844 = opts.gravity;
        this.field_3869 = -this.field_3844;
        this.field_17867 = opts.size;
        this.field_62636 = 0.0f;
        this.field_3862 = false;
        this.method_3080(this.field_17867, this.field_17867);
        this.field_3847 = ConfigManager.config.perf.particleDistance * 100;
        this.pos = new class_2338.class_2339(x, y, z);
        this.oPos = new class_2338.class_2339(x, y, z);
        this.baseTemp = ((class_1959)level.method_23753((class_2338)this.pos).comp_349()).method_8712();
        this.opts = opts;
        this.field_3847 = opts.lifetime;
        this.rotationVariation = opts.rotationAmount * ((this.field_3840.method_43057() - 0.5f) * 2.0f);
        this.field_17867 = opts.constantScreenSize ? this.getDistanceSize() : opts.size;
        if (!usuallyUntintableSprites.contains(this.field_62632.method_45851().method_45816().toString()) || ConfigManager.config.compat.waterTint) {
            opts.tintType.applyTint(this, level, (class_2338)this.pos, opts);
        }
    }

    @Override
    public void method_3070() {
        super.method_3070();
        this.oQuadSize = this.field_17867;
        this.distance = (float)VersionUtil.camPos(class_310.method_1551().field_1773.method_19418()).method_1022(new class_243(this.field_3874, this.field_3854, this.field_3871));
        this.pos.method_10102(this.field_3874, this.field_3854, this.field_3871);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.method_10101((class_2382)this.pos);
        }
        if (this.doCollisionAnim) {
            this.tickCollisionAnim();
        }
        this.tickDistanceFade();
        this.speed = (float)new class_243(this.field_3852, this.field_3869, this.field_3850).method_1033();
        if (this.opts.constantScreenSize && !this.doCollisionAnim) {
            this.field_17867 = this.getDistanceSize();
        }
        if (this.opts.rotationAmount != 0.0f) {
            this.field_62638 = this.field_62637;
            this.field_62637 += this.rotationVariation * this.speed;
        }
        this.tickWind();
    }

    @Override
    public void tickDistanceFade() {
        float renderDistance = ConfigManager.config.perf.particleDistance;
        if (this.distance > renderDistance + 1.0f) {
            this.method_3085();
        } else {
            this.field_62636 = class_3532.method_16439((float)class_3532.method_15363((float)(this.distance / renderDistance), (float)0.0f, (float)1.0f), (float)this.opts.opacity, (float)0.0f);
        }
    }

    public void tickWind() {
        float multiplier;
        float frequency = ConfigManager.config.wind.gustFrequency;
        float shift = (float)ParticleRain.clientTicks * ConfigManager.config.wind.modulationSpeed;
        float variance = ConfigManager.config.wind.strengthVariance;
        float strength = ConfigManager.config.wind.strength;
        float f = multiplier = this.field_3851.method_8546() ? this.opts.stormWindStrength : this.opts.windStrength;
        if (ConfigManager.config.wind.yLevelAdjustment) {
            multiplier *= CustomParticle.yLevelWindMultiplier(this.field_3854);
        }
        this.field_3852 = (class_3532.method_15374((float)((float)this.field_3874 * frequency + shift)) * variance + variance + strength) * multiplier + 0.001f;
        this.field_3850 = (class_3532.method_15374((float)((float)this.field_3871 * frequency + shift)) * variance + variance + strength) * multiplier + 0.001f;
    }

    public static float yLevelWindMultiplier(double y) {
        int transitionStart = 50;
        int transitionDistance = 40;
        return (float)class_3532.method_15350((double)((y - (double)transitionStart) / (double)transitionDistance), (double)0.0, (double)1.0);
    }

    @Override
    public void onPositionUpdate() {
        if (!ConfigManager.config.compat.crossBiomeBorder && (double)class_3532.method_15379((float)(((class_1959)this.field_3851.method_23753((class_2338)this.pos).comp_349()).method_8712() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.field_3851.method_8320((class_2338)this.pos).method_26234((class_1922)this.field_3851, (class_2338)this.pos) || !this.field_3851.method_8316((class_2338)this.pos).method_15769()) {
            this.method_3085();
        }
        this.testForCollisions();
    }

    public void testForCollisions() {
        class_243 quadEdgePos;
        class_243 quadCenterPos;
        class_3965 hitResult;
        float length = this.field_17867;
        if (this.opts.rotationType.equals((Object)ConfigData.RotationType.RELATIVE_VELOCITY)) {
            class_243 camD = class_310.method_1551().method_1560().method_18798();
            Vector3f deltaMotion = new Vector3f((float)(this.field_3852 - camD.field_1352), (float)(this.field_3869 - camD.field_1351), (float)(this.field_3850 - camD.field_1350));
            length *= class_3532.method_15363((float)deltaMotion.lengthSquared(), (float)0.2f, (float)1.0f);
        }
        if (!(hitResult = this.field_3851.method_17742(VersionUtil.getClipContext(quadCenterPos = new class_243(this.field_3874, this.field_3854, this.field_3871), quadEdgePos = new class_243(this.field_3852, this.field_3869, this.field_3850).method_1029().method_18805((double)length, (double)length, (double)length).method_1031(this.field_3874, this.field_3854, this.field_3871)))).method_17783().equals((Object)class_239.class_240.field_1333) && !this.doCollisionAnim) {
            this.collision = hitResult;
            this.doCollisionAnim = true;
        }
    }

    @Override
    public void tickCollisionAnim() {
        this.oCollisionAnimProgress = this.collisionAnimProgress;
        this.collisionAnimProgress -= this.speed;
        if (!this.opts.rotationType.equals((Object)ConfigData.RotationType.RELATIVE_VELOCITY)) {
            this.field_17867 -= this.speed;
        }
        if (this.oCollisionAnimProgress <= 0.0f) {
            this.method_3085();
        }
    }

    public float getDistanceSize() {
        if (class_310.method_1551().field_1690.method_31044().method_31034() && class_310.method_1551().field_1724.method_31550()) {
            return this.distance * this.opts.size * 0.25f;
        }
        return this.distance * this.opts.size;
    }

    @Override
    public class_3940.class_11941 method_74255() {
        return this.opts.renderType.get();
    }

    public void method_3074(class_11944 h, class_4184 camera, float tickPercent) {
        this.opts.rotationType.render(h, camera, tickPercent, this);
    }

    public void renderLookingQuad(class_11944 h, class_4184 camera, float tickPercent) {
        class_243 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3858, (double)this.field_3874) - camPos.method_10216());
        float offsetY = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3838, (double)this.field_3854) - camPos.method_10214());
        float offsetZ = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3856, (double)this.field_3871) - camPos.method_10215());
        Vector3f localPos = new Vector3f(offsetX, offsetY, offsetZ);
        Quaternionf quaternion = class_7833.field_40716.rotation(Math.atan2((float)offsetX, (float)offsetZ) + (float)java.lang.Math.PI);
        float yAngle = Math.asin((float)(offsetY / localPos.length()));
        quaternion.rotateX(yAngle);
        quaternion.rotateZ(Math.atan2((float)offsetX, (float)offsetZ));
        if (yAngle < -1.0f) {
            this.doCollisionAnim = true;
        }
        quaternion.rotateZ(class_3532.method_16439((float)tickPercent, (float)this.field_62638, (float)this.field_62637));
        this.renderRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    public void renderRelativeVelocityQuad(class_11944 h, class_4184 camera, float tickPercent) {
        float collisionProg;
        class_243 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3858, (double)this.field_3874) - camPos.method_10216());
        float offsetY = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3838, (double)this.field_3854) - camPos.method_10214());
        float offsetZ = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3856, (double)this.field_3871) - camPos.method_10215());
        class_243 camD = class_310.method_1551().method_1560().method_18798();
        Vector3f deltaMotion = new Vector3f((float)(this.field_3852 - camD.field_1352), (float)(this.field_3869 - camD.field_1351), (float)(this.field_3850 - camD.field_1350));
        float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
        quaternion.mul((Quaternionfc)class_7833.field_40716.rotation(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
        float stretchFactor = class_3532.method_15363((float)deltaMotion.lengthSquared(), (float)0.25f, (float)1.0f);
        if (this.doCollisionAnim && (collisionProg = class_3532.method_16439((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
            stretchFactor = collisionProg;
        }
        this.renderSquishyRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
    }

    public void renderWorldVelocityQuad(class_11944 h, class_4184 camera, float tickPercent) {
        float collisionProg;
        class_243 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3858, (double)this.field_3874) - camPos.method_10216());
        float offsetY = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3838, (double)this.field_3854) - camPos.method_10214());
        float offsetZ = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3856, (double)this.field_3871) - camPos.method_10215());
        Vector3f deltaMotion = new Vector3f((float)this.field_3852, (float)this.field_3869, (float)this.field_3850);
        float angle = Math.acos((float)new Vector3f((Vector3fc)deltaMotion).normalize().y);
        Vector3f axis = new Vector3f(-deltaMotion.z(), 0.0f, deltaMotion.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        Vector3f transformedOffset = new Vector3f(offsetX, offsetY, offsetZ);
        transformedOffset.rotateAxis(angle, axis.x, axis.y, axis.z);
        quaternion.mul((Quaternionfc)class_7833.field_40716.rotation(Math.atan2((float)transformedOffset.x, (float)transformedOffset.z) + (float)java.lang.Math.PI));
        float stretchFactor = class_3532.method_15363((float)deltaMotion.lengthSquared(), (float)0.25f, (float)1.0f);
        if (this.doCollisionAnim && (collisionProg = class_3532.method_16439((float)tickPercent, (float)this.oCollisionAnimProgress, (float)this.collisionAnimProgress)) < stretchFactor) {
            stretchFactor = collisionProg;
        }
        this.renderSquishyRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent, stretchFactor);
    }

    public void renderCameraCopyQuad(class_11944 h, class_4184 camera, float tickPercent) {
        class_243 camPos = VersionUtil.camPos(camera);
        float offsetX = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3858, (double)this.field_3874) - camPos.method_10216());
        float offsetY = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3838, (double)this.field_3854) - camPos.method_10214());
        float offsetZ = (float)(class_3532.method_16436((double)tickPercent, (double)this.field_3856, (double)this.field_3871) - camPos.method_10215());
        Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.method_23767());
        if (this.field_62637 != 0.0f) {
            quaternion.rotateZ(class_3532.method_16439((float)tickPercent, (float)this.field_62638, (float)this.field_62637));
        }
        this.renderRotatedQuad(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    @Override
    public void renderRotatedQuad(class_11944 h, Quaternionf quaternion, float offsetX, float offsetY, float offsetZ, float tickPercent) {
        this.method_60375(h, quaternion, offsetX, offsetY, offsetZ, tickPercent);
    }

    private void renderSquishyRotatedQuad(class_11944 h, Quaternionf quaternion, float x, float y, float z, float tickPercent, float squish) {
        this.method_60375(h, quaternion, x, y, z, tickPercent);
    }

    public static class DefaultFactory
    implements class_707<class_2400> {
        ConfigData.ParticleData opts;

        public DefaultFactory(ConfigData.ParticleData opts) {
            this.opts = opts;
        }

        public class_703 createParticle(class_2400 parameters, class_638 level, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_5819 random) {
            for (ConfigData.ParticleData options : ConfigManager.config.particles) {
                if (!this.opts.id.equals(options.id)) continue;
                this.opts = options;
            }
            return new CustomParticle(level, x, y, z, this.opts);
        }
    }
}

