/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import pigcart.particlerain.ParticleRain;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.gui.ConfigScreen;
import pigcart.particlerain.mixin.access.ParticleEngineAccessor;

public class ConfigManager {
    static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Color.class, (Object)new ColorTypeAdapter()).create();
    static final String CONFIG_PATH = "config/particlerain.json";
    public static ConfigData config;

    public static class_437 screenPlease(class_437 lastScreen) {
        return new ConfigScreen(lastScreen, config, ConfigManager.getDefaultConfig(), (class_2561)class_2561.method_43471((String)"particlerain.title"));
    }

    public static ConfigData getDefaultConfig() {
        return new ConfigData();
    }

    public static void load() {
        File file = new File(CONFIG_PATH);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                config = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            }
            catch (Exception e) {
                ParticleRain.LOGGER.error("Error loading config: {}", (Object)e.getMessage());
                config = ConfigManager.getDefaultConfig();
                ConfigManager.save();
            }
        } else {
            ParticleRain.LOGGER.info("Creating config file at config/particlerain.json");
            config = ConfigManager.getDefaultConfig();
            ConfigManager.save();
        }
        if (ConfigManager.config.configVersion < ConfigManager.getDefaultConfig().configVersion) {
            ParticleRain.LOGGER.info("Overwriting old config file");
            config = ConfigManager.getDefaultConfig();
            ConfigManager.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (Exception e) {
            ParticleRain.LOGGER.error(e.getMessage());
        }
        ConfigManager.updateTransientVariables();
    }

    public static void updateTransientVariables() {
        for (ConfigData.ParticleData opts : ConfigManager.config.particles) {
            opts.biomeList.populateInternalLists();
            opts.blockList.populateInternalLists();
            opts.setPresetParticle();
        }
    }

    public static List<String> getRegistryEntries(class_2378<?> registry) {
        ArrayList<String> list = new ArrayList<String>();
        registry.method_10235().forEach(id -> list.add(id.toString()));
        VersionUtil.getTagIds(registry).forEach(tag -> list.add("#" + String.valueOf(tag.comp_327())));
        return list;
    }

    public static class ColorTypeAdapter
    implements JsonSerializer<Color>,
    JsonDeserializer<Color> {
        public static Color getColor(String string) {
            return Color.decode(string);
        }

        public static String getString(Color color) {
            return String.join((CharSequence)"", "#", String.format("%02X", color.getRed()), String.format("%02X", color.getGreen()), String.format("%02X", color.getBlue()));
        }

        public JsonElement serialize(Color color, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(ColorTypeAdapter.getString(color));
        }

        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return ColorTypeAdapter.getColor(json.getAsString());
        }
    }

    public static class UsingCustomTint
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.tintType == ConfigData.TintType.CUSTOM;
        }
    }

    public static class ParticleIsNotDefault
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ConfigManager.getDefaultConfig().particles.stream().noneMatch(defaultData -> ctx.id.equals(defaultData.id));
        }
    }

    public static class ParticleNotCustom
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.usePresetParticle;
        }
    }

    public static class ParticleIsCustom
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return !ctx.usePresetParticle;
        }
    }

    public static class ParticleIsCustomAndAlsoUsesCustomTint
    implements Function<Object, Boolean> {
        @Override
        public Boolean apply(Object context) {
            ConfigData.ParticleData ctx = (ConfigData.ParticleData)context;
            return ctx.tintType.equals((Object)ConfigData.TintType.CUSTOM) && new ParticleIsCustom().apply(context) != false;
        }
    }

    public static class SupplyBiomes
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            if (class_310.method_1551().field_1687 == null) {
                return List.of("[!] \u00a7e\u00a7l" + class_2561.method_43471((String)"particlerain.suggest").getString());
            }
            return ConfigManager.getRegistryEntries(VersionUtil.getRegistry(class_7924.field_41236));
        }
    }

    public static class SupplyBlocks
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            if (class_310.method_1551().field_1687 == null) {
                return List.of("[!] \u00a7e\u00a7l" + class_2561.method_43471((String)"particlerain.suggest").getString());
            }
            return ConfigManager.getRegistryEntries(class_7923.field_41175);
        }
    }

    public static class SupplyParticleTypes
    implements Supplier<List<String>> {
        @Override
        public List<String> get() {
            ArrayList<String> list = new ArrayList<String>();
            for (Map.Entry entry : class_7923.field_41180.method_29722()) {
                if (!(entry.getValue() instanceof class_2400)) continue;
                list.add(VersionUtil.getKeyId((class_5321)entry.getKey()).toString());
            }
            return list;
        }
    }

    public static class RefreshScreen
    implements Runnable {
        @Override
        public void run() {
            ((ConfigScreen)class_310.method_1551().field_1755).refresh();
        }
    }

    public static class ClearParticles
    implements Runnable {
        @Override
        public void run() {
            ((ParticleEngineAccessor)class_310.method_1551().field_1713).callClearParticles();
        }
    }

    public static class ReloadResources
    implements Runnable {
        @Override
        public void run() {
            class_310.method_1551().method_1521();
        }
    }

    public static class ZeroIsAutomatic
    implements Function<Object, class_2561> {
        @Override
        public class_2561 apply(Object stringValue) {
            int value = Integer.parseInt((String)stringValue);
            return value == 0 ? class_2561.method_43471((String)"particlerain.auto") : class_2561.method_43470((String)((String)stringValue));
        }
    }

    public static class PercentOrOff
    implements Function<Object, class_2561> {
        @Override
        public class_2561 apply(Object value) {
            return ((Number)value).floatValue() == 0.0f ? class_5244.field_24333.method_27661().method_27692(class_124.field_1061) : class_2561.method_43470((String)NumberFormat.getPercentInstance().format(value));
        }
    }

    public static class Percent
    implements Function<Object, class_2561> {
        @Override
        public class_2561 apply(Object value) {
            return class_2561.method_43470((String)NumberFormat.getPercentInstance().format(value));
        }
    }
}

