/*
 * Decompiled with CFR 0.152.
 */
package de.tert0.containerclaims;

import com.google.common.collect.ImmutableSet;
import de.tert0.containerclaims.AdminModeAccess;
import de.tert0.containerclaims.ClaimAccess;
import de.tert0.containerclaims.ClaimComponent;
import de.tert0.containerclaims.DoubleChestUtils;
import de.tert0.containerclaims.GlobalClaimState;
import de.tert0.containerclaims.GroupComponent;
import de.tert0.containerclaims.GroupState;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class ClaimUtils {
    public static void markClaimed(ClaimAccess claimAccess, class_3218 serverWorld) {
        class_2586 blockEntity = (class_2586)claimAccess;
        GlobalClaimState.getWorldState(serverWorld).addPosition(blockEntity.method_11016());
    }

    public static void claim(ClaimAccess claimAccess, UUID uuid, class_3218 serverWorld) {
        ClaimComponent claim = new ClaimComponent(uuid, Instant.now(), (ImmutableSet<UUID>)ImmutableSet.of(), (ImmutableSet<UUID>)ImmutableSet.of());
        claimAccess.cclaims$setClaim(claim);
        ClaimUtils.markClaimed(claimAccess, serverWorld);
        class_2586 blockEntity = DoubleChestUtils.getNeighborBlockEntity(((class_2586)claimAccess).method_11016(), (class_1937)serverWorld);
        if (blockEntity != null) {
            ClaimAccess otherClaimAccess = (ClaimAccess)blockEntity;
            otherClaimAccess.cclaims$setClaim(claim);
            ClaimUtils.markClaimed(otherClaimAccess, serverWorld);
        }
    }

    public static void markUnclaimed(ClaimAccess claimAccess, class_3218 serverWorld) {
        class_2586 blockEntity = (class_2586)claimAccess;
        GlobalClaimState.getWorldState(serverWorld).removePosition(blockEntity.method_11016());
    }

    public static void unclaim(ClaimAccess claimAccess, class_3218 serverWorld) {
        claimAccess.cclaims$setClaim(null);
        ClaimUtils.markUnclaimed(claimAccess, serverWorld);
        class_2586 blockEntity = DoubleChestUtils.getNeighborBlockEntity(((class_2586)claimAccess).method_11016(), (class_1937)serverWorld);
        if (blockEntity != null) {
            ClaimAccess otherClaimAccess = (ClaimAccess)blockEntity;
            otherClaimAccess.cclaims$setClaim(null);
            ClaimUtils.markUnclaimed(otherClaimAccess, serverWorld);
        }
    }

    public static void trust(ClaimAccess claimAccess, Collection<UUID> entries) {
        ClaimComponent claim = claimAccess.cclaims$getClaim().addTrusted(entries);
        claimAccess.cclaims$setClaim(claim);
        class_2586 blockEntity = DoubleChestUtils.getNeighborBlockEntity(((class_2586)claimAccess).method_11016(), ((class_2586)claimAccess).method_10997());
        if (blockEntity != null) {
            ClaimAccess otherClaimAccess = (ClaimAccess)blockEntity;
            otherClaimAccess.cclaims$setClaim(claim);
        }
    }

    public static void trustGroup(ClaimAccess claimAccess, GroupComponent group) {
        ClaimComponent claim = claimAccess.cclaims$getClaim().addTrustedGroups((Collection<UUID>)ImmutableSet.of((Object)group.uuid()));
        claimAccess.cclaims$setClaim(claim);
        class_2586 blockEntity = DoubleChestUtils.getNeighborBlockEntity(((class_2586)claimAccess).method_11016(), ((class_2586)claimAccess).method_10997());
        if (blockEntity != null) {
            ClaimAccess otherClaimAccess = (ClaimAccess)blockEntity;
            otherClaimAccess.cclaims$setClaim(claim);
        }
    }

    public static void untrust(ClaimAccess claimAccess, Collection<UUID> entries) {
        ClaimComponent claim = claimAccess.cclaims$getClaim().removeTrusted(entries);
        claimAccess.cclaims$setClaim(claim);
        class_2586 blockEntity = DoubleChestUtils.getNeighborBlockEntity(((class_2586)claimAccess).method_11016(), ((class_2586)claimAccess).method_10997());
        if (blockEntity != null) {
            ClaimAccess otherClaimAccess = (ClaimAccess)blockEntity;
            otherClaimAccess.cclaims$setClaim(claim);
        }
    }

    public static void untrustGroup(ClaimAccess claimAccess, GroupComponent group) {
        ClaimComponent claim = claimAccess.cclaims$getClaim().removeTrustedGroups((Collection<UUID>)ImmutableSet.of((Object)group.uuid()));
        claimAccess.cclaims$setClaim(claim);
        class_2586 blockEntity = DoubleChestUtils.getNeighborBlockEntity(((class_2586)claimAccess).method_11016(), ((class_2586)claimAccess).method_10997());
        if (blockEntity != null) {
            ClaimAccess otherClaimAccess = (ClaimAccess)blockEntity;
            otherClaimAccess.cclaims$setClaim(claim);
        }
    }

    public static boolean isClaimed(ClaimAccess claimAccess) {
        return claimAccess.cclaims$getClaim() != null;
    }

    public static boolean isOwner(ClaimAccess claimAccess, UUID uuid) {
        return claimAccess.cclaims$getClaim().owner().equals(uuid);
    }

    public static boolean isOwnerOrAdmin(ClaimAccess claimAccess, class_1657 player) {
        AdminModeAccess adminModeAccess;
        if (player instanceof AdminModeAccess && (adminModeAccess = (AdminModeAccess)player).cclaims$getAdminMode()) {
            return true;
        }
        return ClaimUtils.isOwner(claimAccess, player.method_5667());
    }

    public static boolean isTrusted(ClaimAccess claimAccess, UUID uuid) {
        return claimAccess.cclaims$getClaim().trusted().contains((Object)uuid);
    }

    public static boolean isGroupTrusted(ClaimAccess claimAccess, GroupComponent group) {
        return claimAccess.cclaims$getClaim().trustedGroups().contains((Object)group.uuid());
    }

    public static boolean isGroupTrusted(ClaimAccess claimAccess, class_3222 player) {
        return GroupState.getState(player.method_51469().method_8503()).getGroups().stream().filter(g -> g.isMember(player.method_5667())).anyMatch(g -> ClaimUtils.isGroupTrusted(claimAccess, g));
    }

    public static boolean canUse(ClaimAccess claimAccess, class_3222 player) {
        return ClaimUtils.isOwnerOrAdmin(claimAccess, (class_1657)player) || ClaimUtils.isTrusted(claimAccess, player.method_5667()) || ClaimUtils.isGroupTrusted(claimAccess, player);
    }
}

