/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.particle;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7923;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.util.LeafUtil;
import randommcsomethin.fallingleaves.util.Wind;

public class FallingLeafParticle
extends class_3940 {
    public static final float TAU = (float)Math.PI * 2;
    public static final int FADE_DURATION = 16;
    public static final double WATER_FRICTION = 0.075;
    protected final float windCoefficient;
    protected final float maxRotateSpeed;
    protected final int maxRotateTime;
    protected int rotateTime = 0;
    protected boolean inWater = false;
    protected boolean stuckInGround = false;

    public FallingLeafParticle(class_2396<class_2388> particleType, class_638 clientWorld, double x, double y, double z, double r, double g, double b, class_1058 sprite) {
        super(clientWorld, x, y, z, 0.0, 0.0, 0.0, sprite);
        if (particleType == Leaves.FALLING_CHERRY) {
            this.field_3844 = 0.0175f + this.field_3840.method_43057() * 0.005f;
            this.windCoefficient = 0.12f + this.field_3840.method_43057() * 0.8f;
        } else if (particleType == Leaves.FALLING_SNOW) {
            this.field_3844 = 0.0125f + this.field_3840.method_43057() * 0.0125f;
            this.windCoefficient = 0.1f + this.field_3840.method_43057() * 0.1f;
        } else {
            this.field_3844 = 0.08f + this.field_3840.method_43057() * 0.04f;
            this.windCoefficient = 0.6f + this.field_3840.method_43057() * 0.4f;
        }
        this.field_3852 = 0.0;
        this.field_3869 = 0.0;
        this.field_3850 = 0.0;
        this.field_3847 = Config.CONFIG.leafLifespan;
        this.field_62633 = (float)r;
        this.field_62634 = (float)g;
        this.field_62635 = (float)b;
        if (particleType == Leaves.FALLING_CHERRY || particleType == Leaves.FALLING_SNOW) {
            this.maxRotateTime = (3 + this.field_3840.method_43048(5)) * 20;
            this.maxRotateSpeed = (float)(this.field_3840.method_43056() ? -1 : 1) * (0.1f + 0.4f * this.field_3840.method_43057()) * ((float)Math.PI * 2) / 20.0f;
        } else {
            this.maxRotateTime = (3 + this.field_3840.method_43048(5)) * 20;
            this.maxRotateSpeed = (float)(this.field_3840.method_43056() ? -1 : 1) * (0.1f + 2.4f * this.field_3840.method_43057()) * ((float)Math.PI * 2) / 20.0f;
        }
        this.field_62637 = this.field_62638 = this.field_3840.method_43057() * ((float)Math.PI * 2);
        this.field_17867 = particleType == Leaves.FALLING_CHERRY ? Config.CONFIG.getLeafSize() / 2.0f : Config.CONFIG.getLeafSize();
        if (this.field_3840.method_43056()) {
            this.field_17867 *= 1.5f;
        }
    }

    public void method_3070() {
        double waterY;
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.field_62638 = this.field_62637;
        ++this.field_3866;
        if (this.field_3866 >= this.field_3847 + 1 - 16) {
            this.field_62636 -= 0.0625f;
        }
        if (this.field_3866 >= this.field_3847) {
            this.method_3085();
            return;
        }
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        class_3610 fluidState = this.field_3851.method_8316(blockPos);
        if (fluidState.method_15767(class_3486.field_15518) && (waterY = (double)((float)blockPos.method_10264() + fluidState.method_15763((class_1922)this.field_3851, blockPos))) >= this.field_3854) {
            this.field_3851.method_8406((class_2394)class_2398.field_11239, this.field_3874, this.field_3854, this.field_3871, 0.0, 0.0, 0.0);
            this.method_3085();
            return;
        }
        this.field_3869 -= 0.04 * ((double)this.field_3844 + (this.field_3851.method_8419() && this.field_3851.method_8311(blockPos) ? 0.04 : 0.0));
        if (fluidState.method_15767(class_3486.field_15517)) {
            double d;
            waterY = (float)blockPos.method_10264() + fluidState.method_15763((class_1922)this.field_3851, blockPos);
            if (d >= this.field_3854 - 0.1) {
                if (!this.inWater) {
                    this.inWater = true;
                    if (Math.abs(waterY - this.field_3854) < 0.2) {
                        this.field_3854 = waterY;
                    }
                    this.field_3869 *= 0.1;
                    this.field_3852 *= 0.5;
                    this.field_3850 *= 0.5;
                    this.rotateTime = 0;
                } else {
                    double depth = Math.max(waterY + 0.1 - this.field_3854, 0.0);
                    this.field_3869 += depth * (double)this.windCoefficient / 30.0;
                }
                if (!fluidState.method_15771()) {
                    class_243 pushVel = fluidState.method_15758((class_1922)this.field_3851, blockPos).method_1021(0.4);
                    this.field_3852 += (pushVel.field_1352 - this.field_3852) * (double)this.windCoefficient / 60.0;
                    this.field_3850 += (pushVel.field_1350 - this.field_3850) * (double)this.windCoefficient / 60.0;
                }
                this.field_3852 *= 0.925;
                this.field_3869 *= 0.925;
                this.field_3850 *= 0.925;
            }
        } else {
            this.inWater = false;
            if (!this.field_3845) {
                this.rotateTime = Math.min(this.rotateTime + 1, this.maxRotateTime);
                this.field_62637 += (float)this.rotateTime / (float)this.maxRotateTime * this.maxRotateSpeed;
            } else {
                this.rotateTime = 0;
            }
            this.field_3852 += ((double)Wind.windX - this.field_3852) * (double)this.windCoefficient / 60.0;
            this.field_3850 += ((double)Wind.windZ - this.field_3850) * (double)this.windCoefficient / 60.0;
        }
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
    }

    public void method_3069(double dx, double dy, double dz) {
        if (dx == 0.0 && dy == 0.0 && dz == 0.0) {
            return;
        }
        double oldDx = dx;
        double oldDy = dy;
        double oldDz = dz;
        class_243 vec3d = class_1297.method_20736(null, (class_243)new class_243(dx, dy, dz), (class_238)this.method_3064(), (class_1937)this.field_3851, List.of());
        dx = vec3d.field_1352;
        dy = vec3d.field_1351;
        dz = vec3d.field_1350;
        if (oldDx != dx) {
            this.field_3852 = 0.0;
        }
        if (oldDz != dz) {
            this.field_3850 = 0.0;
        }
        boolean bl = this.field_3845 = oldDy != dy && oldDy < 0.0;
        if (!this.field_3845) {
            this.stuckInGround = false;
        } else if (!this.stuckInGround && Math.abs(dy) < 1.0E-5) {
            this.stuckInGround = true;
        }
        if (this.stuckInGround) {
            this.field_3852 = 0.0;
            this.field_3869 = 0.0;
            this.field_3850 = 0.0;
            return;
        }
        if (dx != 0.0 || dy != 0.0 || dz != 0.0) {
            this.method_3067(this.method_3064().method_989(dx, dy, dz));
            this.method_3072();
        }
    }

    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    @Environment(value=EnvType.CLIENT)
    public record BlockStateFactory(class_4002 spriteProvider) implements class_707<class_2388>
    {
        public class_703 createParticle(class_2388 parameters, class_638 world, double x, double y, double z, double unusedX, double unusedY, double unusedZ, class_5819 random) {
            double r;
            double g;
            double b;
            class_2396 particleType = parameters.method_10295();
            class_4002 customSpriteProvider = null;
            if (particleType == Leaves.FALLING_CHERRY) {
                customSpriteProvider = LeafUtil.getSpriteProvider(LeafUtil.CHERRY_LEAVES_PARTICLE_ID);
                b = 1.0;
                g = 1.0;
                r = 1.0;
            } else if (particleType == Leaves.FALLING_SNOW) {
                b = 1.0;
                g = 1.0;
                r = 1.0;
            } else {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)parameters.method_10278().method_26204());
                customSpriteProvider = (class_4002)Leaves.CUSTOM_LEAVES.get(FallingLeavesClient.id("block/%s/%s".formatted(blockId.method_12836(), blockId.method_12832())));
                if (Config.CONFIG.useVanillaTextures && particleType == Leaves.FALLING_LEAF && customSpriteProvider == null) {
                    customSpriteProvider = LeafUtil.getSpriteProvider(LeafUtil.TINTED_LEAVES_PARTICLE_ID);
                }
                double[] color = LeafUtil.getBlockTextureColor(parameters.method_10278(), (class_1937)world, class_2338.method_49637((double)x, (double)y, (double)z));
                r = color[0];
                g = color[1];
                b = color[2];
            }
            class_1058 sprite = (customSpriteProvider != null ? customSpriteProvider : this.spriteProvider).method_18139(random);
            return new FallingLeafParticle((class_2396<class_2388>)particleType, world, x, y, z, r, g, b, sprite);
        }
    }
}

