/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.storage;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.component.LimiterLimitComponent;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.item.LimiterItem;
import io.github.mattidragon.extendeddrawers.item.UpgradeItem;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.registry.ModDataComponents;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public interface ModifierDrawerStorage
extends ModifierAccess,
DrawerStorage {
    public StorageDrawerBlockEntity getOwner();

    @Override
    default public boolean changeUpgrade(ItemVariant newUpgrade, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        if (!(newUpgrade.getItem() instanceof UpgradeItem) && !newUpgrade.isBlank()) {
            return false;
        }
        ItemVariant oldUpgrade = this.settings().upgrade;
        if (newUpgrade.isBlank() && oldUpgrade.isBlank()) {
            return false;
        }
        this.settings().upgrade = newUpgrade;
        if (this.getTrueAmount() > this.getCapacity() && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().blockUpgradeRemovalsWithOverflow()) {
            this.settings().upgrade = oldUpgrade;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"extended_drawer.drawer.upgrade_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, oldUpgrade.toStack());
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    @Override
    default public boolean changeLimiter(ItemVariant newLimiter, class_1937 world, class_2338 pos, class_2350 side, @Nullable class_1657 player) {
        if (!(newLimiter.getItem() instanceof LimiterItem) && !newLimiter.isBlank()) {
            return false;
        }
        ItemVariant oldLimiter = this.settings().limiter;
        if (newLimiter.isBlank() && oldLimiter.isBlank()) {
            return false;
        }
        this.settings().limiter = newLimiter;
        if (this.getTrueAmount() > this.getCapacity() && ((ConfigData)ExtendedDrawers.CONFIG.get()).misc().blockUpgradeRemovalsWithOverflow()) {
            this.settings().limiter = oldLimiter;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"extended_drawer.drawer.limiter_fail"), true);
            }
            return false;
        }
        ItemUtils.offerOrDrop(world, pos, side, player, oldLimiter.toStack());
        this.dumpExcess(world, pos, side, player);
        return true;
    }

    default public void update() {
        this.getOwner().onSlotChanged(this.settings().sortingDirty);
        this.settings().sortingDirty = false;
    }

    public void dumpExcess(class_1937 var1, class_2338 var2, @Nullable class_2350 var3, @Nullable class_1657 var4);

    default public void readData(class_11368 view) {
        this.settings().locked = view.method_71433("locked", false);
        this.settings().voiding = view.method_71433("voiding", false);
        this.settings().hidden = view.method_71433("hidden", false);
        this.settings().duping = view.method_71433("duping", false);
        this.settings().upgrade = view.method_71426("capacityUpgrade", ItemVariant.CODEC).orElseGet(ItemVariant::blank);
        this.settings().limiter = view.method_71426("limiter", ItemVariant.CODEC).orElseGet(ItemVariant::blank);
    }

    default public void writeData(class_11372 view) {
        view.method_71472("locked", this.settings().locked);
        view.method_71472("voiding", this.settings().voiding);
        view.method_71472("hidden", this.settings().hidden);
        view.method_71472("duping", this.settings().duping);
        view.method_71468("capacityUpgrade", ItemVariant.CODEC, (Object)this.settings().upgrade);
        view.method_71468("limiter", ItemVariant.CODEC, (Object)this.settings().limiter);
    }

    @Override
    default public void overrideLock(TransactionContext transaction) {
        if (this.settings().lockOverridden) {
            ExtendedDrawers.LOGGER.warn("Tried to override drawer lock while already overridden. Unexpected behavior may follow.");
            return;
        }
        transaction.addCloseCallback((transaction1, result) -> {
            this.settings().lockOverridden = false;
        });
        this.settings().lockOverridden = true;
    }

    @Override
    default public boolean isLocked() {
        return this.settings().locked;
    }

    @Override
    default public boolean isVoiding() {
        return this.settings().voiding;
    }

    @Override
    default public boolean isHidden() {
        return this.settings().hidden;
    }

    @Override
    default public boolean isDuping() {
        return this.settings().duping;
    }

    @Override
    @Nullable
    default public UpgradeItem getUpgrade() {
        UpgradeItem upgrade;
        class_1792 class_17922 = this.settings().upgrade.getItem();
        return class_17922 instanceof UpgradeItem ? (upgrade = (UpgradeItem)class_17922) : null;
    }

    @Override
    default public long getLimiter() {
        return ((LimiterLimitComponent)this.settings().limiter.getComponentMap().method_58695(ModDataComponents.LIMITER_LIMIT, (Object)LimiterLimitComponent.NO_LIMIT)).limit();
    }

    @Override
    default public void setLocked(boolean locked) {
        this.settings().sortingDirty = true;
        this.settings().locked = locked;
        this.update();
    }

    @Override
    default public void setVoiding(boolean voiding) {
        this.settings().sortingDirty = true;
        this.settings().voiding = voiding;
        this.update();
    }

    @Override
    default public void setHidden(boolean hidden) {
        this.settings().hidden = hidden;
        this.update();
    }

    @Override
    default public void setDuping(boolean duping) {
        this.settings().duping = duping;
        this.update();
    }

    @Override
    default public boolean hasLimiter() {
        return !this.settings().limiter.isBlank();
    }

    public Settings settings();

    public long getCapacity();

    public long getTrueAmount();

    public static class Settings {
        ItemVariant upgrade = ItemVariant.blank();
        ItemVariant limiter = ItemVariant.blank();
        boolean locked = false;
        boolean hidden = false;
        boolean voiding = false;
        boolean duping = false;
        boolean lockOverridden = false;
        boolean sortingDirty = false;
    }
}

