/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.compacting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record CompressionLadder(List<Step> steps) {
    public static final Codec<CompressionLadder> CODEC = Codec.unboundedMap((Codec)Codec.withAlternative((Codec)ItemVariant.CODEC.validate(variant -> variant.isBlank() ? DataResult.error(() -> "Cannot use air") : DataResult.success((Object)variant)), (Codec)class_1792.field_54952.flatComapMap(entry -> ItemVariant.of((class_1935)((class_1935)entry.comp_349())), variant -> variant.hasComponents() ? DataResult.error(() -> "Cannot serialize components") : DataResult.success((Object)variant.getRegistryEntry()))), (Codec)Codec.intRange((int)1, (int)Integer.MAX_VALUE)).xmap(map -> new CompressionLadder(map.entrySet().stream().map(entry -> new Step((ItemVariant)entry.getKey(), (Integer)entry.getValue())).toList()), ladder -> (Map)ladder.steps.stream().collect(Collectors.toMap(Step::item, Step::size, (a, b) -> a, Object2ObjectArrayMap::new))).validate(ladder -> {
        int prevSize = 1;
        for (Step step : ladder.steps) {
            if (step.size < prevSize) {
                int finalPrevSize = prevSize;
                return DataResult.error(() -> "Compression ladder entries must have increasing size order, but %s < %s".formatted(step.size, finalPrevSize));
            }
            prevSize = step.size;
        }
        return DataResult.success((Object)ladder);
    });
    public static final class_9139<class_9129, CompressionLadder> PACKET_CODEC = class_9139.method_56434((class_9139)Step.PACKET_CODEC.method_56433(class_9135.method_56363()), CompressionLadder::steps, CompressionLadder::new);

    public CompressionLadder(List<Step> steps) {
        this.steps = List.copyOf(steps);
    }

    public int getPosition(ItemVariant item) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.steps.get((int)i).item.equals((Object)item)) continue;
            return i;
        }
        return -1;
    }

    public record Step(ItemVariant item, int size) {
        public static final class_9139<class_9129, Step> PACKET_CODEC = class_9139.method_56435((class_9139)ItemVariant.PACKET_CODEC, Step::item, (class_9139)class_9135.field_48550, Step::size, Step::new);
    }
}

