/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.DrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.client.renderer.AbstractDrawerBlockEntityRenderer;
import io.github.mattidragon.extendeddrawers.client.renderer.state.DrawerRenderState;
import io.github.mattidragon.extendeddrawers.client.renderer.state.DrawerSlotRenderState;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import io.github.mattidragon.extendeddrawers.storage.DrawerSlot;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2738;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DrawerBlockEntityRenderer
extends AbstractDrawerBlockEntityRenderer<DrawerBlockEntity, DrawerRenderState> {
    public DrawerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public DrawerRenderState createRenderState() {
        return new DrawerRenderState();
    }

    public void updateRenderState(DrawerBlockEntity drawer, DrawerRenderState state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331(drawer, state, tickProgress, cameraPos, crumblingOverlay);
        state.slotCount = drawer.slots;
        if (state.slots == null || state.slots.length != drawer.slots) {
            state.slots = new DrawerSlotRenderState[drawer.slots];
        }
        for (int i = 0; i < drawer.storages.length; ++i) {
            DrawerSlotRenderState slotState = state.slots[i];
            if (slotState == null) {
                slotState = new DrawerSlotRenderState();
            }
            DrawerSlot slot = drawer.storages[i];
            slotState.isLocked = slot.isLocked();
            slotState.isVoiding = slot.isVoiding();
            slotState.isHidden = slot.isHidden();
            slotState.isDuping = slot.isDuping();
            slotState.upgrade = slot.getUpgrade();
            slotState.hasLimiter = slot.hasLimiter();
            this.itemModelManager.method_65596(slotState.item, slot.getResource().toStack(), class_811.field_4317, drawer.method_10997(), null, drawer.method_11016().hashCode() * i);
            slotState.amount = slot.getAmount();
            state.slots[i] = slotState;
        }
    }

    public void render(DrawerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        class_2350 horizontalDir = (class_2350)state.field_62674.method_11654(StorageDrawerBlock.FACING);
        class_2738 face = (class_2738)state.field_62674.method_11654(StorageDrawerBlock.FACE);
        matrices.method_22903();
        this.alignMatrices(matrices, horizontalDir, face);
        int light = state.field_62676;
        int slots = state.slotCount;
        class_2338 pos = state.field_62673;
        switch (slots) {
            case 1: {
                this.renderSlot(state.slots[0], false, light, matrices, queue, cameraState, pos);
                break;
            }
            case 2: {
                matrices.method_22904(-0.25, 0.0, 0.0);
                this.renderSlot(state.slots[0], true, light, matrices, queue, cameraState, pos);
                matrices.method_22904(0.5, 0.0, 0.0);
                this.renderSlot(state.slots[1], true, light, matrices, queue, cameraState, pos);
                break;
            }
            case 4: {
                matrices.method_22904(-0.25, 0.25, 0.0);
                this.renderSlot(state.slots[0], true, light, matrices, queue, cameraState, pos);
                matrices.method_22904(0.5, 0.0, 0.0);
                this.renderSlot(state.slots[1], true, light, matrices, queue, cameraState, pos);
                matrices.method_22904(-0.5, -0.5, 0.0);
                this.renderSlot(state.slots[2], true, light, matrices, queue, cameraState, pos);
                matrices.method_22904(0.5, 0.0, 0.0);
                this.renderSlot(state.slots[3], true, light, matrices, queue, cameraState, pos);
                break;
            }
            default: {
                ExtendedDrawers.LOGGER.error("Unexpected drawer slot count, skipping rendering. Are you an addon dev adding more configurations? If so please mixin into DrawerBlockEntityRenderer and add your layout.");
            }
        }
        matrices.method_22909();
    }

    public int method_33893() {
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        return Math.max(config.iconRenderDistance(), Math.max(config.textRenderDistance(), config.itemRenderDistance()));
    }

    private void renderSlot(DrawerSlotRenderState slotState, boolean small, int light, class_4587 matrices, class_11659 queue, class_12075 cameraState, class_2338 pos) {
        ArrayList<class_4730> icons = new ArrayList<class_4730>();
        ClientCategory.IconGroup config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().icons();
        class_2960 blockAtlas = class_1059.field_5275;
        if (slotState.isLocked) {
            icons.add(new class_4730(blockAtlas, config.lockedIcon()));
        }
        if (slotState.isVoiding) {
            icons.add(new class_4730(blockAtlas, config.voidingIcon()));
        }
        if (slotState.isHidden) {
            icons.add(new class_4730(blockAtlas, config.hiddenIcon()));
        }
        if (slotState.isDuping) {
            icons.add(new class_4730(blockAtlas, config.dupingIcon()));
        }
        if (slotState.upgrade != null) {
            icons.add(new class_4730(blockAtlas, slotState.upgrade.sprite));
        }
        if (slotState.hasLimiter) {
            icons.add(new class_4730(blockAtlas, ExtendedDrawers.id("item/limiter")));
        }
        String amount = String.valueOf(slotState.amount);
        if (slotState.amount == 0L && !((ConfigData)ExtendedDrawers.CONFIG.get()).client().displayEmptyCount()) {
            amount = null;
        }
        if (slotState.isDuping) {
            amount = "\u221e";
        }
        this.renderSlot(slotState.item, amount, small, slotState.isHidden, icons, matrices, queue, cameraState, light, pos);
    }
}

