/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.CompactingDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.client.renderer.AbstractDrawerBlockEntityRenderer;
import io.github.mattidragon.extendeddrawers.client.renderer.state.CompactingDrawerRenderState;
import io.github.mattidragon.extendeddrawers.client.renderer.state.CompactingSlotRenderState;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10444;
import net.minecraft.class_1059;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2738;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CompactingDrawerBlockEntityRenderer
extends AbstractDrawerBlockEntityRenderer<CompactingDrawerBlockEntity, CompactingDrawerRenderState> {
    public CompactingDrawerBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public CompactingDrawerRenderState createRenderState() {
        return new CompactingDrawerRenderState();
    }

    public void updateRenderState(CompactingDrawerBlockEntity drawer, CompactingDrawerRenderState state, float tickProgress, class_243 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_11683.class_11792 crumblingOverlay) {
        CompactingDrawerStorage.Slot slot;
        super.method_74331(drawer, state, tickProgress, cameraPos, crumblingOverlay);
        state.isLocked = drawer.storage.isLocked();
        state.isVoiding = drawer.storage.isVoiding();
        state.isHidden = drawer.storage.isHidden();
        state.isDuping = drawer.storage.isDuping();
        state.upgrade = drawer.storage.getUpgrade();
        state.hasLimiter = drawer.storage.hasLimiter();
        CompactingDrawerBlock block = ModBlocks.COMPACTING_DRAWER;
        CompactingDrawerStorage.Slot[] activeSlots = drawer.storage.getActiveSlotArray();
        CompactingSlotRenderState slotState = state.slots[0];
        if (activeSlots.length >= 1) {
            slot = block.getSlot(drawer, block.getSlotIndex(drawer, new class_241(0.5f, 0.25f)));
            slotState.disabled = slot.isBlocked();
            slotState.amount = slot.getAmount();
            this.itemModelManager.method_65596(slotState.item, slot.getResource().toStack(), class_811.field_4317, drawer.method_10997(), null, drawer.method_11016().hashCode());
        } else {
            slotState.disabled = true;
            slotState.item.method_65605();
        }
        slotState = state.slots[1];
        if (activeSlots.length >= 2) {
            slot = block.getSlot(drawer, block.getSlotIndex(drawer, new class_241(0.75f, 0.75f)));
            slotState.disabled = slot.isBlocked();
            slotState.amount = slot.getAmount();
            this.itemModelManager.method_65596(slotState.item, slot.getResource().toStack(), class_811.field_4317, drawer.method_10997(), null, drawer.method_11016().hashCode());
        } else {
            slotState.disabled = true;
            slotState.item.method_65605();
        }
        slotState = state.slots[2];
        if (activeSlots.length >= 3) {
            slot = block.getSlot(drawer, block.getSlotIndex(drawer, new class_241(0.25f, 0.75f)));
            slotState.disabled = slot.isBlocked();
            slotState.amount = slot.getAmount();
            this.itemModelManager.method_65596(slotState.item, slot.getResource().toStack(), class_811.field_4317, drawer.method_10997(), null, drawer.method_11016().hashCode());
        } else {
            slotState.disabled = true;
            slotState.item.method_65605();
        }
    }

    public void render(CompactingDrawerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        class_2350 horizontalDir = (class_2350)state.field_62674.method_11654(StorageDrawerBlock.FACING);
        class_2738 face = (class_2738)state.field_62674.method_11654(StorageDrawerBlock.FACE);
        matrices.method_22903();
        this.alignMatrices(matrices, horizontalDir, face);
        int light = state.field_62676;
        if (state.isHidden) {
            this.renderHiddenOverlay(false, light, matrices, queue);
            matrices.method_22909();
            return;
        }
        this.renderIcons(state, matrices, light, queue, cameraState);
        matrices.method_22904(0.0, 0.25, 0.0);
        this.renderSlot(state, state.slots[0], matrices, light, queue, cameraState);
        matrices.method_22904(0.25, -0.5, 0.0);
        this.renderSlot(state, state.slots[1], matrices, light, queue, cameraState);
        matrices.method_22904(-0.5, 0.0, 0.0);
        this.renderSlot(state, state.slots[2], matrices, light, queue, cameraState);
        matrices.method_22909();
    }

    public int method_33893() {
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        return Math.max(config.iconRenderDistance(), Math.max(config.textRenderDistance(), config.itemRenderDistance()));
    }

    private void renderIcons(CompactingDrawerRenderState state, class_4587 matrices, int light, class_11659 queue, class_12075 cameraState) {
        class_243 playerPos;
        ArrayList<class_4730> icons = new ArrayList<class_4730>();
        ClientCategory.IconGroup config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().icons();
        class_2960 blockAtlas = class_1059.field_5275;
        if (state.isLocked) {
            icons.add(new class_4730(blockAtlas, config.lockedIcon()));
        }
        if (state.isVoiding) {
            icons.add(new class_4730(blockAtlas, config.voidingIcon()));
        }
        if (state.isHidden) {
            icons.add(new class_4730(blockAtlas, config.hiddenIcon()));
        }
        if (state.isDuping) {
            icons.add(new class_4730(blockAtlas, config.dupingIcon()));
        }
        if (state.upgrade != null) {
            icons.add(new class_4730(blockAtlas, state.upgrade.sprite));
        }
        if (state.hasLimiter) {
            icons.add(new class_4730(blockAtlas, ExtendedDrawers.id("item/limiter")));
        }
        if (state.field_62673.method_19769((class_2374)(playerPos = cameraState.field_63080), (double)((ConfigData)ExtendedDrawers.CONFIG.get()).client().iconRenderDistance())) {
            matrices.method_22903();
            matrices.method_22904(0.0, 0.25, 0.0);
            this.renderIcons(icons, true, light, matrices, queue);
            matrices.method_22909();
        }
    }

    private void renderSlot(CompactingDrawerRenderState state, CompactingSlotRenderState slot, class_4587 matrices, int light, class_11659 queue, class_12075 cameraState) {
        if (slot.disabled) {
            return;
        }
        @Nullable String amount = String.valueOf(slot.amount);
        if (slot.amount == 0L && !((ConfigData)ExtendedDrawers.CONFIG.get()).client().displayEmptyCount()) {
            amount = null;
        }
        if (state.isDuping) {
            amount = "\u221e";
        }
        class_10444 item = slot.item;
        this.renderSlot(item, amount, true, false, List.of(), matrices, queue, cameraState, light, state.field_62673);
    }
}

