/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.client.renderer;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.config.category.ClientCategory;
import java.util.Collection;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11701;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractDrawerBlockEntityRenderer<T extends class_2586, S extends class_11954>
implements class_827<T, S> {
    private static final Quaternionf ITEM_LIGHT_ROTATION_3D = class_7833.field_40714.rotationDegrees(-15.0f).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(15.0f));
    private static final Quaternionf ITEM_LIGHT_ROTATION_FLAT = class_7833.field_40714.rotationDegrees(-45.0f);
    private final class_327 textRenderer;
    private final class_11701 spriteHolder;
    protected final class_10442 itemModelManager;

    public AbstractDrawerBlockEntityRenderer(class_5614.class_5615 context) {
        this.textRenderer = context.comp_4540();
        this.spriteHolder = context.comp_4541();
        this.itemModelManager = context.comp_4536();
    }

    public void method_74331(T blockEntity, S state, float tickProgress, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        super.method_74331(blockEntity, state, tickProgress, cameraPos, crumblingOverlay);
        class_2350 dir = StorageDrawerBlock.getFront(blockEntity.method_11010());
        ((class_11954)state).field_62676 = class_761.method_23794((class_1920)((class_1920)Objects.requireNonNull(blockEntity.method_10997())), (class_2338)blockEntity.method_11016().method_10093(dir));
    }

    public void renderSlot(class_10444 item, String amount, boolean small, boolean hidden, Collection<class_4730> icons, class_4587 matrices, class_11659 queue, class_12075 cameraState, int light, class_2338 pos) {
        class_243 playerPos = cameraState.field_63078;
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        if (hidden) {
            this.renderHiddenOverlay(small, light, matrices, queue);
            return;
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.textRenderDistance()) && amount != null) {
            this.renderText(amount, small, light, matrices, queue);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.iconRenderDistance())) {
            this.renderIcons(icons, small, light, matrices, queue);
        }
        if (pos.method_19769((class_2374)playerPos, (double)config.itemRenderDistance())) {
            this.renderItem(item, small, light, matrices, queue);
        }
    }

    protected void renderHiddenOverlay(boolean small, int light, class_4587 matrices, class_11659 queue) {
        matrices.method_22903();
        if (small) {
            matrices.method_22905(0.5f, 0.5f, 1.0f);
        }
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
        matrices.method_22904(-0.5, -1.0, -0.5);
        class_4730 spriteId = new class_4730(class_1059.field_5275, ExtendedDrawers.id("block/drawer_hidden_overlay"));
        class_1058 sprite = this.spriteHolder.method_73030(spriteId);
        queue.method_73483(matrices, class_1921.method_23581(), (matricesEntry, vertexConsumer) -> this.renderIcon(sprite, light, matricesEntry, vertexConsumer));
        matrices.method_22909();
    }

    public final boolean shouldRender(T drawer, class_2350 facing) {
        class_1937 world = drawer.method_10997();
        if (world == null) {
            return false;
        }
        class_2338 pos = drawer.method_11016();
        class_2680 state = drawer.method_11010();
        return class_2248.method_9607((class_2680)state, (class_2680)world.method_8320(pos.method_10093(facing)), (class_2350)facing);
    }

    public void renderIcons(Collection<class_4730> icons, boolean small, int light, class_4587 matrices, class_11659 queue) {
        double increment = 1.0 / ((double)icons.size() + 1.0);
        matrices.method_22903();
        if (small) {
            matrices.method_22905(0.5f, 0.5f, 1.0f);
        }
        matrices.method_22904(-0.5, 0.0, 0.0);
        for (class_4730 icon : icons) {
            matrices.method_22904(increment, 0.0, 0.001);
            matrices.method_22903();
            matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            matrices.method_22904(-0.125, -0.24, -0.5);
            matrices.method_22905(0.25f, 0.25f, 0.25f);
            class_1058 sprite = this.spriteHolder.method_73030(icon);
            queue.method_73483(matrices, class_1921.method_23581(), (matricesEntry, vertexConsumer) -> this.renderIcon(sprite, light, matricesEntry, vertexConsumer));
            matrices.method_22909();
        }
        matrices.method_22909();
    }

    private void renderIcon(class_1058 sprite, int light, class_4587.class_4665 matrixEntry, class_4588 consumer) {
        int overlay = class_4608.field_21444;
        float minU = sprite.method_4594();
        float maxU = sprite.method_4577();
        float minV = sprite.method_4593();
        float maxV = sprite.method_4575();
        consumer.method_56824(matrixEntry, 0.0f, 1.0f, 0.0f).method_22913(minU, minV).method_39415(-1).method_60803(light).method_22922(overlay).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        consumer.method_56824(matrixEntry, 0.0f, 1.0f, 1.0f).method_22913(minU, maxV).method_39415(-1).method_60803(light).method_22922(overlay).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        consumer.method_56824(matrixEntry, 1.0f, 1.0f, 1.0f).method_22913(maxU, maxV).method_39415(-1).method_60803(light).method_22922(overlay).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
        consumer.method_56824(matrixEntry, 1.0f, 1.0f, 0.0f).method_22913(maxU, minV).method_39415(-1).method_60803(light).method_22922(overlay).method_60831(matrixEntry, 0.0f, 1.0f, 0.0f);
    }

    public void renderItem(class_10444 item, boolean small, int light, class_4587 matrices, class_11659 queue) {
        if (item.method_65606()) {
            return;
        }
        float itemScale = ((ConfigData)ExtendedDrawers.CONFIG.get()).client().layout().itemScale(small);
        matrices.method_22903();
        matrices.method_22905(itemScale, itemScale, 1.0f);
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        matrices.method_23760().method_23761().mul((Matrix4fc)new Matrix4f().scale(1.0f, 1.0f, 0.01f));
        item.method_65604(matrices, queue, light, class_4608.field_21444, 0);
        matrices.method_22909();
    }

    public void renderText(String amount, boolean small, int light, class_4587 matrices, class_11659 queue) {
        ClientCategory config = ((ConfigData)ExtendedDrawers.CONFIG.get()).client();
        matrices.method_22903();
        matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(180.0f));
        if (small) {
            matrices.method_22904(0.0, 0.25, -0.01);
        } else {
            matrices.method_22904(0.0, 0.5, -0.01);
        }
        matrices.method_22905(config.layout().textScale(small), config.layout().textScale(small), 1.0f);
        matrices.method_22904(0.0, (double)(config.layout().textOffset() / -4.0f), -0.01);
        matrices.method_22905(0.02f, 0.02f, 0.02f);
        queue.method_73478(matrices, (float)(-this.textRenderer.method_1727(amount)) / 2.0f, 0.0f, class_2561.method_43470((String)amount).method_30937(), false, class_327.class_6415.field_33993, light, -1, 0, 0);
        matrices.method_22909();
    }

    protected void alignMatrices(class_4587 matrices, class_2350 dir, class_2738 face) {
        Vector3f pos = switch (face) {
            case class_2738.field_12475 -> class_2350.field_11036.method_23955();
            case class_2738.field_12473 -> class_2350.field_11033.method_23955();
            default -> dir.method_23955();
        };
        matrices.method_22904((double)(pos.x / 2.0f) + 0.5, (double)(pos.y / 2.0f) + 0.5, (double)(pos.z / 2.0f) + 0.5);
        matrices.method_23760().method_23761().rotate((Quaternionfc)dir.method_23224());
        switch (face) {
            case field_12475: {
                matrices.method_23760().method_23761().rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case field_12473: {
                matrices.method_23760().method_23761().rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
            }
        }
        matrices.method_23760().method_23761().rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
        matrices.method_22904(0.0, 0.0, 0.01);
    }
}

