/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block.entity;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.network.cache.NetworkStorageCache;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.Iterator;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.FilteringStorage;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class ShadowDrawerBlockEntity
extends class_2586 {
    public static final long INFINITE_COUNT_MARKER = -2L;
    public ItemVariant item = ItemVariant.blank();
    public long countCache = -1L;
    private boolean hidden = false;

    public ShadowDrawerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.SHADOW_DRAWER_BLOCK_ENTITY, pos, state);
    }

    private static Storage<ItemVariant> createStorage(class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof ShadowDrawerBlockEntity)) {
            throw new IllegalStateException();
        }
        ShadowDrawerBlockEntity shadowDrawer = (ShadowDrawerBlockEntity)class_25862;
        ShadowDrawerBlockEntity shadowDrawerBlockEntity = shadowDrawer;
        Objects.requireNonNull(shadowDrawerBlockEntity);
        return shadowDrawerBlockEntity.new ShadowDrawerStorage((Storage<ItemVariant>)NetworkStorageCache.get(world, pos));
    }

    public void recalculateContents() {
        if (this.field_11863 == null) {
            return;
        }
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            if (!this.item.isBlank()) {
                CombinedStorage<ItemVariant, DrawerStorage> storage = NetworkStorageCache.get(world, this.field_11867);
                long amount = 0L;
                block0: for (DrawerStorage slot : storage.parts) {
                    Iterator iterator = slot.iterator();
                    while (iterator.hasNext()) {
                        StorageView view = (StorageView)iterator.next();
                        if (slot.isDuping()) {
                            amount = -2L;
                            break block0;
                        }
                        if (!((ItemVariant)view.getResource()).equals((Object)this.item)) continue;
                        amount += view.getAmount();
                    }
                }
                this.countCache = amount;
            }
        }
        class_2680 state = this.method_11010();
        this.field_11863.method_8413(this.field_11867, state, state, 2);
        this.field_11863.method_8455(this.field_11867, state.method_26204());
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), ExtendedDrawers.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registries);
            this.method_11007((class_11372)view);
            view.method_71466("count", this.countCache);
            class_2487 class_24872 = view.method_71475();
            return class_24872;
        }
    }

    protected void method_11014(class_11368 view) {
        this.countCache = view.method_71425("count", this.countCache);
        this.item = view.method_71426("item", ItemVariant.CODEC).orElseGet(ItemVariant::blank);
        this.hidden = view.method_71433("hidden", false);
    }

    protected void method_11007(class_11372 view) {
        view.method_71468("item", ItemVariant.CODEC, (Object)this.item);
        view.method_71472("hidden", this.hidden);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
        class_2680 state = this.method_11010();
        if (this.field_11863 != null) {
            this.field_11863.method_8413(this.field_11867, state, state, 2);
        }
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((drawer, dir) -> {
            Storage<ItemVariant> storage;
            class_1937 patt0$temp = drawer.field_11863;
            if (patt0$temp instanceof class_3218) {
                class_3218 serverWorld = (class_3218)patt0$temp;
                storage = ShadowDrawerBlockEntity.createStorage(serverWorld, drawer.field_11867);
            } else {
                storage = Storage.empty();
            }
            return storage;
        }, ModBlocks.SHADOW_DRAWER_BLOCK_ENTITY);
    }

    public class ShadowDrawerStorage
    extends FilteringStorage<ItemVariant> {
        public ShadowDrawerStorage(Storage<ItemVariant> backingStorage) {
            super(backingStorage);
        }

        protected boolean canInsert(ItemVariant resource) {
            return resource.isBlank() || resource.equals((Object)ShadowDrawerBlockEntity.this.item);
        }

        protected boolean canExtract(ItemVariant resource) {
            return resource.equals((Object)ShadowDrawerBlockEntity.this.item);
        }
    }
}

