/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block.entity;

import io.github.mattidragon.extendeddrawers.ExtendedDrawers;
import io.github.mattidragon.extendeddrawers.block.entity.StorageDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.component.DrawerSlotComponent;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.misc.ItemUtils;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.registry.ModDataComponents;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.DrawerStorage;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.class_9323;
import net.minecraft.class_9473;

public class CompactingDrawerBlockEntity
extends StorageDrawerBlockEntity {
    public final CompactingDrawerStorage storage = new CompactingDrawerStorage(this);

    public CompactingDrawerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlocks.COMPACTING_DRAWER_BLOCK_ENTITY, pos, state);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71402(), ExtendedDrawers.LOGGER);){
            class_11362 view = class_11362.method_71459((class_8942)logging, (class_7225.class_7874)registries);
            this.method_11007((class_11372)view);
            class_2487 class_24872 = view.method_71475();
            return class_24872;
        }
    }

    protected void method_57568(class_9473 components) {
        DrawerSlotComponent component = (DrawerSlotComponent)components.method_58694(ModDataComponents.COMPACTING_DRAWER_CONTENTS);
        if (component != null) {
            this.storage.readComponent(component);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        componentMapBuilder.method_57840(ModDataComponents.COMPACTING_DRAWER_CONTENTS, (Object)this.storage.toComponent());
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        if (!((ConfigData)ExtendedDrawers.CONFIG.get()).misc().drawersDropContentsOnBreak()) {
            return;
        }
        CompactingDrawerStorage.Slot[] slots = this.storage.getSlotArray();
        long amount = this.storage.getTrueAmount();
        for (int i = slots.length - 1; i >= 0; --i) {
            CompactingDrawerStorage.Slot slot = slots[i];
            if (slot.isBlocked()) continue;
            long toDrop = amount / slot.getCompression();
            ItemUtils.offerOrDropStacks(this.field_11863, pos, null, null, slot.getResource(), toDrop);
            amount -= toDrop * slot.getCompression();
        }
    }

    @Override
    public Stream<? extends DrawerStorage> streamStorages() {
        return Stream.of(this.storage);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.getUpgrade() == null && this.storage.isBlank() && !this.storage.isHidden() && !this.storage.isLocked() && !this.storage.isVoiding();
    }

    public void method_31662(class_1937 world) {
        super.method_31662(world);
        this.storage.updateSlots();
    }

    protected void method_11014(class_11368 view) {
        view.method_71420("storage").ifPresent(this.storage::readData);
    }

    public void method_11007(class_11372 view) {
        this.storage.writeData(view.method_71461("storage"));
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((drawer, dir) -> drawer.storage, ModBlocks.COMPACTING_DRAWER_BLOCK_ENTITY);
    }
}

