/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers.block;

import io.github.mattidragon.extendeddrawers.block.base.StorageDrawerBlock;
import io.github.mattidragon.extendeddrawers.block.entity.CompactingDrawerBlockEntity;
import io.github.mattidragon.extendeddrawers.network.node.CompactingDrawerBlockNode;
import io.github.mattidragon.extendeddrawers.network.node.DrawerNetworkBlockNode;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.storage.CompactingDrawerStorage;
import io.github.mattidragon.extendeddrawers.storage.ModifierAccess;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4970;

public class CompactingDrawerBlock
extends StorageDrawerBlock<CompactingDrawerBlockEntity> {
    public CompactingDrawerBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    protected class_2591<CompactingDrawerBlockEntity> getType() {
        return ModBlocks.COMPACTING_DRAWER_BLOCK_ENTITY;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        CompactingDrawerBlockEntity drawer = (CompactingDrawerBlockEntity)this.getBlockEntity(world, pos);
        if (drawer == null) {
            return 0;
        }
        return StorageUtil.calculateComparatorOutput((Storage)drawer.storage);
    }

    @Override
    protected ModifierAccess getModifierAccess(CompactingDrawerBlockEntity drawer, class_241 facePos) {
        return drawer.storage;
    }

    @Override
    public int getSlotIndex(CompactingDrawerBlockEntity drawer, class_241 facePos) {
        int slotCount = drawer.storage.getActiveSlotCount();
        int topSlot = switch (slotCount) {
            case 1 -> 0;
            case 2 -> 0;
            case 3 -> 1;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        int leftSlot = switch (slotCount) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 0;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        int rightSlot = switch (slotCount) {
            case 1 -> 2;
            case 2 -> 1;
            case 3 -> 2;
            default -> throw new IllegalStateException("Illegal slot count");
        };
        if (facePos.field_1342 < 0.5f) {
            return topSlot;
        }
        if (facePos.field_1343 < 0.5f) {
            return leftSlot;
        }
        return rightSlot;
    }

    public CompactingDrawerStorage.Slot getSlot(CompactingDrawerBlockEntity drawer, int slot) {
        return drawer.storage.getSlot(slot);
    }

    @Override
    public DrawerNetworkBlockNode getNode() {
        return CompactingDrawerBlockNode.INSTANCE;
    }
}

