/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.extendeddrawers;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import io.github.mattidragon.configloader.api.ConfigManager;
import io.github.mattidragon.extendeddrawers.config.ConfigData;
import io.github.mattidragon.extendeddrawers.misc.DrawerCacheCommand;
import io.github.mattidragon.extendeddrawers.misc.ShiftAccess;
import io.github.mattidragon.extendeddrawers.network.NetworkRegistry;
import io.github.mattidragon.extendeddrawers.networking.CompressionRecipeSyncPayload;
import io.github.mattidragon.extendeddrawers.networking.SetLimiterLimitPayload;
import io.github.mattidragon.extendeddrawers.registry.ModBlocks;
import io.github.mattidragon.extendeddrawers.registry.ModDataComponents;
import io.github.mattidragon.extendeddrawers.registry.ModItems;
import io.github.mattidragon.extendeddrawers.registry.ModRecipes;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedDrawers
implements ModInitializer {
    public static final String MOD_ID = "extended_drawers";
    public static final ModContainer MOD_CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("extended_drawers").orElseThrow();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"extended_drawers");
    public static final ConfigManager<ConfigData> CONFIG = ConfigManager.create(ConfigData.CODEC, (Object)ConfigData.DEFAULT, (String)"extended_drawers");
    public static ShiftAccess SHIFT_ACCESS = () -> false;

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        ModBlocks.register();
        ModDataComponents.register();
        ModItems.register();
        ModRecipes.register();
        this.registerItemGroup();
        ExtendedDrawers.registerCommand();
        NetworkRegistry.register();
        CompressionRecipeSyncPayload.register();
        SetLimiterLimitPayload.register();
        DrawerCacheCommand.register();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ExtendedDrawers.id("alt"), (ModContainer)MOD_CONTAINER, (class_2561)class_2561.method_43471((String)"resourcepack.extended_drawers.alt"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)ExtendedDrawers.id("dev"), (ModContainer)MOD_CONTAINER, (class_2561)class_2561.method_43471((String)"resourcepack.extended_drawers.programmer_art"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
    }

    private static void registerCommand() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder root = (LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).requires(source -> source.method_9259(2));
            root.then(class_2170.method_9247((String)"reload").executes(context -> {
                Optional error = CONFIG.reload();
                if (error.isEmpty()) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.extended_drawers.reload.success"), true);
                    return 1;
                }
                class_5250 message = class_2561.method_43471((String)"command.extended_drawers.reload.fail").method_27696(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)((RuntimeException)error.get()).toString()))));
                ((class_2168)context.getSource()).method_9213((class_2561)message);
                LOGGER.error("Failed to reload config", (Throwable)error.get());
                return 0;
            }));
            dispatcher.register(root);
        });
    }

    private void registerItemGroup() {
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)ExtendedDrawers.id("main"), (Object)FabricItemGroup.builder().method_47320(() -> ((class_1792)ModItems.SHADOW_DRAWER).method_7854()).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.extended_drawers.main")).method_47317((context, entries) -> {
            entries.method_45421((class_1935)ModBlocks.SINGLE_DRAWER);
            entries.method_45421((class_1935)ModBlocks.DOUBLE_DRAWER);
            entries.method_45421((class_1935)ModBlocks.QUAD_DRAWER);
            entries.method_45421((class_1935)ModBlocks.CONNECTOR);
            entries.method_45421((class_1935)ModBlocks.SHADOW_DRAWER);
            entries.method_45421((class_1935)ModBlocks.COMPACTING_DRAWER);
            entries.method_45421((class_1935)ModBlocks.ACCESS_POINT);
            entries.method_45421((class_1935)ModItems.T1_UPGRADE);
            entries.method_45421((class_1935)ModItems.T2_UPGRADE);
            entries.method_45421((class_1935)ModItems.T3_UPGRADE);
            entries.method_45421((class_1935)ModItems.T4_UPGRADE);
            entries.method_45421((class_1935)ModItems.CREATIVE_UPGRADE);
            entries.method_45421((class_1935)ModItems.UPGRADE_FRAME);
            entries.method_45421((class_1935)ModItems.LOCK);
            entries.method_45421((class_1935)ModItems.LIMITER);
            entries.method_45421((class_1935)ModItems.DUPE_WAND);
        }).method_47324());
    }
}

