/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block.entity;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.lunade.copper.block.CopperFittingBlock;
import net.lunade.copper.block.CopperPipeBlock;
import net.lunade.copper.block.entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.block.entity.CopperFittingBlockEntity;
import net.lunade.copper.block.entity.data.TransferablePipeDataHandler;
import net.lunade.copper.block.entity.leaking.LeakingPipeManager;
import net.lunade.copper.block.properties.PipeFluid;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.CopperPipeDispenseBehaviors;
import net.lunade.copper.registry.PipeMovementRestrictions;
import net.lunade.copper.registry.SimpleCopperPipesBlockEntityTypes;
import net.lunade.copper.registry.SimpleCopperPipesSoundEvents;
import net.lunade.copper.tag.SimpleCopperPipesBlockTags;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3922;
import net.minecraft.class_4538;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8514;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopperPipeBlockEntity
extends AbstractSimpleCopperBlockEntity
implements class_5714.class_8513<class_8514.class_8516>,
class_8514 {
    private static final int VIBRATION_RANGE = 8;
    private static final int MAX_TRANSFER_AMOUNT = 1;
    private final class_8514.class_8516 vibrationListener;
    private final class_8514.class_5719 vibrationUser = this.createVibrationUser();
    public int transferCooldown;
    public int dispenseCooldown;
    public int noteBlockCooldown = 0;
    public boolean canDispense;
    public DispenseType dispenseType;
    public boolean canAcceptGameEvents;
    public class_2338 inputGameEventPos;
    public class_243 gameEventNbtVec3;
    private class_8514.class_8515 vibrationData = new class_8514.class_8515();

    public CopperPipeBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SimpleCopperPipesBlockEntityTypes.COPPER_PIPE, blockPos, blockState, AbstractSimpleCopperBlockEntity.MoveType.FROM_PIPE);
        this.vibrationListener = new class_8514.class_8516((class_8514)this);
    }

    public static boolean canTransfer(class_1937 level, class_2338 pos, boolean to, @NotNull CopperPipeBlockEntity copperPipe, @Nullable Storage<ItemVariant> inventory, @Nullable Storage<ItemVariant> pipeInventory) {
        class_2586 blockEntity;
        if (copperPipe.transferCooldown > 0) {
            return false;
        }
        boolean transferApiCheck = true;
        boolean usingTransferApi = false;
        if (inventory != null) {
            usingTransferApi = true;
            boolean bl = to ? inventory.supportsInsertion() && (pipeInventory == null || pipeInventory.supportsExtraction()) : (transferApiCheck = inventory.supportsExtraction() && (pipeInventory == null || pipeInventory.supportsInsertion()));
        }
        if ((blockEntity = level.method_8321(pos)) != null) {
            PipeMovementRestrictions.CanTakeFrom<class_2586> canTake;
            PipeMovementRestrictions.CanTransferTo<class_2586> canTransfer;
            if (blockEntity instanceof CopperPipeBlockEntity) {
                CopperPipeBlockEntity pipe = (CopperPipeBlockEntity)blockEntity;
                return (to || pipe.transferCooldown <= 0) && transferApiCheck;
            }
            if (blockEntity instanceof CopperFittingBlockEntity) {
                return false;
            }
            if (to ? (canTransfer = PipeMovementRestrictions.getCanTransferTo(blockEntity)) != null : (canTake = PipeMovementRestrictions.getCanTakeFrom(blockEntity)) != null) {
                return canTransfer.canTransfer((class_3218)level, pos, level.method_8320(pos), copperPipe, blockEntity) && transferApiCheck;
            }
        }
        return usingTransferApi && transferApiCheck;
    }

    public static long addItem(ItemVariant resource, @NotNull Storage<ItemVariant> inventory, Transaction transaction) {
        if (inventory.supportsInsertion()) {
            return inventory.insert((Object)resource, 1L, (TransactionContext)transaction);
        }
        return 0L;
    }

    public static void spawnItem(class_1937 level, class_1799 stack, int shotPower, @NotNull class_2350 direction, @NotNull class_243 pos, @NotNull class_2350 facing) {
        double x = pos.method_10216();
        double y = pos.method_10214() - (direction.method_10166() == class_2350.class_2351.field_11052 ? 0.125 : 0.15625);
        double z = pos.method_10215();
        class_2350.class_2351 axis = facing.method_10166();
        double xd = axis == class_2350.class_2351.field_11048 ? (double)(shotPower * facing.method_10148()) * 0.1 : 0.0;
        double yd = axis == class_2350.class_2351.field_11052 ? (double)(shotPower * facing.method_10164()) * 0.1 : 0.0;
        double zd = axis == class_2350.class_2351.field_11051 ? (double)(shotPower * facing.method_10165()) * 0.1 : 0.0;
        class_1542 itemEntity = new class_1542(level, x, y, z, stack);
        itemEntity.method_18800(xd, yd, zd);
        level.method_8649((class_1297)itemEntity);
    }

    public static void setCooldown(@NotNull class_1937 level, class_2338 blockPos) {
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof CopperPipeBlockEntity) {
            CopperPipeBlockEntity pipe = (CopperPipeBlockEntity)class_25862;
            pipe.setCooldown(level.method_8320(blockPos));
        }
    }

    public static Storage<ItemVariant> getStorageAt(class_1937 level, class_2338 blockPos, class_2350 direction) {
        return (Storage)ItemStorage.SIDED.find(level, blockPos, level.method_8320(blockPos), level.method_8321(blockPos), (Object)direction);
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.method_54873(null);
        if (itemStack != null) {
            this.method_11282().set(i, (Object)itemStack);
            if (itemStack.method_7947() > this.method_5444()) {
                itemStack.method_7939(this.method_5444());
            }
        }
    }

    @Override
    public void serverTick(@NotNull class_1937 level, class_2338 blockPos, class_2680 state, SimpleCopperPipesConfig config) {
        if (level.method_8608()) {
            return;
        }
        class_8514.class_8517.method_51406((class_1937)this.field_11863, (class_8514.class_8515)this.method_51298(), (class_8514.class_5719)this.createVibrationUser());
        super.serverTick(level, blockPos, state, config);
        if (this.noteBlockCooldown > 0) {
            --this.noteBlockCooldown;
        }
        if (this.dispenseCooldown > 0) {
            --this.dispenseCooldown;
        } else {
            this.dispense((class_3218)level, blockPos, state, config);
            int cooldown = 0;
            class_2248 class_22482 = level.method_8320(blockPos.method_10093(((class_2350)state.method_11654(CopperPipeBlock.FACING)).method_10153())).method_26204();
            if (class_22482 instanceof CopperFittingBlock) {
                CopperFittingBlock fitting = (CopperFittingBlock)class_22482;
                cooldown = fitting.getCooldown();
            } else {
                class_2248 class_22483 = state.method_26204();
                if (class_22483 instanceof CopperPipeBlock) {
                    CopperPipeBlock pipe = (CopperPipeBlock)class_22483;
                    cooldown = class_3532.method_15357((double)((double)pipe.getCooldown() * 0.5));
                }
            }
            this.dispenseCooldown = cooldown;
        }
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        } else {
            this.pipeMove(level, blockPos, state, config);
        }
        if (state.method_11654(CopperPipeBlock.FLUID) == PipeFluid.WATER && state.method_11654(CopperPipeBlock.FACING) != class_2350.field_11036) {
            LeakingPipeManager.addPos(level, blockPos);
        }
    }

    @Override
    public void updateBlockEntityValues(class_4538 level, class_2338 pos, @NotNull class_2680 state, SimpleCopperPipesConfig config) {
        boolean canWaterAndLava;
        class_265 facingShape;
        class_265 pipeExitShape;
        class_265 pipeAndFacingShape;
        boolean checkExitSupportShape;
        if (!(state.method_26204() instanceof CopperPipeBlock)) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        class_2338 facingPos = pos.method_10093(facing);
        class_2680 facingState = level.method_8320(facingPos);
        class_2350 opposite = facing.method_10153();
        class_2338 oppositePos = pos.method_10093(opposite);
        class_2680 oppositeState = level.method_8320(oppositePos);
        class_3610 oppositeFluidState = oppositeState.method_26227();
        class_2248 oppositeBlock = oppositeState.method_26204();
        class_265 pipeShape = state.method_26222((class_1922)level, pos);
        boolean isEntrySupported = (Boolean)state.method_11654((class_2769)CopperPipeBlock.BACK_CONNECTED);
        if (!isEntrySupported) {
            boolean checkEntrySupportShape = oppositeState.method_26164(SimpleCopperPipesBlockTags.COPPER_PIPE_CHECKS_SUPPORT_SHAPE);
            if (checkEntrySupportShape) {
                class_265 pipeEntryShape = pipeShape.method_20538(opposite);
                class_265 supportingShape = oppositeState.method_26222((class_1922)level, oppositePos).method_20538(facing);
                class_265 pipeAndSupportShape = class_259.method_1072((class_265)pipeEntryShape, (class_265)supportingShape, (class_247)class_247.field_16896);
                isEntrySupported = pipeAndSupportShape.method_1090().equals(pipeEntryShape.method_1090());
            } else {
                boolean bl = isEntrySupported = !oppositeState.method_26220((class_1922)level, oppositePos).method_1110();
            }
        }
        boolean isExitBlocked = (checkExitSupportShape = facingState.method_26164(SimpleCopperPipesBlockTags.COPPER_PIPE_CHECKS_SUPPORT_SHAPE)) ? !(pipeAndFacingShape = class_259.method_1072((class_265)(pipeExitShape = pipeShape.method_20538(facing)), (class_265)(facingShape = facingState.method_26222((class_1922)level, facingPos).method_20538(opposite)), (class_247)class_247.field_16896)).method_1110() : !facingState.method_26220((class_1922)level, facingPos).method_1110();
        boolean bl = this.canDispense = isEntrySupported && !isExitBlocked;
        this.dispenseType = oppositeBlock == class_2246.field_10228 ? DispenseType.DROPPER : (oppositeBlock == class_2246.field_10200 ? DispenseType.DISPENSER : DispenseType.NONE);
        this.canAcceptGameEvents = !isEntrySupported;
        this.canWater = config.carryWater && (oppositeFluidState.method_15767(class_3486.field_15517) || (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false || (Boolean)oppositeState.method_61767((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)) != false);
        this.canLava = config.carryLava && oppositeFluidState.method_15767(class_3486.field_15518);
        boolean bl2 = canWaterAndLava = this.canWater && this.canLava;
        boolean bl3 = config.carrySmoke && (oppositeBlock instanceof class_3922 && !this.canWater && !this.canLava ? (Boolean)oppositeState.method_11654((class_2769)class_2741.field_12548) != false : canWaterAndLava) ? true : (this.canSmoke = false);
        if (canWaterAndLava) {
            this.canWater = false;
            this.canLava = false;
        }
    }

    public void pipeMove(class_1937 level, class_2338 pos, @NotNull class_2680 state, SimpleCopperPipesConfig config) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        boolean movedOut = this.moveOut(level, pos, facing);
        int movedIn = this.moveIn(level, pos, state, facing);
        if (movedOut || movedIn >= 2) {
            this.setCooldown(state);
            CopperPipeBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
            if (movedIn == 3) {
                if (!config.suctionSounds) {
                    return;
                }
                level.method_8396(null, pos, SimpleCopperPipesSoundEvents.ITEM_IN, class_3419.field_15245, 0.2f, level.field_9229.method_43057() * 0.25f + 0.8f);
            }
        }
    }

    private int moveIn(class_1937 level, @NotNull class_2338 pos, class_2680 state, @NotNull class_2350 facing) {
        class_2350 facingAway = facing.method_10153();
        class_2338 facingAwayPos = pos.method_10093(facingAway);
        Storage<ItemVariant> inventory = CopperPipeBlockEntity.getStorageAt(level, facingAwayPos, facing);
        Storage<ItemVariant> pipeInventory = CopperPipeBlockEntity.getStorageAt(level, pos, facingAway);
        if (inventory == null || pipeInventory == null || !CopperPipeBlockEntity.canTransfer(level, facingAwayPos, false, this, inventory, pipeInventory)) {
            return 0;
        }
        for (StorageView storageView : inventory) {
            long inserted;
            if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
            Transaction transaction = Transaction.openOuter();
            ItemVariant resource = (ItemVariant)storageView.getResource();
            long extracted = inventory.extract((Object)resource, 1L, (TransactionContext)transaction);
            if (extracted > 0L && (inserted = CopperPipeBlockEntity.addItem(resource, pipeInventory, transaction)) > 0L) {
                transaction.commit();
                if (state.method_26164(SimpleCopperPipesBlockTags.SILENT_COPPER_PIPES)) {
                    return 2;
                }
                class_2248 block = level.method_8320(facingAwayPos).method_26204();
                if (!(block instanceof CopperPipeBlock) && !(block instanceof CopperFittingBlock)) {
                    return 3;
                }
                return 2;
            }
            transaction.close();
        }
        return 0;
    }

    private boolean moveOut(class_1937 level, @NotNull class_2338 pos, class_2350 facing) {
        boolean canMove;
        class_2338 facingPos = pos.method_10093(facing);
        Storage<ItemVariant> inventory = CopperPipeBlockEntity.getStorageAt(level, facingPos, facing.method_10153());
        Storage<ItemVariant> pipeInventory = CopperPipeBlockEntity.getStorageAt(level, pos, facing);
        if (inventory == null || pipeInventory == null || !CopperPipeBlockEntity.canTransfer(level, facingPos, true, this, inventory, pipeInventory)) {
            return false;
        }
        class_2680 facingState = level.method_8320(facingPos);
        boolean bl = canMove = !(facingState.method_26204() instanceof CopperPipeBlock) || facingState.method_11654(CopperPipeBlock.FACING) != facing;
        if (!canMove) {
            return false;
        }
        for (StorageView storageView : pipeInventory) {
            long extracted;
            if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
            Transaction transaction = Transaction.openOuter();
            ItemVariant resource = (ItemVariant)storageView.getResource();
            long inserted = inventory.insert((Object)resource, 1L, (TransactionContext)transaction);
            if (inserted > 0L && (extracted = pipeInventory.extract((Object)resource, 1L, (TransactionContext)transaction)) > 0L) {
                transaction.commit();
                return true;
            }
            transaction.close();
        }
        return false;
    }

    private boolean dispense(class_3218 level, class_2338 pos, @NotNull class_2680 state, SimpleCopperPipesConfig config) {
        class_1799 shotItem;
        if (!this.canDispense) {
            return false;
        }
        int slot = this.chooseNonEmptySlot(level.field_9229);
        if (slot < 0) {
            return false;
        }
        class_1799 stack = this.method_5438(slot);
        if (stack.method_7960()) {
            return false;
        }
        int shotPower = 4;
        if (this.dispenseType == DispenseType.DROPPER) {
            shotPower = 10;
            if (config.dispenseSounds) {
                level.method_8396(null, pos, SimpleCopperPipesSoundEvents.LAUNCH, class_3419.field_15245, 0.2f, level.field_9229.method_43057() * 0.25f + 0.8f);
            }
        } else if (this.dispenseType == DispenseType.DISPENSER) {
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof CopperPipeBlock) {
                CopperPipeBlock pipe = (CopperPipeBlock)class_22482;
                shotPower = pipe.dispenseShotPower;
                if (config.dispenseSounds) {
                    level.method_8396(null, pos, SimpleCopperPipesSoundEvents.LAUNCH, class_3419.field_15245, 0.2f, level.field_9229.method_43057() * 0.25f + 0.8f);
                }
            } else {
                shotPower = 12;
            }
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        boolean silent = state.method_26164(SimpleCopperPipesBlockTags.SILENT_COPPER_PIPES);
        if (level.method_8320(pos.method_10093(facing.method_10153())).method_26204() instanceof CopperFittingBlock) {
            shotItem = this.canonShoot(level, pos, stack, state, facing, shotPower, true, silent, config);
        } else {
            shotItem = this.canonShoot(level, pos, stack, state, facing, shotPower, false, silent, config);
            level.method_20290(2010, pos, facing.method_10146());
        }
        this.method_5447(slot, shotItem);
        return true;
    }

    private class_1799 canonShoot(class_3218 level, @NotNull class_2338 pos, class_1799 stack, @NotNull class_2680 state, class_2350 facing, int shotPower, boolean fitting, boolean silent, SimpleCopperPipesConfig config) {
        CopperPipeDispenseBehaviors.PoweredDispense poweredDispense;
        class_243 output = pos.method_46558().method_43206(facing, 0.7);
        class_1799 usableStack = stack;
        if (((Boolean)state.method_11654((class_2769)CopperPipeBlock.POWERED)).booleanValue() && (poweredDispense = CopperPipeDispenseBehaviors.getDispense((class_1935)usableStack.method_7909())) != null) {
            usableStack = stack.method_7971(1);
            poweredDispense.dispense(level, usableStack, shotPower, facing, (class_2374)output, state, pos, this);
            if (!fitting && !silent) {
                if (config.dispenseSounds) {
                    level.method_8396(null, pos, SimpleCopperPipesSoundEvents.ITEM_OUT, class_3419.field_15245, 0.2f, level.field_9229.method_43057() * 0.25f + 0.8f);
                }
                level.method_33596(null, (class_6880)class_5712.field_28738, pos);
            }
            return stack;
        }
        if (config.dispensing) {
            usableStack = stack.method_7971(1);
            level.method_20290(2000, pos, facing.method_10146());
            CopperPipeBlockEntity.spawnItem((class_1937)level, usableStack, shotPower, facing, output, facing);
            if (!silent) {
                level.method_33596(null, (class_6880)class_5712.field_28738, pos);
                if (config.dispenseSounds) {
                    level.method_8396(null, pos, SimpleCopperPipesSoundEvents.ITEM_OUT, class_3419.field_15245, 0.2f, level.field_9229.method_43057() * 0.25f + 0.8f);
                }
            }
        }
        return stack;
    }

    public int chooseNonEmptySlot(class_5819 random) {
        this.method_54873(null);
        int i = -1;
        int j = 1;
        for (int k = 0; k < this.inventory.size(); ++k) {
            if (((class_1799)this.inventory.get(k)).method_7960() || random.method_43048(j++) != 0) continue;
            i = k;
        }
        return i;
    }

    public void setCooldown(@NotNull class_2680 state) {
        int n;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CopperPipeBlock) {
            CopperPipeBlock pipe = (CopperPipeBlock)class_22482;
            n = pipe.getCooldown();
        } else {
            n = 2;
        }
        this.transferCooldown = n;
    }

    @Override
    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.transferCooldown = input.method_71424("transferCooldown", 0);
        this.dispenseCooldown = input.method_71424("dispenseCooldown", 0);
        this.noteBlockCooldown = input.method_71424("noteBlockCooldown", 0);
        this.canDispense = input.method_71433("canDispense", false);
        this.dispenseType = input.method_71426("dispenseType", DispenseType.CODEC).orElse(DispenseType.NONE);
        this.canAcceptGameEvents = input.method_71433("canAcceptGameEvents", false);
        this.vibrationData = input.method_71426("listener", class_8514.class_8515.field_44640).orElseGet(class_8514.class_8515::new);
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71465("transferCooldown", this.transferCooldown);
        output.method_71465("dispenseCooldown", this.dispenseCooldown);
        output.method_71465("noteBlockCooldown", this.noteBlockCooldown);
        output.method_71472("canDispense", this.canDispense);
        output.method_71468("dispenseType", DispenseType.CODEC, (Object)this.dispenseType);
        output.method_71472("canAcceptGameEvents", this.canAcceptGameEvents);
        output.method_71468("listener", class_8514.class_8515.field_44640, (Object)this.vibrationData);
    }

    public class_8514.class_5719 createVibrationUser() {
        return new VibrationUser(this.method_11016());
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    @NotNull
    public class_8514.class_8516 getListener() {
        return this.vibrationListener;
    }

    @Override
    public boolean canAcceptTransferableData(AbstractSimpleCopperBlockEntity.MoveType moveType, class_2350 moveDirection, class_2680 fromState) {
        if (moveType == AbstractSimpleCopperBlockEntity.MoveType.FROM_FITTING) {
            return this.method_11010().method_11654((class_2769)class_2741.field_12525) == moveDirection;
        }
        return this.method_11010().method_11654((class_2769)class_2741.field_12525) == moveDirection || moveDirection == fromState.method_11654((class_2769)class_2741.field_12525);
    }

    @Override
    public boolean canTransferDataInDirection(class_2350 direction, @NotNull class_2680 state) {
        return direction != ((class_2350)state.method_11654((class_2769)class_2741.field_12525)).method_10153();
    }

    @Override
    public void dispenseTransferableData(class_3218 level, class_2338 pos, class_2680 state) {
        if (!this.canDispense) {
            return;
        }
        ArrayList<TransferablePipeDataHandler.SaveableTransferablePipeData> list = this.transferableDataHandler.getSavedDataList();
        if (list.isEmpty()) {
            return;
        }
        for (TransferablePipeDataHandler.SaveableTransferablePipeData data : list) {
            if (!data.shouldMove()) continue;
            data.dispense(level, pos, state, this);
        }
        this.moveTransferableData(level, pos, state);
    }

    public static enum DispenseType implements class_3542
    {
        NONE("none"),
        DROPPER("dropper"),
        DISPENSER("dispenser");

        static final Codec<DispenseType> CODEC;
        private final String name;

        private DispenseType(String name) {
            this.name = name;
        }

        @NotNull
        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(DispenseType::values);
        }
    }

    public class VibrationUser
    implements class_8514.class_5719 {
        protected final class_2338 blockPos;
        private final class_5716 positionSource;

        public VibrationUser(class_2338 blockPos) {
            this.blockPos = blockPos;
            this.positionSource = new class_5707(blockPos);
        }

        public int method_49797() {
            return 8;
        }

        @NotNull
        public class_5716 method_51300() {
            return this.positionSource;
        }

        public boolean method_32970(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_5712.class_7397 context) {
            if (!SimpleCopperPipesConfig.get().senseGameEvents) {
                return false;
            }
            if (pos == this.blockPos && (gameEvent == class_5712.field_28165 || gameEvent == class_5712.field_28164)) {
                return false;
            }
            if (CopperPipeBlockEntity.this.canAcceptGameEvents) {
                CopperPipeBlockEntity.this.transferableDataHandler.addSaveableMoveablePipeNbt(new TransferablePipeDataHandler.SaveableTransferablePipeData((class_5712)gameEvent.comp_349(), pos.method_46558(), context, this.blockPos).withShouldMove(true).withShouldSave(true));
                return true;
            }
            return false;
        }

        public void method_32969(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_1297 entity, @Nullable class_1297 entity2, float f) {
        }

        public void method_42672() {
            CopperPipeBlockEntity.this.method_5431();
        }

        public boolean method_51363() {
            return true;
        }
    }
}

