/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.copper.block.entity;

import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.lunade.copper.block.CopperFittingBlock;
import net.lunade.copper.block.CopperPipeBlock;
import net.lunade.copper.block.entity.AbstractSimpleCopperBlockEntity;
import net.lunade.copper.block.entity.CopperPipeBlockEntity;
import net.lunade.copper.config.SimpleCopperPipesConfig;
import net.lunade.copper.registry.SimpleCopperPipesBlockEntityTypes;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class CopperFittingBlockEntity
extends AbstractSimpleCopperBlockEntity {
    private static final int MAX_TRANSFER_AMOUNT = 1;
    public int transferCooldown;

    public CopperFittingBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(SimpleCopperPipesBlockEntityTypes.COPPER_FITTING, blockPos, blockState, AbstractSimpleCopperBlockEntity.MoveType.FROM_FITTING);
    }

    public static boolean canTransfer(@NotNull class_1937 level, class_2338 pos, class_2350 direction, boolean to) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof CopperPipeBlockEntity)) {
            return false;
        }
        CopperPipeBlockEntity pipe = (CopperPipeBlockEntity)class_25862;
        class_2680 state = level.method_8320(pos);
        return (!to || pipe.transferCooldown <= 0) && state.method_28498(CopperPipeBlock.FACING) && state.method_11654(CopperPipeBlock.FACING) == direction;
    }

    public void method_5447(int i, class_1799 itemStack) {
        this.method_54873(null);
        if (itemStack == null) {
            return;
        }
        this.method_11282().set(i, (Object)itemStack);
        if (itemStack.method_7947() > this.method_5444()) {
            itemStack.method_7939(this.method_5444());
        }
    }

    @Override
    public void serverTick(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, SimpleCopperPipesConfig config) {
        super.serverTick(level, pos, state, config);
        if (level.method_8608()) {
            return;
        }
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        } else {
            this.fittingMove(level, pos, state);
        }
    }

    public void fittingMove(@NotNull class_1937 level, class_2338 pos, @NotNull class_2680 state) {
        boolean movedOut = state.method_28498((class_2769)class_2741.field_12484) && (Boolean)state.method_11654((class_2769)class_2741.field_12484) == false && this.moveOut(level, pos, level.field_9229);
        boolean movedIn = this.moveIn(level, pos, level.field_9229);
        if (movedOut || movedIn) {
            this.setCooldown(state);
            CopperFittingBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    private boolean moveIn(class_1937 level, @NotNull class_2338 pos, class_5819 random) {
        boolean result = false;
        for (class_2350 direction : class_156.method_43253((Object[])class_2350.values(), (class_5819)random)) {
            class_2350 opposite = direction.method_10153();
            class_2338 oppositePos = pos.method_10093(opposite);
            Storage<ItemVariant> inventory = CopperPipeBlockEntity.getStorageAt(level, oppositePos, direction);
            Storage<ItemVariant> fittingInventory = CopperPipeBlockEntity.getStorageAt(level, pos, opposite);
            if (inventory == null || fittingInventory == null || !CopperFittingBlockEntity.canTransfer(level, oppositePos, direction, false)) continue;
            for (StorageView storageView : inventory) {
                long inserted;
                if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
                Transaction transaction = Transaction.openOuter();
                ItemVariant resource = (ItemVariant)storageView.getResource();
                long extracted = inventory.extract((Object)resource, 1L, (TransactionContext)transaction);
                if (extracted > 0L && (inserted = CopperPipeBlockEntity.addItem(resource, fittingInventory, transaction)) > 0L) {
                    transaction.commit();
                    result = true;
                }
                transaction.close();
            }
        }
        return result;
    }

    private boolean moveOut(class_1937 level, @NotNull class_2338 pos, class_5819 random) {
        boolean result = false;
        for (class_2350 direction : class_156.method_43253((Object[])class_2350.values(), (class_5819)random)) {
            class_2338 offsetPos = pos.method_10093(direction);
            class_2350 opposite = direction.method_10153();
            Storage inventory = (Storage)ItemStorage.SIDED.find(level, offsetPos, level.method_8320(offsetPos), level.method_8321(offsetPos), (Object)opposite);
            Storage fittingInventory = (Storage)ItemStorage.SIDED.find(level, pos, level.method_8320(pos), level.method_8321(pos), (Object)direction);
            if (inventory == null || fittingInventory == null || !CopperFittingBlockEntity.canTransfer(level, offsetPos, direction, true)) continue;
            for (StorageView storageView : fittingInventory) {
                long extracted;
                if (storageView.isResourceBlank() || storageView.getAmount() <= 0L) continue;
                Transaction transaction = Transaction.openOuter();
                ItemVariant resource = (ItemVariant)storageView.getResource();
                long inserted = inventory.insert((Object)resource, 1L, (TransactionContext)transaction);
                if (inserted > 0L && (extracted = fittingInventory.extract((Object)resource, 1L, (TransactionContext)transaction)) > 0L) {
                    transaction.commit();
                    result = true;
                }
                transaction.close();
            }
        }
        return result;
    }

    public void setCooldown(@NotNull class_2680 state) {
        int n;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CopperFittingBlock) {
            CopperFittingBlock fitting = (CopperFittingBlock)class_22482;
            n = fitting.getCooldown();
        } else {
            n = 2;
        }
        this.transferCooldown = n;
    }

    @Override
    public boolean canAcceptTransferableData(AbstractSimpleCopperBlockEntity.MoveType moveType, class_2350 moveDirection, class_2680 fromState) {
        return moveType == AbstractSimpleCopperBlockEntity.MoveType.FROM_PIPE && moveDirection == fromState.method_11654((class_2769)class_2741.field_12525);
    }

    @Override
    public void updateBlockEntityValues(class_4538 level, class_2338 pos, @NotNull class_2680 state, SimpleCopperPipesConfig config) {
        if (state.method_26204() instanceof CopperFittingBlock) {
            this.canWater = (Boolean)state.method_11654((class_2769)class_2741.field_12508) != false && config.carryWater;
        }
    }

    @Override
    public void method_11014(@NotNull class_11368 input) {
        super.method_11014(input);
        this.transferCooldown = input.method_71424("transferCooldown", 0);
    }

    @Override
    protected void method_11007(@NotNull class_11372 output) {
        super.method_11007(output);
        output.method_71465("transferCooldown", this.transferCooldown);
    }
}

